/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.dialogs;

import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.dialogs.SelectableElement;
import org.eclipse.gmf.runtime.common.ui.dialogs.SelectedType;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIDebugOptions;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIPlugin;
import org.eclipse.gmf.runtime.common.ui.internal.dialogs.SelectableElementTreeSelectionChangedAndMouseAndKeyListener;
import org.eclipse.gmf.runtime.common.ui.internal.dialogs.SelectableElementsContentProvider;
import org.eclipse.gmf.runtime.common.ui.internal.dialogs.SelectableElementsTriStateLabelProvider;
import org.eclipse.gmf.runtime.common.ui.internal.l10n.CommonUIMessages;
import org.eclipse.gmf.runtime.common.ui.util.WindowUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ShowHideRelationshipsDialog
extends Dialog {
    private TreeViewer viewer;
    private Button ok;
    private Button cancel;
    private SelectableElement rootElement;
    private String helpContextId;
    private static int MAX_VIEWER_WIDTH = 400;
    private static int MAX_VIEWER_HEIGHT = 400;
    private static int TEXT_AREA_HEIGHT = 46;
    private int viewerWidth = MAX_VIEWER_WIDTH;
    Image selectedIcon;
    Image unselectedIcon;
    Image clearedIcon;

    static {
        try {
            MAX_VIEWER_WIDTH = Integer.parseInt(CommonUIMessages.ShowHideRelationshipsDialog_MAX_VIEWER_WIDTH);
            MAX_VIEWER_HEIGHT = Integer.parseInt(CommonUIMessages.ShowHideRelationshipsDialog_MAX_VIEWER_HEIGHT);
            TEXT_AREA_HEIGHT = Integer.parseInt(CommonUIMessages.ShowHideRelationshipsDialog_TEXT_AREA_HEIGHT);
        }
        catch (NumberFormatException e) {
            Trace.catching((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)CommonUIPlugin.getDefault())).getClass(), (String)"NumberFormatException", (Throwable)e);
            Log.error((Plugin)CommonUIPlugin.getDefault(), (int)5, (String)"Failed to parse Show Hide Relationships Dialog's localized size", (Throwable)e);
        }
    }

    public ShowHideRelationshipsDialog(Shell parentShell, SelectableElement aRootElement) {
        super(parentShell);
        this.rootElement = aRootElement.makeCopy();
        try {
            this.selectedIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)CommonUIPlugin.getPluginId(), (String)"icons/checkboxselected.gif").createImage();
            this.unselectedIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)CommonUIPlugin.getPluginId(), (String)"icons/checkboxunselected.gif").createImage();
            this.clearedIcon = AbstractUIPlugin.imageDescriptorFromPlugin((String)CommonUIPlugin.getPluginId(), (String)"icons/checkboxcleared.gif").createImage();
        }
        catch (Exception e) {
            Trace.catching((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"ShowHideRelationshipsDialog", (Throwable)e);
            Log.error((Plugin)CommonUIPlugin.getDefault(), (int)5, (String)"Failed to get legend icons for Show Hide Relationships Dialog", (Throwable)e);
            this.disposeImages();
            this.selectedIcon = null;
        }
    }

    protected TreeViewer getTreeViewer() {
        return this.viewer;
    }

    protected void setTreeViewer(TreeViewer aViewer) {
        this.viewer = aViewer;
    }

    protected void createViewer(Composite parent) {
        this.setTreeViewer(new TreeViewer(parent, 2564));
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.viewerWidth;
        int viewerHeight = SelectableElement.calculateNumberOfChildren(this.rootElement);
        GC gc = new GC((Drawable)this.getTreeViewer().getTree());
        Point size = gc.textExtent("");
        viewerHeight = viewerHeight * size.y + 64;
        gc.dispose();
        if (viewerHeight > MAX_VIEWER_HEIGHT) {
            viewerHeight = MAX_VIEWER_HEIGHT;
        }
        gridData.heightHint = viewerHeight;
        Tree tree = this.getTreeViewer().getTree();
        tree.setLayoutData((Object)gridData);
        tree.setLayout((Layout)new GridLayout(1, true));
        this.getTreeViewer().setUseHashlookup(true);
        SelectableElementTreeSelectionChangedAndMouseAndKeyListener listener = new SelectableElementTreeSelectionChangedAndMouseAndKeyListener(this.getTreeViewer()){

            @Override
            protected void switchCheckType(SelectableElement element) {
                if (element.getSelectedType() == SelectedType.LEAVE) {
                    element.setSelectedType(SelectedType.UNSELECTED);
                } else if (element.getSelectedType() == SelectedType.UNSELECTED) {
                    element.setSelectedType(SelectedType.SELECTED);
                } else if (element.getSelectedType() == SelectedType.SELECTED) {
                    element.setSelectedType(SelectedType.LEAVE);
                }
            }
        };
        this.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)listener);
        this.getTreeViewer().getTree().addMouseListener((MouseListener)listener);
        this.getTreeViewer().getTree().addKeyListener((KeyListener)listener);
    }

    protected void makeButtons(Composite parent) {
        Composite empty = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.heightHint = 20;
        empty.setLayoutData((Object)gridData);
        Composite right = new Composite(parent, 0);
        right.setLayout((Layout)new GridLayout(3, false));
        right.setLayoutData((Object)new GridData(128));
        this.ok = new Button(right, 8);
        this.ok.setText(CommonUIMessages.ShowHideRelationshipsDialog_Button_OK);
        this.ok.setLayoutData((Object)WindowUtil.makeFixedButtonData(this.ok));
        this.ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowHideRelationshipsDialog.this.performOk();
            }
        });
        this.cancel = new Button(right, 8);
        this.cancel.setText(CommonUIMessages.ShowHideRelationshipsDialog_Button_Cancel);
        this.cancel.setLayoutData((Object)WindowUtil.makeFixedButtonData(this.cancel));
        this.cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowHideRelationshipsDialog.this.setReturnCode(1);
                ShowHideRelationshipsDialog.this.disposeImages();
                ShowHideRelationshipsDialog.this.close();
            }
        });
    }

    private void createLineOfTextAtTop(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        this.viewerWidth = SelectableElement.calculateLongestStringLength(this.rootElement, (Control)top) + 96;
        if (this.viewerWidth > MAX_VIEWER_WIDTH) {
            this.viewerWidth = MAX_VIEWER_WIDTH;
        }
        gridData.widthHint = this.viewerWidth;
        gridData.heightHint = TEXT_AREA_HEIGHT;
        top.setLayoutData((Object)gridData);
        top.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(top, 64);
        label.setText(CommonUIMessages.ShowHideRelationshipsDialog_Description);
        label.setLayoutData((Object)new GridData(1808));
    }

    private void makeBlankBox(Composite parent) {
        Composite blankBox = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.heightHint = 10;
        blankBox.setLayoutData((Object)gridData);
    }

    private void createLegend(Composite parent) {
        int NUM_BOXES = 3;
        this.makeBlankBox(parent);
        Label label = new Label(parent, 0);
        label.setText(CommonUIMessages.ShowHideRelationshipsDialog_Label_Legend);
        Composite legendBox = new Composite(parent, 2048);
        GridData gridData = new GridData(768);
        legendBox.setLayoutData((Object)gridData);
        legendBox.setLayout((Layout)new GridLayout(3, true));
        Composite[] elements = new Composite[3];
        int i = 0;
        while (i < 3) {
            elements[i] = new Composite(legendBox, 0);
            gridData = new GridData(768);
            elements[i].setLayoutData((Object)gridData);
            elements[i].setLayout((Layout)new GridLayout(2, false));
            ++i;
        }
        label = new Label(elements[0], 0);
        label.setImage(this.selectedIcon);
        label = new Label(elements[0], 0);
        label.setText(CommonUIMessages.ShowHideRelationshipsDialog_Label_LegendShow);
        label.setLayoutData((Object)new GridData(1808));
        label = new Label(elements[1], 0);
        label.setImage(this.unselectedIcon);
        label = new Label(elements[1], 0);
        label.setText(CommonUIMessages.ShowHideRelationshipsDialog_Label_LegendHide);
        label.setLayoutData((Object)new GridData(1808));
        label = new Label(elements[2], 0);
        label.setImage(this.clearedIcon);
        label = new Label(elements[2], 0);
        label.setText(CommonUIMessages.ShowHideRelationshipsDialog_Label_LegendLeave);
        label.setLayoutData((Object)new GridData(1808));
        this.makeBlankBox(parent);
    }

    protected Control createContents(Composite parent) {
        this.createLineOfTextAtTop(parent);
        Composite bottom = new Composite(parent, 0);
        bottom.setLayoutData((Object)new GridData(1808));
        bottom.setLayout((Layout)new GridLayout(1, false));
        this.createViewer(bottom);
        if (this.selectedIcon != null) {
            this.createLegend(bottom);
        }
        this.makeButtons(bottom);
        this.viewer.setLabelProvider((IBaseLabelProvider)new SelectableElementsTriStateLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new SelectableElementsContentProvider());
        this.getTreeViewer().setInput((Object)this.rootElement);
        Tree tree = this.getTreeViewer().getTree();
        TreeItem[] treeItems = tree.getItems();
        assert (treeItems != null) : "treeItems cannot be null";
        assert (treeItems.length == 1) : "treeItems cannot be empty";
        tree.setSelection(treeItems);
        this.ok.setFocus();
        this.resetDialog();
        this.viewer.refresh();
        this.getShell().setText(CommonUIMessages.ShowHideRelationshipsDialog_Title);
        if (this.helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.helpContextId);
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.gmf.runtime.common.ui.egmf0100");
        }
        return parent;
    }

    protected void performOk() {
        this.disposeImages();
        this.setReturnCode(0);
        this.close();
    }

    void resetDialog() {
        this.viewer.expandAll();
    }

    public SelectableElement getRootElement() {
        return this.rootElement;
    }

    public List getSelectedRelationshipTypes() {
        if (this.rootElement == null) {
            return null;
        }
        return this.rootElement.getSelectedElementTypes();
    }

    public List getUnselectedRelationshipTypes() {
        if (this.rootElement == null) {
            return null;
        }
        return this.rootElement.getUnSelectedElementTypes();
    }

    public void initHelpContextId(String helpId) {
        this.helpContextId = helpId;
    }

    public void disposeImages() {
        if (this.selectedIcon != null && !this.selectedIcon.isDisposed()) {
            this.selectedIcon.dispose();
        }
        if (this.unselectedIcon != null && !this.unselectedIcon.isDisposed()) {
            this.unselectedIcon.dispose();
        }
        if (this.clearedIcon != null && !this.clearedIcon.isDisposed()) {
            this.clearedIcon.dispose();
        }
    }
}

