/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette.command;

import org.eclipse.wb.core.editor.palette.model.CategoryInfo;
import org.eclipse.wb.core.editor.palette.model.PaletteInfo;
import org.eclipse.wb.core.editor.palette.model.entry.ComponentEntryInfo;
import org.eclipse.wb.internal.core.editor.palette.command.ComponentAbstractCommand;
import org.xml.sax.Attributes;

public final class ComponentAddCommand
extends ComponentAbstractCommand {
    public static final String ID = "addComponent";
    private final String m_categoryId;

    public ComponentAddCommand(String id, String name, String description, boolean visible, String className, CategoryInfo category) {
        super(id, name, description, visible, className);
        this.m_categoryId = category.getId();
    }

    public ComponentAddCommand(Attributes attributes) {
        super(attributes);
        this.m_categoryId = attributes.getValue("category");
    }

    @Override
    public void execute(PaletteInfo palette) {
        ComponentEntryInfo component = new ComponentEntryInfo();
        component.setId(this.m_id);
        this.updateElement(component);
        CategoryInfo category = palette.getCategory(this.m_categoryId);
        category.addEntry(component);
    }

    @Override
    protected void addAttributes() {
        super.addAttributes();
        this.addAttribute("category", this.m_categoryId);
    }
}

