/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.wst.jsdt.debug.core.jsdi.Location;
import org.eclipse.wst.jsdt.debug.core.jsdi.ScriptReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.VirtualMachine;
import org.eclipse.wst.jsdt.debug.internal.crossfire.CrossFirePlugin;
import org.eclipse.wst.jsdt.debug.internal.crossfire.Tracing;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFLocation;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFMirror;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.CFRequestPacket;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.CFResponsePacket;
import org.eclipse.wst.jsdt.debug.internal.crossfire.transport.JSON;

public class CFScriptReference
extends CFMirror
implements ScriptReference {
    private String context_id = null;
    private String url = null;
    private int srclength = 0;
    private int linecount = 0;
    private int coloffset = 0;
    private int lineoffset = 0;
    private String source = null;
    private URI sourceuri = null;
    private List linelocs = new ArrayList();

    public CFScriptReference(VirtualMachine vm, String context_id, Map json) {
        super(vm);
        this.context_id = context_id;
        this.url = (String)json.get("url");
        this.initializeScript(json);
    }

    void initializeScript(Map json) {
        Number value = (Number)json.get("sourceLength");
        if (value != null) {
            this.srclength = value.intValue();
        }
        if ((value = (Number)json.get("lineCount")) != null) {
            this.linecount = value.intValue();
        }
        if ((value = (Number)json.get("lineOffset")) != null) {
            this.lineoffset = value.intValue();
        }
        if ((value = (Number)json.get("columnOffset")) != null) {
            this.coloffset = value.intValue();
        }
        this.source = (String)json.get("source");
        this.prepareLocations(this.linecount);
    }

    void prepareLocations(int lines) {
        this.linelocs.clear();
        int i = 1;
        while (i <= lines) {
            this.linelocs.add(new CFLocation(this.virtualMachine(), this, null, i));
            ++i;
        }
    }

    public List allLineLocations() {
        return Collections.unmodifiableList(this.linelocs);
    }

    public Location lineLocation(int lineNumber) {
        if (lineNumber <= this.linelocs.size()) {
            return (Location)this.linelocs.get(lineNumber - 1);
        }
        return null;
    }

    public List allFunctionLocations() {
        return null;
    }

    public Location functionLocation(String functionName) {
        return null;
    }

    public String url() {
        return this.url;
    }

    public String context() {
        return this.context_id;
    }

    public synchronized String source() {
        if (this.source == null) {
            CFRequestPacket request = new CFRequestPacket("scripts", this.context_id);
            request.setArgument("includeSource", Boolean.TRUE);
            request.setArgument("urls", Arrays.asList(this.url));
            CFResponsePacket response = this.crossfire().sendRequest(request);
            if (response.isSuccess()) {
                List list = (List)response.getBody().get("scripts");
                if (list != null && list.size() > 0) {
                    this.initializeScript((Map)list.get(0));
                }
            } else if (TRACE) {
                Tracing.writeString("SCRIPTREF [failed source request]: " + JSON.serialize(request));
            }
        }
        return this.source;
    }

    public synchronized URI sourceURI() {
        if (this.sourceuri == null) {
            try {
                this.sourceuri = URIUtil.fromString((String)this.url);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    this.sourceuri = CrossFirePlugin.fileURI((IPath)new Path(this.url));
                }
                catch (URISyntaxException e) {
                    CrossFirePlugin.log(e);
                }
            }
            catch (URISyntaxException urise) {
                CrossFirePlugin.log(urise);
            }
        }
        return this.sourceuri;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Crossfire ScriptReference: [context_id - ").append(this.context_id).append("]");
        buffer.append(" [url - ").append(this.url).append("]");
        buffer.append(" [srclength - ").append(this.srclength).append("]");
        buffer.append(" [linecount - ").append(this.linecount).append("]");
        buffer.append(" [lineoffset - ").append(this.lineoffset).append("]");
        buffer.append(" [coloffset - ").append(this.coloffset).append("]");
        buffer.append("\nSource: \n").append(this.source);
        return buffer.toString();
    }
}

