/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.common;

import oshi.annotation.concurrent.Immutable;
import oshi.hardware.Printer;

@Immutable
public abstract class AbstractPrinter
implements Printer {
    private final String name;
    private final String driverName;
    private final String description;
    private final Printer.PrinterStatus status;
    private final String statusReason;
    private final boolean isDefault;
    private final boolean isLocal;
    private final String portName;

    protected AbstractPrinter(String name, String driverName, String description, Printer.PrinterStatus status, String statusReason, boolean isDefault, boolean isLocal, String portName) {
        this.name = name;
        this.driverName = driverName;
        this.description = description;
        this.status = status;
        this.statusReason = statusReason;
        this.isDefault = isDefault;
        this.isLocal = isLocal;
        this.portName = portName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDriverName() {
        return this.driverName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Printer.PrinterStatus getStatus() {
        return this.status;
    }

    @Override
    public String getStatusReason() {
        return this.statusReason;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    @Override
    public String getPortName() {
        return this.portName;
    }

    public String toString() {
        return "Printer [name=" + this.name + ", driverName=" + this.driverName + ", description=" + this.description + ", status=" + (Object)((Object)this.status) + ", statusReason=" + this.statusReason + ", isDefault=" + this.isDefault + ", isLocal=" + this.isLocal + ", portName=" + AbstractPrinter.redactPortName(this.portName) + "]";
    }

    private static String redactPortName(String portName) {
        int atIndex;
        if (portName == null || portName.isEmpty()) {
            return "";
        }
        int schemeEnd = portName.indexOf("://");
        if (schemeEnd > 0 && (atIndex = portName.indexOf(64, schemeEnd + 3)) > schemeEnd + 3) {
            return portName.substring(0, schemeEnd + 3) + "***" + portName.substring(atIndex);
        }
        return portName;
    }
}

