/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.Immutable;
import oshi.hardware.Printer;
import oshi.hardware.common.AbstractPrinter;
import oshi.jna.platform.unix.Cups;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

@Immutable
public final class UnixPrinter
extends AbstractPrinter {
    private static final Logger LOG = LoggerFactory.getLogger(UnixPrinter.class);
    private static final String[] LOCAL_URI_PREFIXES = new String[]{"usb:", "parallel:", "serial:", "file:", "direct:", "hp:", "lpd://127.", "lpd://localhost", "socket://127.", "socket://localhost"};
    private static final boolean HAS_CUPS;

    UnixPrinter(String name, String driverName, String description, Printer.PrinterStatus status, String statusReason, boolean isDefault, boolean isLocal, String portName) {
        super(name, driverName, description, status, statusReason, isDefault, isLocal, portName);
    }

    public static List<Printer> getPrinters() {
        if (HAS_CUPS) {
            return UnixPrinter.getPrintersFromLibCups();
        }
        return UnixPrinter.getPrintersFromLpstat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Printer> getPrintersFromLibCups() {
        ArrayList<Printer> printers = new ArrayList<Printer>();
        PointerByReference destsRef = new PointerByReference();
        int numDests = Cups.INSTANCE.cupsGetDests(destsRef);
        Pointer destsPtr = destsRef.getValue();
        if (destsPtr != null && numDests > 0) {
            try {
                Cups.CupsDest[] dests;
                for (Cups.CupsDest dest : dests = (Cups.CupsDest[])new Cups.CupsDest(destsPtr).toArray(numDests)) {
                    if (dest.name == null) continue;
                    String name = dest.name;
                    boolean isDefault = dest.is_default != 0;
                    String deviceUri = "";
                    String printerInfo = "";
                    String printerMakeModel = "";
                    String printerState = "";
                    String stateReasons = "";
                    if (dest.num_options > 0 && dest.options != null) {
                        deviceUri = UnixPrinter.getOption(dest, "device-uri");
                        printerInfo = UnixPrinter.getOption(dest, "printer-info");
                        printerMakeModel = UnixPrinter.getOption(dest, "printer-make-and-model");
                        printerState = UnixPrinter.getOption(dest, "printer-state");
                        stateReasons = UnixPrinter.getOption(dest, "printer-state-reasons");
                    }
                    Printer.PrinterStatus status = UnixPrinter.parseStateFromCups(printerState, stateReasons);
                    String statusReason = "none".equals(stateReasons) ? "" : stateReasons;
                    int printerType = ParseUtil.parseIntOrDefault(UnixPrinter.getOption(dest, "printer-type"), 0);
                    boolean isLocal = (printerType & 2) == 0;
                    printers.add(new UnixPrinter(name, printerMakeModel, printerInfo, status, statusReason, isDefault, isLocal, deviceUri));
                }
            }
            finally {
                Cups.INSTANCE.cupsFreeDests(numDests, destsPtr);
            }
        }
        return printers;
    }

    private static String getOption(Cups.CupsDest dest, String optionName) {
        String value = Cups.INSTANCE.cupsGetOption(optionName, dest.num_options, dest.options);
        return value != null ? value : "";
    }

    private static Printer.PrinterStatus parseStateFromCups(String state, String stateReasons) {
        String lower;
        if (!stateReasons.isEmpty() && !"none".equals(stateReasons) && ((lower = stateReasons.toLowerCase(Locale.ROOT)).contains("error") || lower.contains("fault"))) {
            return Printer.PrinterStatus.ERROR;
        }
        if (state.isEmpty()) {
            return Printer.PrinterStatus.UNKNOWN;
        }
        int stateInt = ParseUtil.parseIntOrDefault(state, -1);
        switch (stateInt) {
            case 3: {
                return Printer.PrinterStatus.IDLE;
            }
            case 4: {
                return Printer.PrinterStatus.PRINTING;
            }
            case 5: {
                return Printer.PrinterStatus.OFFLINE;
            }
        }
        return Printer.PrinterStatus.UNKNOWN;
    }

    private static List<Printer> getPrintersFromLpstat() {
        ArrayList<Printer> printers = new ArrayList<Printer>();
        String defaultPrinter = UnixPrinter.getDefaultPrinter();
        Map<String, String> portMap = UnixPrinter.parsePortMap();
        Map<String, String> descriptionMap = UnixPrinter.parseDescriptionMap();
        for (String line : ExecutingCommand.runNative(new String[]{"lpstat", "-p"})) {
            String[] parts;
            if (!line.startsWith("printer ") || (parts = line.split("\\s+")).length < 3) continue;
            String name = parts[1];
            Printer.PrinterStatus status = UnixPrinter.parseStatusFromLpstat(line);
            boolean isDefault = name.equals(defaultPrinter);
            String portName = portMap.getOrDefault(name, "");
            boolean isLocal = UnixPrinter.isLocalUri(portName);
            String driverName = UnixPrinter.getDriverForPrinter(name);
            String description = descriptionMap.getOrDefault(name, "");
            String statusReason = UnixPrinter.getStatusReasonFromLpstat(line);
            printers.add(new UnixPrinter(name, driverName, description, status, statusReason, isDefault, isLocal, portName));
        }
        return printers;
    }

    private static Map<String, String> parsePortMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String line : ExecutingCommand.runNative(new String[]{"lpstat", "-v"})) {
            int forIdx;
            int colonIdx;
            if (!line.contains("device for") || (colonIdx = line.indexOf(58, forIdx = line.indexOf("device for ") + 11)) <= forIdx) continue;
            String name = line.substring(forIdx, colonIdx).trim();
            String uri = line.substring(colonIdx + 1).trim();
            map.put(name, uri);
        }
        return map;
    }

    private static Map<String, String> parseDescriptionMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        String currentPrinter = null;
        for (String line : ExecutingCommand.runNative(new String[]{"lpstat", "-l", "-p"})) {
            if (line.startsWith("printer ")) {
                String[] parts = line.split("\\s+");
                if (parts.length < 2) continue;
                currentPrinter = parts[1];
                continue;
            }
            if (currentPrinter == null || !line.trim().startsWith("Description:")) continue;
            String desc = line.substring(line.indexOf(58) + 1).trim();
            map.put(currentPrinter, desc);
        }
        return map;
    }

    private static String getDriverForPrinter(String printerName) {
        for (String line : ExecutingCommand.runNative(new String[]{"lpoptions", "-p", printerName})) {
            int start;
            int end;
            int idx = line.indexOf("printer-make-and-model='");
            if (idx < 0 || (end = line.indexOf(39, start = idx + 24)) <= start) continue;
            return line.substring(start, end);
        }
        return "";
    }

    private static String getDefaultPrinter() {
        for (String line : ExecutingCommand.runNative(new String[]{"lpstat", "-d"})) {
            String[] parts;
            if (!line.contains("default destination:") || (parts = line.split(":", 2)).length < 2) continue;
            return parts[1].trim();
        }
        return "";
    }

    private static Printer.PrinterStatus parseStatusFromLpstat(String line) {
        String lower = line.toLowerCase(Locale.ROOT);
        if (lower.contains("disabled") || lower.contains("not accepting")) {
            return Printer.PrinterStatus.OFFLINE;
        }
        if (lower.contains("printing")) {
            return Printer.PrinterStatus.PRINTING;
        }
        if (lower.contains("idle")) {
            return Printer.PrinterStatus.IDLE;
        }
        if (lower.contains("error") || lower.contains("fault")) {
            return Printer.PrinterStatus.ERROR;
        }
        return Printer.PrinterStatus.UNKNOWN;
    }

    private static String getStatusReasonFromLpstat(String line) {
        int dashIdx = line.indexOf(" - ");
        if (dashIdx > 0) {
            return line.substring(dashIdx + 3).trim();
        }
        return "";
    }

    private static boolean isLocalUri(String uri) {
        if (uri.startsWith("/dev")) {
            return true;
        }
        for (String prefix : LOCAL_URI_PREFIXES) {
            if (!uri.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    static {
        boolean hasCups = false;
        try {
            Cups lib = Cups.INSTANCE;
            hasCups = true;
        }
        catch (UnsatisfiedLinkError e) {
            LOG.debug("libcups not found. Falling back to lpstat command.");
        }
        HAS_CUPS = hasCups;
    }
}

