/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.platform.win32.COM.WbemcliUtil;
import java.util.ArrayList;
import java.util.List;
import oshi.annotation.concurrent.Immutable;
import oshi.driver.windows.wmi.Win32Printer;
import oshi.hardware.Printer;
import oshi.hardware.common.AbstractPrinter;
import oshi.util.platform.windows.WmiUtil;

@Immutable
final class WindowsPrinter
extends AbstractPrinter {
    private static final String[] ERROR_STATE_NAMES = new String[]{"Unknown", "Other", "", "Low Paper", "No Paper", "Low Toner", "No Toner", "Door Open", "Jammed", "Offline", "Service Requested", "Output Bin Full"};

    WindowsPrinter(String name, String driverName, String description, Printer.PrinterStatus status, String statusReason, boolean isDefault, boolean isLocal, String portName) {
        super(name, driverName, description, status, statusReason, isDefault, isLocal, portName);
    }

    public static List<Printer> getPrinters() {
        ArrayList<Printer> printers = new ArrayList<Printer>();
        WbemcliUtil.WmiResult<Win32Printer.PrinterProperty> result = Win32Printer.queryPrinters();
        for (int i = 0; i < result.getResultCount(); ++i) {
            String name = WmiUtil.getString(result, Win32Printer.PrinterProperty.NAME, i);
            String driverName = WmiUtil.getString(result, Win32Printer.PrinterProperty.DRIVERNAME, i);
            String description = WmiUtil.getString(result, Win32Printer.PrinterProperty.DESCRIPTION, i);
            int statusCode = WmiUtil.getUint16(result, Win32Printer.PrinterProperty.PRINTERSTATUS, i);
            int errorState = WmiUtil.getUint16(result, Win32Printer.PrinterProperty.DETECTEDERRORSTATE, i);
            boolean isDefault = WindowsPrinter.getBooleanValue(result, Win32Printer.PrinterProperty.DEFAULT, i);
            boolean isLocal = WindowsPrinter.getBooleanValue(result, Win32Printer.PrinterProperty.LOCAL, i);
            String portName = WmiUtil.getString(result, Win32Printer.PrinterProperty.PORTNAME, i);
            printers.add(new WindowsPrinter(name, driverName, description, WindowsPrinter.parseStatus(statusCode, errorState), WindowsPrinter.parseErrorState(errorState), isDefault, isLocal, portName));
        }
        return printers;
    }

    private static boolean getBooleanValue(WbemcliUtil.WmiResult<Win32Printer.PrinterProperty> result, Win32Printer.PrinterProperty property, int index) {
        Object o = result.getValue((Enum)property, index);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    private static Printer.PrinterStatus parseStatus(int statusCode, int errorState) {
        if (errorState == 4 || errorState == 6 || errorState >= 7) {
            return Printer.PrinterStatus.ERROR;
        }
        switch (statusCode) {
            case 1: 
            case 2: {
                return Printer.PrinterStatus.UNKNOWN;
            }
            case 3: {
                return Printer.PrinterStatus.IDLE;
            }
            case 4: {
                return Printer.PrinterStatus.PRINTING;
            }
            case 5: {
                return Printer.PrinterStatus.IDLE;
            }
            case 6: 
            case 7: {
                return Printer.PrinterStatus.OFFLINE;
            }
        }
        return Printer.PrinterStatus.UNKNOWN;
    }

    private static String parseErrorState(int errorState) {
        if (errorState >= 0 && errorState < ERROR_STATE_NAMES.length) {
            return ERROR_STATE_NAMES[errorState];
        }
        return "";
    }
}

