/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.JavaClass;
import org.burningwave.core.classes.MemoryClassLoader;
import org.burningwave.core.concurrent.QueuedTaskExecutor;
import org.burningwave.core.io.FileSystemItem;
import org.burningwave.core.io.PathHelper;

public class PathScannerClassLoader
extends MemoryClassLoader {
    Map<String, Boolean> loadedPaths;
    PathHelper pathHelper;
    FileSystemItem.Criteria fileFilterAndProcessor;
    BiFunction<Throwable, FileSystemItem[], Boolean> exceptionHandler;

    protected PathScannerClassLoader(ClassLoader parentClassLoader, PathHelper pathHelper, FileSystemItem.Criteria fileFilter) {
        super(parentClassLoader);
        this.pathHelper = pathHelper;
        this.loadedPaths = new ConcurrentHashMap<String, Boolean>();
        this.exceptionHandler = (exc, childAndPath) -> {
            if (this.isClosed) {
                throw new IllegalStateException(StaticComponentContainer.Strings.compile("Could not execute the operation: {} is closed", this));
            }
            StaticComponentContainer.ManagedLoggerRepository.logError(this.getClass()::getName, "Exception occurred while scanning {}", (Throwable)exc, (Object)childAndPath[0].getAbsolutePath());
            return false;
        };
        if (fileFilter != null) {
            this.setFileFilter(fileFilter);
        }
    }

    void setFileFilter(FileSystemItem.Criteria scanFileCriteria) {
        this.fileFilterAndProcessor = ((FileSystemItem.Criteria)scanFileCriteria.createCopy().and()).allFileThat((child, pathFIS) -> {
            JavaClass javaClass = child.toJavaClass();
            this.addByteCode0(javaClass.getName(), javaClass.getByteCode());
            return true;
        }).setExceptionHandler(scanFileCriteria.getExceptionHandler() != null ? scanFileCriteria.getExceptionHandler() : this.exceptionHandler);
    }

    public static PathScannerClassLoader create(ClassLoader parentClassLoader, PathHelper pathHelper, FileSystemItem.Criteria scanFileCriteria) {
        return new PathScannerClassLoader(parentClassLoader, pathHelper, scanFileCriteria);
    }

    public PathScannerClassLoader refresh() {
        Set<String> loadedPaths = this.loadedPaths.keySet();
        for (String loadedPath : loadedPaths) {
            FileSystemItem.ofPath(loadedPath).reset();
        }
        this.scanPathsAndAddAllByteCodesFound(loadedPaths);
        return this;
    }

    public Collection<String> scanPathsWithoutRefreshingAndAddAllByteCodesFound(Collection<String> paths) {
        return this.scanPathsAndAddAllByteCodesFound(paths, path -> false);
    }

    public Collection<String> scanPathsAndAddAllByteCodesFound(Collection<String> paths) {
        return this.scanPathsAndAddAllByteCodesFound(paths, path -> true);
    }

    public Collection<String> scanPathsAndAddAllByteCodesFound(Collection<String> paths, Predicate<String> checkForAddedClasses) {
        HashSet<String> scannedPaths = new HashSet<String>();
        try {
            for (String path : paths) {
                if (!checkForAddedClasses.test(path) && this.hasBeenCompletelyLoaded(path)) continue;
                StaticComponentContainer.Synchronizer.execute(this.instanceId + "_" + path, () -> {
                    if (checkForAddedClasses.test(path) || !this.hasBeenCompletelyLoaded(path)) {
                        FileSystemItem pathFIS = FileSystemItem.ofPath(path);
                        if (checkForAddedClasses.test(path)) {
                            pathFIS.refresh();
                        }
                        Predicate<FileSystemItem[]> classFilePredicateAndConsumer = this.fileFilterAndProcessor.getPredicateOrTruePredicateIfPredicateIsNull();
                        for (FileSystemItem child : pathFIS.getAllChildren()) {
                            classFilePredicateAndConsumer.test(new FileSystemItem[]{child, pathFIS});
                        }
                        this.loadedPaths.put(path, Boolean.TRUE);
                        scannedPaths.add(path);
                    }
                });
            }
        }
        catch (Throwable exc) {
            if (this.isClosed) {
                StaticComponentContainer.ManagedLoggerRepository.logWarn(this.getClass()::getName, "Could not execute scanPathsAndAddAllByteCodesFound because {} has been closed", this.toString());
            }
            throw exc;
        }
        return scannedPaths;
    }

    public URL[] getURLs() {
        Collection urls = this.loadedPaths.keySet().stream().map(absolutePath -> FileSystemItem.ofPath(absolutePath).getURL()).collect(Collectors.toSet());
        return urls.toArray(new URL[urls.size()]);
    }

    @Override
    public URL getResource(String name) {
        URL url = StaticComponentContainer.Resources.get(name, this.allParents);
        if (url != null) {
            return url;
        }
        AtomicReference inputStreamWrapper = new AtomicReference();
        FileSystemItem.Criteria scanFileCriteria = FileSystemItem.Criteria.forAllFileThat(child -> {
            if (child.isFile() && child.getAbsolutePath().endsWith("/" + name)) {
                inputStreamWrapper.set(child.getURL());
                return true;
            }
            return false;
        }).setExceptionHandler(this.exceptionHandler);
        for (String loadedPath : this.loadedPaths.keySet()) {
            FileSystemItem.ofPath(loadedPath).findFirstInAllChildren(scanFileCriteria);
            if (inputStreamWrapper.get() == null) continue;
            return (URL)inputStreamWrapper.get();
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Collection<URL> resourcesFound = StaticComponentContainer.Resources.getAll(name, this.allParents);
        FileSystemItem.Criteria scanFileCriteria = FileSystemItem.Criteria.forAllFileThat(child -> {
            if (child.isFile() && child.getAbsolutePath().endsWith("/" + name)) {
                resourcesFound.add(child.getURL());
                return true;
            }
            return false;
        }).setExceptionHandler(this.exceptionHandler);
        for (String loadedPath : this.loadedPaths.keySet()) {
            FileSystemItem.ofPath(loadedPath).findInAllChildren(scanFileCriteria);
        }
        return Collections.enumeration(resourcesFound);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream inputStream = super.getResourceAsStream(name);
        if (inputStream != null) {
            return inputStream;
        }
        AtomicReference inputStreamWrapper = new AtomicReference();
        FileSystemItem.Criteria scanFileCriteria = FileSystemItem.Criteria.forAllFileThat(child -> {
            if (child.isFile() && child.getAbsolutePath().endsWith("/" + name)) {
                inputStreamWrapper.set(child.toInputStream());
                return true;
            }
            return false;
        }).setExceptionHandler(this.exceptionHandler);
        for (String loadedPath : this.loadedPaths.keySet()) {
            FileSystemItem.ofPath(loadedPath).findFirstInAllChildren(scanFileCriteria);
            if (inputStreamWrapper.get() == null) continue;
            return (InputStream)inputStreamWrapper.get();
        }
        return null;
    }

    public boolean hasBeenCompletelyLoaded(String path) {
        Boolean hasBeenCompletelyLoaded = this.loadedPaths.get(path);
        if (hasBeenCompletelyLoaded != null && hasBeenCompletelyLoaded.booleanValue()) {
            return true;
        }
        FileSystemItem pathFIS = FileSystemItem.ofPath(path);
        for (String loadedPath : StaticComponentContainer.ClassLoaders.getAllLoadedPaths(StaticComponentContainer.ClassLoaders.getParent(this))) {
            FileSystemItem loadedPathFIS = FileSystemItem.ofPath(loadedPath);
            try {
                if (!pathFIS.isChildOf(loadedPathFIS) && !pathFIS.equals(loadedPathFIS)) continue;
                return true;
            }
            catch (NullPointerException exc) {
                if (!loadedPathFIS.refresh().exists() || !pathFIS.refresh().exists()) continue;
                throw exc;
            }
        }
        return false;
    }

    @Override
    protected QueuedTaskExecutor.Task closeResources() {
        return this.closeResources(PathScannerClassLoader.class.getName() + "@" + System.identityHashCode(this), () -> this.loadedPaths == null, task -> {
            super.closeResources().waitForFinish();
            this.loadedPaths.clear();
            this.loadedPaths = null;
            this.pathHelper = null;
            this.fileFilterAndProcessor = null;
            if (this.getClass().equals(PathScannerClassLoader.class)) {
                StaticComponentContainer.ManagedLoggerRepository.logInfo(this.getClass()::getName, "ClassLoader {} successfully closed", this);
            }
        });
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    public static abstract class Configuration {
        public static final Map<String, Object> DEFAULT_VALUES;

        static {
            HashMap<String, Object> defaultValues = new HashMap<String, Object>();
            defaultValues = new HashMap();
            defaultValues.put("path-scanner-class-loader.parent.supplier.imports", "${code-executor.common.imports}" + StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator() + "${" + "path-scanner-class-loader.parent" + "." + "supplier" + ".additional-imports}" + StaticComponentContainer.IterableObjectHelper.getDefaultValuesSeparator());
            defaultValues.put("path-scanner-class-loader.parent.supplier.name", PathScannerClassLoader.class.getPackage().getName() + ".ParentClassLoaderRetrieverForPathScannerClassLoader");
            defaultValues.put("path-scanner-class-loader.parent", Thread.currentThread().getContextClassLoader());
            defaultValues.put("path-scanner-class-loader.search-config.check-file-option", FileSystemItem.CheckingOption.FOR_NAME.getLabel());
            DEFAULT_VALUES = Collections.unmodifiableMap(defaultValues);
        }

        public static abstract class Key {
            public static final String PARENT_CLASS_LOADER = "path-scanner-class-loader.parent";
            public static final String SEARCH_CONFIG_CHECK_FILE_OPTION = "path-scanner-class-loader.search-config.check-file-option";
        }
    }
}

