/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.ui.view;

import java.util.ArrayList;
import org.eclipse.cdt.testsrunner.model.ITestItem;

public class TestPathUtils {
    private static final String TEST_PATH_PART_DELIMITER = "\n";
    private static final String TEST_PATH_DELIMITER = ".";

    public static String getTestItemPath(ITestItem testItem) {
        StringBuilder itemPath = new StringBuilder();
        ArrayList<ITestItem> parentItems = new ArrayList<ITestItem>();
        while (testItem != null) {
            parentItems.add(testItem);
            testItem = testItem.getParent();
        }
        if (!parentItems.isEmpty()) {
            int i = parentItems.size() - 2;
            while (i >= 0) {
                itemPath.append(((ITestItem)parentItems.get(i)).getName());
                if (i != 0) {
                    itemPath.append(TEST_PATH_DELIMITER);
                }
                --i;
            }
        }
        return itemPath.toString();
    }

    public static String[][] unpackTestPaths(String[] testPaths) {
        String[][] result = new String[testPaths.length][];
        int i = 0;
        while (i < result.length) {
            result[i] = testPaths[i].split(TEST_PATH_PART_DELIMITER);
            ++i;
        }
        return result;
    }

    public static String[] packTestPaths(ITestItem[] testItems) {
        String[] result = new String[testItems.length];
        ArrayList<String> testPath = new ArrayList<String>();
        int itemIdx = 0;
        while (itemIdx < testItems.length) {
            testPath.clear();
            ITestItem item = testItems[itemIdx];
            while (item != null) {
                if (item.getParent() != null) {
                    testPath.add(item.getName());
                }
                item = item.getParent();
            }
            StringBuilder sb = new StringBuilder();
            boolean needDelimiter = false;
            int pathPartIdx = testPath.size() - 1;
            while (pathPartIdx >= 0) {
                if (needDelimiter) {
                    sb.append(TEST_PATH_PART_DELIMITER);
                } else {
                    needDelimiter = true;
                }
                sb.append((String)testPath.get(pathPartIdx));
                --pathPartIdx;
            }
            result[itemIdx] = sb.toString();
            ++itemIdx;
        }
        return result;
    }
}

