/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.logical;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.compare.ide.logical.IModelInclusionTester;

public class ModelInclusionTesterRegistry {
    private Map<String, IModelInclusionTester> registeredTesters = new LinkedHashMap<String, IModelInclusionTester>();

    public Collection<IModelInclusionTester> getModelInclusionTesters() {
        return this.registeredTesters.values();
    }

    public void add(String key, IModelInclusionTester modelInclusionTester) {
        this.registeredTesters.put((String)Preconditions.checkNotNull((Object)key), (IModelInclusionTester)Preconditions.checkNotNull((Object)modelInclusionTester));
    }

    public boolean remove(String key) {
        return this.registeredTesters.remove(key) != null;
    }

    public void clear() {
        this.registeredTesters.clear();
    }

    public boolean anyTesterIncludes(IFile file) {
        for (IModelInclusionTester tester : this.registeredTesters.values()) {
            if (!tester.shouldInclude(file)) continue;
            return true;
        }
        return false;
    }
}

