/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.common.property;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.graphiti.examples.common.property.TypeMapper;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.tabbed.ITypeMapper;

public class PropertiesLabelProvider
extends LabelProvider {
    private ITypeMapper typeMapper = new TypeMapper();

    public Image getImage(Object objects) {
        if (objects == null || objects.equals(StructuredSelection.EMPTY)) {
            return null;
        }
        boolean[] multiple = new boolean[1];
        Object object = this.getObject(objects, multiple);
        if (object == null) {
            return null;
        }
        if (!(object instanceof EditPart)) {
            return null;
        }
        return null;
    }

    public String getText(Object objects) {
        if (objects == null || objects.equals(StructuredSelection.EMPTY)) {
            return "No items selected";
        }
        boolean[] multiple = new boolean[1];
        Object object = this.getObject(objects, multiple);
        if (object == null || ((IStructuredSelection)objects).size() > 1) {
            return ((IStructuredSelection)objects).size() + " items selected";
        }
        if (object instanceof EditPart) {
            object = ((EditPart)object).getModel();
        }
        if (object instanceof EObject) {
            EObject robj = (EObject)object;
            if (robj instanceof PictogramElement) {
                EClass refMetaObject;
                PictogramElement pe = (PictogramElement)robj;
                EObject businessObject = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
                if (businessObject == null) {
                    businessObject = robj;
                }
                if ((refMetaObject = businessObject.eClass()) instanceof ENamedElement) {
                    return ((ENamedElement)refMetaObject).getName();
                }
                return "";
            }
            return robj.eClass().getClass().getName();
        }
        return object.toString();
    }

    private Object getObject(Object objects, boolean[] multiple) {
        Assert.isNotNull((Object)objects);
        Object object = null;
        if (objects instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)objects;
            object = selection.getFirstElement();
            if (selection.size() == 1) {
                multiple[0] = false;
                return object;
            }
            multiple[0] = true;
            Class firstClass = this.typeMapper.mapType(object);
            if (selection.size() > 1) {
                for (Object next : selection) {
                    Class nextClass = this.typeMapper.mapType(next);
                    if (nextClass.equals(firstClass)) continue;
                    multiple[0] = false;
                    object = null;
                    break;
                }
            }
        } else {
            multiple[0] = false;
            object = objects;
        }
        return object;
    }
}

