/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.workflow.ui.internal.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.modisco.common.core.Logger;
import org.eclipse.modisco.workflow.core.WorkflowModel;
import org.eclipse.modisco.workflow.modiscoworkflow.Element;
import org.eclipse.modisco.workflow.modiscoworkflow.ModiscoworkflowFactory;
import org.eclipse.modisco.workflow.ui.internal.Activator;
import org.eclipse.modisco.workflow.ui.internal.Messages;
import org.eclipse.modisco.workflow.ui.internal.wizard.LaunchersPage;
import org.eclipse.swt.widgets.TableItem;

public class WizardToSelectLaunchers
extends Wizard {
    private LaunchersPage loadLauncher;
    private final WorkflowModel workflowModel;

    public WizardToSelectLaunchers(WorkflowModel workflowModelParam) {
        this.setWindowTitle(Messages.WizardToSelectLaunchers_selectLaunch);
        this.workflowModel = workflowModelParam;
    }

    public final void addPages() {
        this.loadLauncher = new LaunchersPage(this.workflowModel.getName());
        this.addPage((IWizardPage)this.loadLauncher);
    }

    public boolean performFinish() {
        try {
            TableItem[] tableItemArray = this.loadLauncher.getItemsSelected();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                ILaunchConfiguration launchConfiguration = this.loadLauncher.getLaunchConfigurationMap().get(item);
                String type = launchConfiguration.getType().getIdentifier();
                Object element = type.equals("org.eclipse.modisco.workflow.launchType") ? ModiscoworkflowFactory.eINSTANCE.createWorkflow() : ModiscoworkflowFactory.eINSTANCE.createWork();
                element.setName(item.getText());
                element.setType(type);
                this.workflowModel.addElement((Element)element);
                ++n2;
            }
        }
        catch (CoreException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return true;
    }
}

