/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.launch;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.debug.core.debugger.parameters.IDebugParametersInitializer;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.DebugSessionIdGenerator;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugParametersInitializersRegistry;
import org.eclipse.php.internal.debug.core.zend.debugger.PHPSessionLaunchMapper;
import org.eclipse.php.internal.debug.core.zend.debugger.ProcessCrashDetector;
import org.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerSettingsUtil;
import org.eclipse.php.internal.debug.daemon.DaemonPlugin;
import org.eclipse.php.phpunit.PHPUnitPlugin;
import org.eclipse.php.phpunit.ui.launch.PHPUnitBasicLauncher;
import org.eclipse.php.phpunit.ui.launch.PHPUnitOptionsList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PHPUnitZDLauncher
extends PHPUnitBasicLauncher {
    public PHPUnitZDLauncher(ILaunchConfiguration configuration, ILaunch launch, PHPUnitOptionsList optionsList) {
        super(configuration, launch, optionsList);
    }

    @Override
    protected void launchDebugMode(String fileName, File workingDir, String phpExeString, IProject project, Map<String, String> envVariables, IProgressMonitor monitor) throws CoreException {
        this.launchDebugOrProfileMode(fileName, workingDir, phpExeString, project, envVariables, monitor);
    }

    @Override
    protected void launchProfileMode(String fileName, File workingDir, String phpExeString, IProject project, Map<String, String> envVariables, IProgressMonitor monitor) throws CoreException {
        this.launchDebugOrProfileMode(fileName, workingDir, phpExeString, project, envVariables, monitor);
    }

    private void launchDebugOrProfileMode(String fileName, File workingDir, String phpExeString, IProject project, Map<String, String> envVariables, IProgressMonitor monitor) throws CoreException {
        PHPexeItem phpExeItem = PHPLaunchUtilities.getPHPExe((ILaunchConfiguration)this.configuration);
        int requestPort = this.getDebugPort(phpExeItem);
        if (!PHPLaunchUtilities.isDebugDaemonActive((int)requestPort, (String)"org.eclipse.php.debug.core.zendDebugger")) {
            PHPLaunchUtilities.showLaunchErrorMessage((String)NLS.bind((String)PHPDebugCoreMessages.ExeLaunchConfigurationDelegate_PortInUse, (Object)requestPort, (Object)phpExeItem.getName()));
            monitor.setCanceled(true);
            monitor.done();
            return;
        }
        boolean stopAtFirstLine = this.configuration.getAttribute("firstLineBreakpoint", PHPProjectPreferences.getStopAtFirstLine((IProject)project));
        ILaunchConfigurationWorkingCopy wc = this.configuration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)this.configuration : this.configuration.getWorkingCopy();
        if (project != null) {
            wc.setAttribute("org.eclipse.php.debug.core.PHP_Project", project.getFullPath().toString());
        }
        wc.setAttribute("debugTransferEncoding", PHPProjectPreferences.getTransferEncoding((IProject)project));
        wc.setAttribute("debugOutputEncoding", PHPProjectPreferences.getOutputEncoding((IProject)project));
        wc.setAttribute("php_debug_type", "php_exe_script_debug");
        if (!wc.hasAttribute("org.eclipse.php.phpunit.rerun")) {
            wc.doSave();
        }
        if (monitor.isCanceled()) {
            return;
        }
        int sessionID = DebugSessionIdGenerator.generateSessionID();
        PHPSessionLaunchMapper.put((int)sessionID, (ILaunch)this.launch);
        this.launch.setAttribute("port", Integer.toString(requestPort));
        this.launch.setAttribute("firstLineBreakpoint", Boolean.toString(stopAtFirstLine));
        this.launch.setAttribute("debugSessionID", Integer.toString(sessionID));
        try {
            PHPexeItem[] items;
            this.launch.setAttribute("executable_launch", Boolean.toString(true));
            IDebugParametersInitializer parametersInitializer = DebugParametersInitializersRegistry.getBestMatchDebugParametersInitializer((ILaunch)this.launch);
            String query = PHPLaunchUtilities.generateQuery((ILaunch)this.launch, (IDebugParametersInitializer)parametersInitializer);
            String iniFileLocation = this.launch.getAttribute("PHPIniLocation");
            File phpExeFile = new File(phpExeString);
            String phpConfigDir = phpExeFile.getParent();
            if (iniFileLocation != null && !iniFileLocation.isEmpty()) {
                phpConfigDir = new File(iniFileLocation).getParent();
            }
            String sapiType = null;
            PHPexeItem[] pHPexeItemArray = items = PHPexes.getInstance().getAllItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                PHPexeItem item = pHPexeItemArray[n2];
                if (item.getExecutable().equals(phpExeFile)) {
                    sapiType = item.getSapiType();
                    break;
                }
                ++n2;
            }
            String[] args = PHPLaunchUtilities.getProgramArguments((ILaunchConfiguration)this.launch.getLaunchConfiguration());
            Map additionalLaunchEnvironment = PHPLaunchUtilities.getPHPCGILaunchEnvironment((String)fileName, (String)query, (String)phpConfigDir, (String)phpExeFile.getParent(), (String[])(sapiType == "CGI" ? args : null));
            if (envVariables == null) {
                envVariables = additionalLaunchEnvironment;
            } else {
                additionalLaunchEnvironment.putAll(envVariables);
                envVariables = additionalLaunchEnvironment;
            }
            Object[] environmetVars = PHPLaunchUtilities.getEnvironment((ILaunchConfiguration)this.launch.getLaunchConfiguration(), (String[])this.asAttributesArray(envVariables));
            Object[] phpCmdArray = this.getCommandLine(project, phpExeString, phpConfigDir, fileName, (String[])(sapiType == "CLI" ? args : null));
            ArrayList<String> allArgs = new ArrayList<String>();
            allArgs.addAll(Arrays.asList(phpCmdArray));
            allArgs.addAll(this.optionsList.getList());
            phpCmdArray = allArgs.toArray(new String[0]);
            PHPexes.changePermissions((File)new File(phpCmdArray[0]));
            if (PHPDebugPlugin.DEBUG) {
                System.out.println("Executing: " + Arrays.toString(phpCmdArray));
                System.out.println("Process environment: " + Arrays.toString(environmetVars));
            }
            DaemonPlugin.getDefault().makeSureDebuggerInitialized(null);
            Process p = Runtime.getRuntime().exec((String[])phpCmdArray, (String[])environmetVars, workingDir);
            new Thread((Runnable)((Object)new CrashDetector(this.launch, p))).start();
        }
        catch (IOException e1) {
            Logger.logException((String)"PHPDebugTarget: Debugger didn't find file to debug.", (Throwable)e1);
            String errorMessage = PHPDebugCoreMessages.DebuggerFileNotFound_1;
            throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, errorMessage, (Throwable)e1));
        }
        catch (CoreException e) {
            PHPUnitPlugin.log(e);
        }
    }

    protected int getDebugPort(PHPexeItem phpExe) throws CoreException {
        int customRequestPort = ZendDebuggerSettingsUtil.getDebugPort((String)phpExe.getUniqueId());
        if (customRequestPort != -1) {
            return customRequestPort;
        }
        return PHPDebugPlugin.getDebugPort((String)"org.eclipse.php.debug.core.zendDebugger");
    }

    private String[] asAttributesArray(Map<String, String> attributesMap) {
        String[] attributes = new String[attributesMap.size()];
        int index = 0;
        for (Map.Entry<String, String> entry : attributesMap.entrySet()) {
            attributes[index++] = entry.getKey() + "=" + entry.getValue();
        }
        return attributes;
    }

    class CrashDetector
    extends ProcessCrashDetector {
        private ILaunch launch;

        public CrashDetector(ILaunch launch, Process p) {
            super(launch, p);
            this.launch = launch;
        }

        public void run() {
            super.run();
            if (this.launch != null && this.launch.getDebugTarget() == null) {
                String launchName = this.launch.getLaunchConfiguration().getName();
                boolean isRunMode = "run".equals(this.launch.getLaunchMode());
                String msg = null;
                msg = isRunMode ? MessageFormat.format(PHPDebugCoreMessages.Debugger_Error_Message_3, launchName) : MessageFormat.format(PHPDebugCoreMessages.Debugger_Error_Message_2, launchName);
                String message = msg;
                Display.getDefault().asyncExec(() -> {
                    MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)PHPDebugCoreMessages.Debugger_Launch_Error, (String)message);
                    DebugPlugin.getDefault().getLaunchManager().removeLaunch(this.launch);
                });
            }
        }
    }
}

