/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.commands;

import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.reqcycle.commands.Command;
import org.polarsys.reqcycle.traceability.builder.BuilderUtil;
import org.polarsys.reqcycle.traceability.storage.IStorageProvider;
import org.polarsys.reqcycle.traceability.storage.ITraceabilityStorage;
import org.polarsys.reqcycle.traceability.types.ITraceTypesManager;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Relation;
import org.polarsys.reqcycle.uri.IReachableCreator;
import org.polarsys.reqcycle.uri.IReachableListenerManager;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;

public class CreateRelationCommand
implements Command {
    @Inject
    IStorageProvider provider;
    @Inject
    ITraceTypesManager tTypesManager;
    @Inject
    IReachableManager manager;
    @Inject
    IReachableCreator creator;
    @Inject
    IReachableListenerManager listenerManager;
    private Relation relation;
    private Reachable source;
    private Reachable target;

    public CreateRelationCommand(Relation relation, Reachable source, Reachable target) {
        this.relation = relation;
        this.source = source;
        this.target = target;
    }

    public IProject getDefaultTraceabilityProject() {
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject("ReqCycle_Transverse_Traceability");
        if (!p.exists()) {
            try {
                p.create((IProgressMonitor)new NullProgressMonitor());
                p.setHidden(false);
                BuilderUtil.installBuilder((IProject)p);
            }
            catch (CoreException coreException) {}
        }
        return p;
    }

    public IProject getProjectFromReachable(Reachable r) {
        try {
            ReachableObject object = this.manager.getHandlerFromReachable(r).getFromReachable(r);
            IFile f = (IFile)object.getAdapter(IFile.class);
            if (f != null && f.exists()) {
                return f.getProject();
            }
        }
        catch (IReachableHandlerException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void execute() {
        this.redo();
    }

    public void redo() {
        IProject p = this.getProjectFromReachable(this.source);
        if (p == null) {
            p = this.getProjectFromReachable(this.target);
        }
        if (p == null) {
            p = this.getDefaultTraceabilityProject();
        }
        ArrayList toUpdate = Lists.newArrayList();
        ITraceabilityStorage traceaStorage = this.provider.getProjectStorage(p);
        String originalPath = traceaStorage.getPath();
        String wsPath = originalPath.replace(ResourcesPlugin.getWorkspace().getRoot().getLocationURI().toString(), "");
        if (wsPath.equals(originalPath)) {
            wsPath = p.getFullPath().toString();
        }
        try {
            Reachable container = this.creator.getReachable(new URI("platform:" + wsPath));
            Reachable tracea = this.creator.getReachable(new URI("platform:" + wsPath));
            tracea.setFragment(this.getNextId());
            traceaStorage.startTransaction();
            long date = System.currentTimeMillis();
            tracea.getProperties().put("org.polarsys.reqcycle.traceability.lifecycle", "DEFINED");
            tracea.getProperties().put("org.polarsys.reqcycle.traceability.creationDate", "" + date);
            tracea.getProperties().put("org.polarsys.reqcycle.traceability.lastModificationDate", "" + date);
            tracea.getProperties().put("org.polarsys.reqcycle.traceability.changeHistory", "");
            traceaStorage.addOrUpdateUpwardRelationShip(this.relation.getTType(), tracea, container, this.source, new Reachable[]{this.target});
            toUpdate.add(tracea);
            toUpdate.add(container);
            toUpdate.add(this.source);
            toUpdate.add(this.target);
            traceaStorage.addUpdateProperty(tracea, "relationKind", this.relation.getKind());
            traceaStorage.commit();
            traceaStorage.save();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            traceaStorage.rollback();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.listenerManager.notifyChanged(toUpdate.toArray(new Reachable[0]));
    }

    private String getNextId() {
        return EcoreUtil.generateUUID();
    }
}

