/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class FocusTab
extends ExampleTab {
    private static final String DEFAULT_HTML = "<html><head></head><body><p>Hello World</p></body></html>";
    private Button button;
    private Button radio;
    private Button check;
    private Combo combo;
    private List list;
    private TabFolder tabFolder;
    private Browser browser;
    private Table table;
    private Tree tree;
    private Composite composite;
    private Text text;
    private Text multiText;
    private Label label;
    private List log;
    private Slider slider;
    private Scale scale;
    private DateTime time;
    private DateTime date;
    private DateTime calendar;
    private Spinner spinner;

    public FocusTab() {
        super("Focus");
    }

    @Override
    protected void createStyleControls(Composite parent) {
        this.createFocusButton("Focus Label", (Control)this.label, parent);
        this.createFocusButton("Focus Push Button", (Control)this.button, parent);
        this.createFocusButton("Focus Radio Button", (Control)this.radio, parent);
        this.createFocusButton("Focus Check Box", (Control)this.check, parent);
        this.createFocusButton("Focus Multi Text", (Control)this.multiText, parent);
        this.createFocusButton("Focus Single Text", (Control)this.text, parent);
        this.createFocusButton("Focus Combo", (Control)this.combo, parent);
        this.createFocusButton("Focus List", (Control)this.list, parent);
        this.createFocusButton("Focus TabFolder", (Control)this.tabFolder, parent);
        this.createFocusButton("Focus Browser", (Control)this.browser, parent);
        this.createFocusButton("Focus Table", (Control)this.table, parent);
        this.createFocusButton("Focus Tree", (Control)this.tree, parent);
        this.createFocusButton("Focus Composite", (Control)this.composite, parent);
        this.createFocusButton("Focus Slider", (Control)this.slider, parent);
        this.createFocusButton("Focus Scale", (Control)this.scale, parent);
        this.createFocusButton("Focus Spinner", (Control)this.spinner, parent);
        this.createFocusButton("Focus DateTime Time", (Control)this.time, parent);
        this.createFocusButton("Focus DateTime Date", (Control)this.date, parent);
        this.createFocusButton("Focus DateTime Calendar", (Control)this.calendar, parent);
        Label label = new Label(parent, 0);
        label.setText("Log");
        this.log = new List(parent, 2816);
        this.log.setLayoutData((Object)new RowData(300, 120));
    }

    @Override
    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new RowLayout());
        this.label = new Label(parent, 0);
        this.label.setText("Even a label can gain focus");
        this.addFocusListener((Control)this.label);
        this.button = new Button(parent, 8);
        this.button.setText("Push Button");
        this.addFocusListener((Control)this.button);
        this.radio = new Button(parent, 16);
        this.radio.setText("Radio Button");
        this.addFocusListener((Control)this.radio);
        this.check = new Button(parent, 32);
        this.check.setText("Check Box");
        this.addFocusListener((Control)this.check);
        this.text = new Text(parent, 2052);
        this.text.setText("text");
        this.addFocusListener((Control)this.text);
        this.multiText = new Text(parent, 2050);
        this.multiText.setText("Multiline Text");
        this.multiText.setLayoutData((Object)new RowData(80, 60));
        this.addFocusListener((Control)this.multiText);
        this.combo = new Combo(parent, 0);
        this.combo.add("Item 1");
        this.combo.add("Item 2");
        this.combo.add("Item 3");
        this.addFocusListener((Control)this.combo);
        this.list = new List(parent, 2048);
        this.list.add("Item 1");
        this.list.add("Item 2");
        this.list.add("Item 3");
        this.addFocusListener((Control)this.list);
        this.tabFolder = new TabFolder(parent, 0);
        this.tabFolder.setLayoutData((Object)new RowData(120, 60));
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("Tab Item 1");
        Label tabItemControl = new Label((Composite)this.tabFolder, 0);
        tabItemControl.setText("TabItem Content");
        tabItem.setControl((Control)tabItemControl);
        this.addFocusListener((Control)this.tabFolder);
        this.browser = new Browser(parent, 0);
        this.browser.setText(DEFAULT_HTML);
        this.addFocusListener((Control)this.browser);
        this.table = new Table(parent, 0);
        this.table.setLayoutData((Object)new RowData(90, 140));
        this.table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setText("Column 1");
        tableColumn.setWidth(80);
        int i = 0;
        while (i < 3) {
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText("Item " + i);
            ++i;
        }
        this.addFocusListener((Control)this.table);
        this.tree = new Tree(parent, 0);
        TreeItem item = new TreeItem(this.tree, 0);
        item.setText("Item 1");
        item = new TreeItem(this.tree, 0);
        item.setText("Item 2");
        item = new TreeItem(this.tree, 0);
        item.setText("Item 3");
        item = new TreeItem(item, 0);
        item.setText("SubItem");
        this.addFocusListener((Control)this.tree);
        this.composite = new Composite(parent, 0);
        Color black = Display.getCurrent().getSystemColor(2);
        this.composite.setBackground(black);
        this.addFocusListener((Control)this.composite);
        CTabFolder tabFolder2 = new CTabFolder(parent, 0);
        CTabItem tabItem2 = new CTabItem(tabFolder2, 0);
        tabItem2.setText("Item 1");
        Label ctabItemControl = new Label((Composite)tabFolder2, 0);
        ctabItemControl.setText("Content control of item 1");
        tabItem2.setControl((Control)ctabItemControl);
        tabItem2 = new CTabItem(tabFolder2, 0);
        tabItem2.setText("Item 2");
        this.addFocusListener((Control)tabFolder2);
        this.slider = new Slider(parent, 256);
        this.addFocusListener((Control)this.slider);
        this.scale = new Scale(parent, 256);
        this.addFocusListener((Control)this.scale);
        this.spinner = new Spinner(parent, 0);
        this.addFocusListener((Control)this.spinner);
        this.time = new DateTime(parent, 2176);
        this.addFocusListener((Control)this.time);
        this.date = new DateTime(parent, 2080);
        this.addFocusListener((Control)this.date);
        this.calendar = new DateTime(parent, 3072);
        this.addFocusListener((Control)this.calendar);
    }

    private void createFocusButton(String text, final Control targetControl, Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                targetControl.forceFocus();
            }
        });
    }

    private void addFocusListener(Control control) {
        control.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
                String msg = "focusGained: " + String.valueOf(event.getSource());
                FocusTab.this.log.add(msg, 0);
            }

            public void focusLost(FocusEvent event) {
                String msg = "focusLost: " + String.valueOf(event.getSource());
                FocusTab.this.log.add(msg, 0);
            }
        });
    }
}

