/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.export.xsl;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.set.utils.excel.ExcelWorkbookExtension;
import org.eclipse.set.utils.export.xsl.TransformStyle;
import org.eclipse.set.utils.export.xsl.XSLConstant;
import org.eclipse.xtext.xbase.lib.Pair;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class AbstractTransformTableHeader {
    protected static final String XSL_TEMPLATE_PATH = "data/export/pdf/table_template.xsl";
    protected static final float OFFSET = 0.01f;
    protected Document doc;
    protected XSSFSheet sheet;
    protected float maxPaperWidth;

    protected AbstractTransformTableHeader(XSSFSheet sheet, float maxPaperWidth) {
        this.sheet = sheet;
        this.maxPaperWidth = maxPaperWidth;
    }

    public static Document parseTemplate(String path) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
        return builder.parse(Paths.get(path, new String[0]).toAbsolutePath().toFile());
    }

    public Document transform() throws ParserConfigurationException, SAXException, IOException, TransformerException {
        this.doc = this.getFopPageTemplate();
        Node rootNode = this.doc.getElementsByTagName("xsl:stylesheet").item(0);
        Element table = this.transformTable();
        rootNode.appendChild(table);
        rootNode.appendChild(AbstractTransformTableHeader.emptyTableTemplate(this.doc));
        Set<Element> tableStyles = this.getTableStyle();
        tableStyles.forEach(rootNode::appendChild);
        return this.doc;
    }

    protected abstract Document getFopPageTemplate() throws ParserConfigurationException, SAXException, IOException, TransformerException;

    protected Element transformTable() {
        Element tableTemplate = this.doc.createElement("xsl:template");
        tableTemplate.setAttribute("match", "Table[Rows/Row]");
        Element table = this.doc.createElement("fo:table");
        table.setAttribute(XSLConstant.TableAttribute.TABLE_LAYOUT, "fixed");
        table.setAttribute(XSLConstant.TableAttribute.TABLE_WIDTH, "100%");
        Set<Element> tableColumns = this.transformColumns();
        tableColumns.forEach(table::appendChild);
        Element tableHeader = this.doc.createElement("fo:table-header");
        tableHeader.setAttribute(XSLConstant.TableAttribute.XSL_USE_ATTRIBUTE_SETS, "table-header-style");
        Set<Element> tableRows = this.transformRows();
        tableRows.forEach(tableHeader::appendChild);
        table.appendChild(tableHeader);
        Element tableBody = this.doc.createElement("fo:table-body");
        tableBody.setAttribute(XSLConstant.TableAttribute.START_INDENT, "0mm");
        Element tableBodyChild = this.doc.createElement("xsl:apply-templates");
        tableBodyChild.setAttribute("select", "Rows/Row");
        tableBody.appendChild(tableBodyChild);
        table.appendChild(tableBody);
        this.addTableToTemplate(tableTemplate, table);
        return tableTemplate;
    }

    private Set<Element> transformColumns() {
        LinkedHashSet<Element> cols = new LinkedHashSet<Element>();
        float sumWidth = 0.0f;
        int i = 0;
        int columNumber = 1;
        while (i <= ExcelWorkbookExtension.getHeaderLastColumnIndex((Sheet)this.sheet)) {
            Pair<Integer, Float> pair = this.transformColumn(cols, sumWidth, i, columNumber);
            columNumber = (Integer)pair.getKey();
            sumWidth = ((Float)pair.getValue()).floatValue();
            ++i;
            ++columNumber;
        }
        if (sumWidth < this.maxPaperWidth - 0.01f) {
            float remainingWidth = this.maxPaperWidth - sumWidth - 0.01f;
            float lastColumnWith = Float.parseFloat(cols.getLast().getAttribute(XSLConstant.TableAttribute.COLUMN_WIDTH).replace("cm", ""));
            cols.getLast().setAttribute(XSLConstant.TableAttribute.COLUMN_WIDTH, Double.toString(lastColumnWith + remainingWidth) + "cm");
        }
        return cols;
    }

    protected abstract Pair<Integer, Float> transformColumn(LinkedHashSet<Element> var1, float var2, int var3, int var4);

    protected Element createTableColumn(int columnNumber, float columnWidth) {
        Element tableColumn = this.doc.createElement("fo:table-column");
        tableColumn.setAttribute(XSLConstant.TableAttribute.COLUMN_NUMBER, Integer.toString(columnNumber));
        tableColumn.setAttribute(XSLConstant.TableAttribute.COLUMN_WIDTH, Float.toString(columnWidth) + "cm");
        return tableColumn;
    }

    protected Set<Element> transformRows() {
        LinkedHashSet<Element> rows = new LinkedHashSet<Element>();
        int headerLastRowIndex = ExcelWorkbookExtension.getHeaderLastRowIndex((Sheet)this.sheet);
        int i = 0;
        while (i <= headerLastRowIndex) {
            Element row = this.doc.createElement("fo:table-row");
            Set<Element> cells = this.transformRowCells(this.sheet.getRow(i));
            if (!cells.isEmpty()) {
                cells.forEach(row::appendChild);
                rows.add(row);
            }
            ++i;
        }
        return rows;
    }

    protected Set<Element> transformRowCells(XSSFRow row) {
        LinkedHashSet<Element> cells = new LinkedHashSet<Element>();
        int headerLastColumnIndex = ExcelWorkbookExtension.getHeaderLastColumnIndex((Sheet)this.sheet);
        int headerLastRowIndex = ExcelWorkbookExtension.getHeaderLastRowIndex((Sheet)this.sheet);
        int rowNum = row.getRowNum();
        cells.add(this.transformFirstColumnCell((Row)row));
        int i = 1;
        while (i <= headerLastColumnIndex) {
            Optional<Cell> excelCell = ExcelWorkbookExtension.getCellAt((Sheet)this.sheet, rowNum, i);
            if (rowNum == headerLastRowIndex || excelCell.isEmpty()) {
                this.addCell(cells, rowNum, this.createTableCell(excelCell), i);
            } else {
                Optional<CellRangeAddress> rowSpanRangeAt = ExcelWorkbookExtension.getRowSpanRangeAt(excelCell.get());
                if (!rowSpanRangeAt.isPresent() || rowSpanRangeAt.get().getFirstRow() == rowNum) {
                    Element cell = this.createTableCell(excelCell);
                    this.addCell(cells, rowNum, cell, i += this.transformSpanCell(cell, excelCell));
                }
            }
            ++i;
        }
        boolean isEmptyRow = cells.stream().allMatch(ele -> ele.getTextContent().isEmpty());
        if (isEmptyRow && rowNum == headerLastRowIndex) {
            this.handleEmptyRow(cells);
        }
        return cells;
    }

    private int transformSpanCell(Element cell, Optional<Cell> excelCell) {
        Optional<CellRangeAddress> rowSpanRangeAt;
        if (excelCell.isEmpty()) {
            return 0;
        }
        int spanCount = 0;
        int columnIndex = excelCell.get().getColumnIndex();
        int headerLastRowIndex = ExcelWorkbookExtension.getHeaderLastRowIndex((Sheet)this.sheet);
        int spanColumnRange = this.getCellSpanColumn(excelCell);
        if (spanColumnRange > 0) {
            cell.setAttribute(XSLConstant.TableAttribute.NUMBER_COLUMNS_SPANNED, String.valueOf(spanColumnRange));
            TransformStyle.setBorderStyle(excelCell, cell, XSLConstant.TableAttribute.BorderDirection.RIGHT);
            spanCount = spanColumnRange - 1;
        }
        if ((rowSpanRangeAt = ExcelWorkbookExtension.getRowSpanRangeAt(excelCell.get())).isPresent()) {
            int rowSpanRange = rowSpanRangeAt.get().getNumberOfCells();
            cell.setAttribute(XSLConstant.TableAttribute.NUMBER_ROWS_SPANNED, String.valueOf(rowSpanRange));
            TransformStyle.setBorderStyle(ExcelWorkbookExtension.getCellAt((Sheet)this.sheet, headerLastRowIndex - 1, columnIndex), cell, XSLConstant.TableAttribute.BorderDirection.BOTTOM);
        }
        return spanCount;
    }

    private void handleEmptyRow(Set<Element> cells) {
        Iterator<Element> iterator = cells.iterator();
        iterator.next();
        Optional<Element> firstCell = Optional.of(iterator.next());
        Element firstCellBlock = (Element)firstCell.get().getFirstChild();
        if (firstCellBlock == null) {
            firstCellBlock = this.doc.createElement("fo:block");
            firstCell.get().appendChild(firstCellBlock);
        }
        firstCellBlock.setAttribute("color", "white");
        firstCellBlock.setTextContent(".");
    }

    protected abstract int getCellSpanColumn(Optional<Cell> var1);

    protected abstract void addCell(Set<Element> var1, int var2, Element var3, int var4);

    protected Element transformFirstColumnCell(Row row) {
        if (row.getCell(0) == null) {
            row.createCell(0, CellType.BLANK);
        }
        Cell firstCell = row.getCell(0);
        XSSFWorkbook workbook = this.sheet.getWorkbook();
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        cellStyle.cloneStyleFrom(firstCell.getCellStyle());
        cellStyle.setBorderLeft(BorderStyle.THIN);
        firstCell.setCellStyle((CellStyle)cellStyle);
        return this.createTableCell(Optional.of(firstCell));
    }

    private Element createTableCell(Optional<Cell> excelCell) {
        Element cell = this.doc.createElement("fo:table-cell");
        TransformStyle.transformCellStyle(cell, excelCell);
        Element block = this.doc.createElement("fo:block");
        block.setAttribute(XSLConstant.TableAttribute.START_INDENT, "0mm");
        if (excelCell.isPresent()) {
            TransformStyle.setCellContent(block, excelCell.get());
        }
        cell.appendChild(block);
        return cell;
    }

    protected abstract void addTableToTemplate(Element var1, Element var2);

    protected abstract Set<Element> getTableStyle();

    protected static Element emptyTableTemplate(Document doc) {
        Element template = doc.createElement("xsl:template");
        template.setAttribute("match", "Table[not(Rows/Row)]");
        Element block = doc.createElement("fo:block");
        block.setTextContent("Die Tabelle ist leer");
        template.appendChild(block);
        return template;
    }

    public static Optional<Element> findNodebyTagName(Document doc, String tag, String attribute, String value) {
        NodeList nodeList = doc.getElementsByTagName(tag);
        int i = 0;
        while (i < nodeList.getLength()) {
            Element item = (Element)nodeList.item(i);
            if (item.getAttribute(attribute).equals(value)) {
                return Optional.ofNullable(item);
            }
            ++i;
        }
        return Optional.empty();
    }
}

