/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.stickyscroll;

import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.stickyscroll.IStickyLinesProvider;

public class StickyLinesProviderDescriptor {
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String ID_ATTRIBUTE = "id";
    private static final String ENABLED_WHEN_ATTR = "enabledWhen";
    private IConfigurationElement configuration;
    private String id;
    private final Expression enabledWhen;

    public StickyLinesProviderDescriptor(IConfigurationElement element) throws CoreException {
        Assert.isLegal((element != null ? 1 : 0) != 0);
        this.configuration = element;
        this.enabledWhen = StickyLinesProviderDescriptor.createEnabledWhen(this.configuration, this.getId());
    }

    private static Expression createEnabledWhen(IConfigurationElement configElement, String id) throws CoreException {
        IConfigurationElement[] children = configElement.getChildren(ENABLED_WHEN_ATTR);
        if (children.length > 0) {
            IConfigurationElement[] subChildren = children[0].getChildren();
            if (subChildren.length != 1) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", "One <enabledWhen> element is accepted. Disabling " + id));
            }
            ElementHandler elementHandler = ElementHandler.getDefault();
            ExpressionConverter converter = ExpressionConverter.getDefault();
            return elementHandler.create(converter, subChildren[0]);
        }
        return null;
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.configuration.getAttribute(ID_ATTRIBUTE);
            Assert.isNotNull((Object)this.id);
        }
        return this.id;
    }

    public IStickyLinesProvider createStickyLinesProvider() {
        try {
            Object extension = this.configuration.createExecutableExtension(CLASS_ATTRIBUTE);
            if (extension instanceof IStickyLinesProvider) {
                IStickyLinesProvider stickyLinesProvider = (IStickyLinesProvider)extension;
                return stickyLinesProvider;
            }
            String message = "Invalid extension to stickyLinesProvider. Must extends IStickyLinesProvider: " + this.getId();
            EditorsPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.editors", message));
            return null;
        }
        catch (CoreException e) {
            EditorsPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.editors", "Error while creating stickyLinesProvider: " + this.getId(), (Throwable)e));
            return null;
        }
    }

    public boolean matches(ISourceViewer viewer, ITextEditor editor) {
        if (this.enabledWhen == null) {
            return true;
        }
        EvaluationContext context = new EvaluationContext(null, (Object)editor);
        context.setAllowPluginActivation(true);
        context.addVariable("viewer", (Object)viewer);
        context.addVariable("editor", (Object)editor);
        context.addVariable("editorInput", (Object)editor.getEditorInput());
        try {
            return this.enabledWhen.evaluate((IEvaluationContext)context) == EvaluationResult.TRUE;
        }
        catch (CoreException e) {
            EditorsPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.editors", "Error while 'enabledWhen' evaluation", (Throwable)e));
            return false;
        }
    }
}

