/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.transform;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.set.basis.geometry.GEOKanteCoordinate;
import org.eclipse.set.basis.geometry.GEOKanteMetadata;
import org.eclipse.set.basis.geometry.GeometryException;
import org.eclipse.set.core.services.geometry.GeoKanteGeometryService;
import org.eclipse.set.feature.siteplan.positionservice.PositionService;
import org.eclipse.set.feature.siteplan.transform.BaseTransformator;
import org.eclipse.set.feature.siteplan.transform.TrackTransformator;
import org.eclipse.set.feature.siteplan.transform.Transformator;
import org.eclipse.set.model.planpro.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.model.planpro.Geodaten.ENUMGEOKoordinatensystem;
import org.eclipse.set.model.planpro.Geodaten.GEO_Kante;
import org.eclipse.set.model.planpro.Geodaten.GEO_Knoten;
import org.eclipse.set.model.planpro.Geodaten.Strecke;
import org.eclipse.set.model.planpro.Geodaten.Strecke_Punkt;
import org.eclipse.set.model.siteplan.KMMarker;
import org.eclipse.set.model.siteplan.Route;
import org.eclipse.set.model.siteplan.RouteSection;
import org.eclipse.set.model.siteplan.SiteplanFactory;
import org.eclipse.set.model.siteplan.SiteplanPackage;
import org.eclipse.set.ppmodel.extensions.GeoKanteExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.StreckeExtensions;
import org.eclipse.set.ppmodel.extensions.StreckePunktExtensions;
import org.eclipse.set.ppmodel.extensions.geometry.GEOKanteGeometryExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Transformator.class})
public class RouteTransformator
extends BaseTransformator<Strecke> {
    private static final double STRECKE_KM_SPACING = 100.0;
    @Reference
    private GeoKanteGeometryService geometryService;
    @Reference
    private PositionService positionService;

    private RouteSection transform(GEO_Kante geoKante) {
        RouteSection it = SiteplanFactory.eINSTANCE.createRouteSection();
        it.setGuid(geoKante.getIdentitaet().getWert());
        it.setShape(TrackTransformator.transformGeoForm(geoKante.getGEOKanteAllg().getGEOForm()));
        ENUMGEOKoordinatensystem crs = GeoKnotenExtensions.getCRS((GEO_Knoten)GeoKanteExtensions.getGeoKnotenA((GEO_Kante)geoKante));
        Functions.Function1 _function = it_1 -> this.positionService.transformCoordinate((Coordinate)it_1, crs);
        it.getPositions().addAll((Collection)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)GEOKanteGeometryExtensions.getGeometry((GEO_Kante)geoKante).getCoordinates())), (Functions.Function1)_function));
        return it;
    }

    @Override
    public void transform(Strecke strecke) {
        Consumer<GEO_Kante> _function;
        Route track = SiteplanFactory.eINSTANCE.createRoute();
        track.setGuid(strecke.getIdentitaet().getWert());
        try {
            _function = it -> {
                try {
                    track.getSections().add((Object)this.transform((GEO_Kante)it));
                }
                catch (Throwable _t) {
                    if (_t instanceof GeometryException) {
                        GeometryException exc = (GeometryException)_t;
                        throw new RuntimeException((Throwable)exc);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            };
            StreckeExtensions.getGeoKanten((Strecke)strecke).forEach(_function);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                return;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _function = marker -> track.getMarkers().add(marker);
        this.transformKMMarkers(strecke).forEach(_function);
        this.addSiteplanElement(track, SiteplanPackage.eINSTANCE.getSiteplanState_Routes());
    }

    private Iterable<KMMarker> transformKMMarkers(Strecke strecke) {
        Functions.Function1 _function = it -> {
            try {
                KMMarker kmMarker = SiteplanFactory.eINSTANCE.createKMMarker();
                kmMarker.setPosition(this.positionService.transformPosition((GEOKanteCoordinate)it.getKey()));
                kmMarker.setValue(((Double)it.getValue()).intValue());
                return kmMarker;
            }
            catch (Throwable _t) {
                if (_t instanceof GeometryException) {
                    return null;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        };
        return IterableExtensions.filterNull((Iterable)ListExtensions.map(this.getStreckeKilometers(strecke), (Functions.Function1)_function));
    }

    private List<Pair<GEOKanteCoordinate, Double>> getStreckeKilometers(Strecke strecke) {
        Strecke_Punkt[] startEnd = StreckeExtensions.getStartEnd((Strecke)strecke);
        if (startEnd == null) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        Strecke_Punkt start = startEnd[0];
        Strecke_Punkt end = startEnd[1];
        int startMeter = start.getStreckeMeter().getWert().intValue();
        int endMeter = end.getStreckeMeter().getWert().intValue();
        double offset = (double)startMeter + (100.0 - (double)startMeter % 100.0);
        ArrayList result = CollectionLiterals.newArrayList();
        GEO_Kante geoKante = null;
        GEO_Knoten geoKnoten = StreckePunktExtensions.getGeoKnoten((Strecke_Punkt)start);
        BigDecimal geoDistance = BigDecimal.valueOf(startMeter);
        while (true) {
            List geoKanten = IterableExtensions.toList((Iterable)GeoKnotenExtensions.getGeoKanten((GEO_Knoten)geoKnoten));
            geoKanten.remove(geoKante);
            boolean _isEmpty = geoKanten.isEmpty();
            if (_isEmpty) {
                return result;
            }
            geoKante = (GEO_Kante)geoKanten.get(0);
            LineString _geometry = this.geometryService.getGeometry(geoKante);
            GEOKanteMetadata metadata = new GEOKanteMetadata(geoKante, geoDistance, geoKnoten, _geometry);
            while (offset <= metadata.getEnd().doubleValue()) {
                if (offset >= (double)endMeter) {
                    return result;
                }
                try {
                    GEOKanteCoordinate _coordinate = this.geometryService.getCoordinate(metadata, BigDecimal.valueOf(offset), BigDecimal.ZERO, ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN);
                    Pair _mappedTo = Pair.of((Object)_coordinate, (Object)offset);
                    result.add(_mappedTo);
                    double _offset = offset;
                    offset = _offset + 100.0;
                }
                catch (Throwable _t) {
                    if (_t instanceof GeometryException) {
                        double _offset_1 = offset;
                        offset = _offset_1 + 100.0;
                        continue;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            BigDecimal _geoDistance = geoDistance;
            BigDecimal _length = metadata.getLength();
            geoDistance = _geoDistance.add(_length);
            geoKnoten = GeoKanteExtensions.getOpposite((GEO_Kante)geoKante, (GEO_Knoten)geoKnoten);
        }
    }
}

