/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.geometry;

class CoordinateArray {
    private final double[] data;
    private int insertIndex;

    public CoordinateArray(int size) {
        this.data = new double[size * 2];
    }

    public void add(double x, double y) {
        this.data[this.insertIndex++] = x;
        this.data[this.insertIndex++] = y;
    }

    public double[] getData() {
        return this.data;
    }

    public void offsetBy(double x, double y) {
        int i = 0;
        while (i < this.data.length / 2) {
            int n = i * 2;
            this.data[n] = this.data[n] + x;
            int n2 = i * 2 + 1;
            this.data[n2] = this.data[n2] + y;
            ++i;
        }
    }

    private void swap(int a, int b) {
        double tmp = this.data[a];
        this.data[a] = this.data[b];
        this.data[b] = tmp;
    }

    public void reverse() {
        int limit = (this.insertIndex - 1) / 2;
        int i = 0;
        while (i < limit) {
            this.swap(i, this.insertIndex - i - 2);
            this.swap(i + 1, this.insertIndex - i - 1);
            i += 2;
        }
    }
}

