/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.util;

import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.EndOfLife;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Execution;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Gate;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElement;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InteractionUse;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.State;
import org.eclipse.sirius.diagram.sequence.description.DescriptionPackage;

public class ISequenceElementSwitch<T> {
    public T doSwitch(ISequenceElement element) {
        DiagramElementMapping mapping;
        DDiagramElement dde = null;
        if (element.getNotationView().getElement() instanceof DDiagramElement) {
            dde = (DDiagramElement)element.getNotationView().getElement();
        }
        if (dde != null && (mapping = dde.getDiagramElementMapping()) != null) {
            DiagramElementMapping mappingToCheck = new DiagramElementMappingQuery(mapping).getRootMapping();
            return this.doSwitch(mappingToCheck, element);
        }
        return null;
    }

    protected T doSwitch(DiagramElementMapping mapping, ISequenceElement element) {
        if (mapping != null && mapping.eClass().getEPackage() == DescriptionPackage.eINSTANCE) {
            return this.doSwitch(mapping.eClass().getClassifierID(), element);
        }
        return this.defaultCase(element);
    }

    protected T doSwitch(int classifierID, ISequenceElement element) {
        switch (classifierID) {
            case 0: {
                SequenceDiagram diag = (SequenceDiagram)element;
                T result = this.caseSequenceDiagram(diag);
                if (result == null) {
                    result = this.defaultCase(element);
                }
                return result;
            }
            case 1: {
                InstanceRole instanceRole = (InstanceRole)element;
                T result = this.caseInstanceRole(instanceRole);
                if (result == null) {
                    result = this.defaultCase(element);
                }
                return result;
            }
            case 2: {
                ISequenceEvent event = (ISequenceEvent)element;
                T result = this.caseEvent(event);
                if (result == null) {
                    result = this.defaultCase(element);
                }
                return result;
            }
            case 3: {
                ISequenceEvent delimitedEvent = (ISequenceEvent)element;
                T result = this.caseDelimitedEvent(delimitedEvent);
                if (result == null) {
                    result = this.caseEvent(delimitedEvent);
                }
                if (result == null) {
                    result = this.defaultCase(element);
                }
                return result;
            }
            case 4: {
                Execution execution = (Execution)element;
                T result = this.caseExecution(execution);
                if (result == null) {
                    result = this.caseDelimitedEvent(execution);
                }
                if (result == null) {
                    result = this.caseEvent(execution);
                }
                if (result == null) {
                    result = this.defaultCase(element);
                }
                return result;
            }
            case 5: {
                State state = (State)element;
                T result = this.caseState(state);
                if (result == null) {
                    result = this.caseDelimitedEvent(state);
                }
                if (result == null) {
                    result = this.caseEvent(state);
                }
                if (result == null) {
                    result = this.defaultCase(element);
                }
                return result;
            }
            case 6: {
                EndOfLife endOfLife = (EndOfLife)element;
                T result = this.caseEndOfLife(endOfLife);
                if (result == null) {
                    result = this.defaultCase(element);
                }
                return result;
            }
            case 8: {
                Message basicMessage = (Message)element;
                T result = this.caseBasicMessage(basicMessage);
                if (result == null) {
                    result = this.caseMessage(basicMessage);
                }
                return result;
            }
            case 9: {
                Message returnMessage = (Message)element;
                T result = this.caseReturnMessage(returnMessage);
                if (result == null) {
                    result = this.caseMessage(returnMessage);
                }
                if (result == null) {
                    result = this.defaultCase(element);
                }
                return result;
            }
            case 10: {
                Message creationMessage = (Message)element;
                T result = this.caseCreationMessage(creationMessage);
                if (result == null) {
                    result = this.caseMessage(creationMessage);
                }
                if (result == null) {
                    result = this.defaultCase(element);
                }
                return result;
            }
            case 11: {
                Message destructionMessage = (Message)element;
                T result = this.caseDestructionMessage(destructionMessage);
                if (result == null) {
                    result = this.caseMessage(destructionMessage);
                }
                if (result == null) {
                    result = this.defaultCase(element);
                }
                return result;
            }
            case 14: {
                AbstractFrame frame = (AbstractFrame)element;
                T result = this.caseFrame(frame);
                if (result == null) {
                    result = this.caseDelimitedEvent(frame);
                }
                if (result == null) {
                    result = this.caseEvent(frame);
                }
                if (result == null) {
                    result = this.defaultCase(element);
                }
                return result;
            }
            case 15: {
                InteractionUse interactionUse = (InteractionUse)element;
                T result = this.caseInteractionUse(interactionUse);
                if (result == null) {
                    result = this.caseFrame(interactionUse);
                }
                if (result == null) {
                    result = this.caseDelimitedEvent(interactionUse);
                }
                if (result == null) {
                    result = this.caseEvent(interactionUse);
                }
                if (result == null) {
                    result = this.defaultCase(element);
                }
                return result;
            }
            case 16: {
                CombinedFragment combinedFragment = (CombinedFragment)element;
                T result = this.caseCombinedFragment(combinedFragment);
                if (result == null) {
                    result = this.caseFrame(combinedFragment);
                }
                if (result == null) {
                    result = this.caseDelimitedEvent(combinedFragment);
                }
                if (result == null) {
                    result = this.caseEvent(combinedFragment);
                }
                if (result == null) {
                    result = this.defaultCase(element);
                }
                return result;
            }
            case 17: {
                Operand operand = (Operand)element;
                T result = this.caseOperand(operand);
                if (result == null) {
                    result = this.caseDelimitedEvent(operand);
                }
                if (result == null) {
                    result = this.caseEvent(operand);
                }
                if (result == null) {
                    result = this.defaultCase(element);
                }
                return result;
            }
            case 20: {
                Gate gate = (Gate)element;
                T result = this.caseGate(gate);
                if (result == null) {
                    result = this.defaultCase(element);
                }
                return result;
            }
        }
        return this.defaultCase(element);
    }

    public T caseSequenceDiagram(SequenceDiagram object) {
        return null;
    }

    public T caseInstanceRole(InstanceRole object) {
        return null;
    }

    public T caseEvent(ISequenceEvent object) {
        return null;
    }

    public T caseDelimitedEvent(ISequenceEvent object) {
        return null;
    }

    public T caseExecution(Execution object) {
        return null;
    }

    public T caseState(State object) {
        return null;
    }

    public T caseEndOfLife(EndOfLife object) {
        return null;
    }

    public T caseMessage(Message object) {
        return null;
    }

    public T caseBasicMessage(Message object) {
        return null;
    }

    public T caseReturnMessage(Message object) {
        return null;
    }

    public T caseCreationMessage(Message object) {
        return null;
    }

    public T caseDestructionMessage(Message object) {
        return null;
    }

    public T caseFrame(AbstractFrame object) {
        return null;
    }

    public T caseInteractionUse(InteractionUse object) {
        return null;
    }

    public T caseCombinedFragment(CombinedFragment object) {
        return null;
    }

    public T caseOperand(Operand object) {
        return null;
    }

    public T caseGate(Gate object) {
        return null;
    }

    public T defaultCase(ISequenceElement object) {
        return null;
    }
}

