/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.api.tools;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.sirius.tests.support.api.TestsUtil;
import org.eclipse.sirius.tests.support.api.TreeTestCase;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.junit.Assert;

public class TreeItemEditionToolTest
extends TreeTestCase {
    private static final String SEMANTIC_MODEL_PATH = "/org.eclipse.sirius.tests.junit/data/tree/unit/directedit/vp912/vp912.ecore";
    private static final String MODELER_PATH = "/org.eclipse.sirius.tests.junit/data/tree/unit/directedit/vp912/vp912.odesign";
    private static final String SESSION_PATH = "/org.eclipse.sirius.tests.junit/data/tree/unit/directedit/vp912/vp912.aird";
    private static final String REPRESENTATION_NAME = "TreeWithDirectEdit";
    private String elementNameP2 = "P2";
    private String elementNameC1 = "C1";
    private String elementNameC2 = "C2";
    private String elementNameC1Renamed = "C1Renamed";
    private String elementNameMyAttRenammed = "myAttRenammed";
    private String elementNameC1CategorieRenamed = "C1 CategorieRenamed";
    private DTree tree;
    private EPackage semanticModel;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.genericSetUp(SEMANTIC_MODEL_PATH, MODELER_PATH, SESSION_PATH);
        this.tree = (DTree)this.getRepresentations(REPRESENTATION_NAME).toArray()[0];
        DialectUIManager.INSTANCE.openEditor(this.session, (DRepresentation)this.tree, (IProgressMonitor)new NullProgressMonitor());
        TestsUtil.synchronizationWithUIThread();
        this.semanticModel = (EPackage)this.tree.getTarget();
    }

    public void testDirectEditWithNoBehavior() {
        EPackage pkgToEdit = (EPackage)Iterables.filter((Iterable)this.semanticModel.getESubpackages(), (Predicate)new Predicate<EPackage>(){

            public boolean apply(EPackage input) {
                return TreeItemEditionToolTest.this.elementNameP2.equals(input.getName());
            }
        }).iterator().next();
        DTreeItem treeitem = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, (EObject)pkgToEdit);
        this.applyDirectEditTool(this.tree, treeitem, "P2Renamed");
        Assert.assertEquals((Object)this.elementNameP2, (Object)treeitem.getName());
        Assert.assertEquals((Object)this.elementNameP2, (Object)pkgToEdit.getName());
        this.applyUndo();
        Assert.assertEquals((Object)this.elementNameP2, (Object)treeitem.getName());
        Assert.assertEquals((Object)this.elementNameP2, (Object)pkgToEdit.getName());
        this.applyRedo();
        Assert.assertEquals((Object)this.elementNameP2, (Object)treeitem.getName());
        Assert.assertEquals((Object)this.elementNameP2, (Object)pkgToEdit.getName());
    }

    public void testDirectEditWithPrecondition() {
        EClass class1 = (EClass)this.semanticModel.getEClassifier(this.elementNameC1);
        EClass class2 = (EClass)this.semanticModel.getEClassifier(this.elementNameC2);
        DTreeItem treeitem1 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, (EObject)class1);
        DTreeItem treeitem2 = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, (EObject)class2);
        this.applyDirectEditTool(this.tree, treeitem1, this.elementNameC1Renamed);
        Assert.assertEquals((Object)this.elementNameC1Renamed, (Object)treeitem1.getName());
        Assert.assertEquals((Object)this.elementNameC1Renamed, (Object)class1.getName());
        this.applyDirectEditTool(this.tree, treeitem2, "C2Renamed");
        TestsUtil.synchronizationWithUIThread();
        Assert.assertEquals((Object)this.elementNameC2, (Object)treeitem2.getName());
        Assert.assertEquals((Object)this.elementNameC2, (Object)class2.getName());
        this.applyUndo();
        Assert.assertEquals((Object)this.elementNameC1, (Object)treeitem1.getName());
        Assert.assertEquals((Object)this.elementNameC1, (Object)class1.getName());
        Assert.assertEquals((Object)this.elementNameC2, (Object)treeitem2.getName());
        Assert.assertEquals((Object)this.elementNameC2, (Object)class2.getName());
        this.applyRedo();
        Assert.assertEquals((Object)this.elementNameC1Renamed, (Object)treeitem1.getName());
        Assert.assertEquals((Object)this.elementNameC1Renamed, (Object)class1.getName());
        Assert.assertEquals((Object)this.elementNameC2, (Object)treeitem2.getName());
        Assert.assertEquals((Object)this.elementNameC2, (Object)class2.getName());
    }

    public void testDirectEditWithEditMask() {
        EPackage pkgToEdit = (EPackage)Iterables.filter((Iterable)this.semanticModel.getESubpackages(), (Predicate)new Predicate<EPackage>(){

            public boolean apply(EPackage input) {
                return TreeItemEditionToolTest.this.elementNameP2.equals(input.getName());
            }
        }).iterator().next();
        EAttribute attributeToEdit = (EAttribute)((EClass)pkgToEdit.getEClassifier("C4")).getEAttributes().iterator().next();
        DTreeItem treeitem = (DTreeItem)this.getFirstRepresentationElement((DRepresentation)this.tree, (EObject)attributeToEdit);
        this.applyDirectEditTool(this.tree, treeitem, "myAttRenammed[4,-1]");
        Assert.assertEquals((Object)this.elementNameMyAttRenammed, (Object)treeitem.getName());
        Assert.assertEquals((Object)this.elementNameMyAttRenammed, (Object)attributeToEdit.getName());
        Assert.assertEquals((long)4L, (long)attributeToEdit.getLowerBound());
        Assert.assertEquals((long)-1L, (long)attributeToEdit.getUpperBound());
        this.applyUndo();
        Assert.assertEquals((Object)"myAtt", (Object)treeitem.getName());
        Assert.assertEquals((Object)"myAtt", (Object)attributeToEdit.getName());
        Assert.assertEquals((long)1L, (long)attributeToEdit.getLowerBound());
        Assert.assertEquals((long)1L, (long)attributeToEdit.getUpperBound());
        this.applyRedo();
        Assert.assertEquals((Object)this.elementNameMyAttRenammed, (Object)treeitem.getName());
        Assert.assertEquals((Object)this.elementNameMyAttRenammed, (Object)attributeToEdit.getName());
        Assert.assertEquals((long)4L, (long)attributeToEdit.getLowerBound());
        Assert.assertEquals((long)-1L, (long)attributeToEdit.getUpperBound());
    }

    public void testDirectEditWithoutEditionTool() {
        EClass class1 = (EClass)this.semanticModel.getEClassifier(this.elementNameC1);
        DTreeItem treeitem1 = (DTreeItem)this.getRepresentationElementWithName((DRepresentation)this.tree, "C1 Categorie");
        String originalName = treeitem1.getName();
        this.applyDirectEditTool(this.tree, treeitem1, this.elementNameC1CategorieRenamed);
        Assert.assertEquals((Object)originalName, (Object)treeitem1.getName());
        Assert.assertEquals((Object)this.elementNameC1, (Object)class1.getName());
        this.applyUndo();
        Assert.assertEquals((Object)"C1 Categorie", (Object)treeitem1.getName());
        Assert.assertEquals((Object)this.elementNameC1, (Object)class1.getName());
        this.applyRedo();
        Assert.assertEquals((Object)originalName, (Object)treeitem1.getName());
        Assert.assertEquals((Object)this.elementNameC1, (Object)class1.getName());
    }

    public void testDirectEditDefinitionWithImports() {
    }

    @Override
    protected void tearDown() throws Exception {
        this.tree = null;
        this.semanticModel = null;
        super.tearDown();
    }
}

