/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.operation;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.query.ISequenceEventQuery;
import org.eclipse.sirius.diagram.sequence.tool.internal.Messages;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.ext.base.Option;

public class VerticalSpaceExpansionOrReduction
extends AbstractModelChangeOperation<Void> {
    private final SequenceDiagram sequenceDiagram;
    private int insertionPoint;
    private int expansionSize;
    private Set<ISequenceEvent> eventsToIgnore;
    private Set<ISequenceNode> eventsToResize;
    private Set<ISequenceNode> eventsToShift;
    private Set<Message> messagesToResize;
    private Set<Message> messagesToShift;
    private Map<Message, Range> finalMessagesRanges;
    private Integer move;

    public VerticalSpaceExpansionOrReduction(SequenceDiagram diagram, Range shift, Integer move, Collection<ISequenceEvent> eventsToIgnore) {
        super(shift.getLowerBound() > shift.getUpperBound() ? MessageFormat.format(Messages.VerticalSpaceReduction_operationName, shift) : MessageFormat.format(Messages.VerticalSpaceExpansion_operationName, shift));
        this.sequenceDiagram = diagram;
        this.move = move;
        this.insertionPoint = shift.getLowerBound();
        this.expansionSize = shift.width();
        this.eventsToIgnore = new HashSet<ISequenceEvent>();
        for (ISequenceEvent evt : eventsToIgnore) {
            this.eventsToIgnore.add(evt);
            this.eventsToIgnore.addAll(new ISequenceEventQuery(evt).getAllDescendants());
            this.eventsToIgnore.addAll(new ISequenceEventQuery(evt).getAllMessages());
        }
    }

    public Void execute() {
        this.categorizeSequenceNodes(this.findAllSequenceNodesToConsider());
        this.categorizeMessages(this.findAllMessagesToConsider());
        this.computeFinalMessageRanges();
        this.expandLifelines();
        this.shiftSequenceNodes();
        this.resizeSequenceNodes();
        this.setFinalMessagesRanges();
        return null;
    }

    private void setFinalMessagesRanges() {
        for (Map.Entry<Message, Range> smep : this.finalMessagesRanges.entrySet()) {
            smep.getKey().setVerticalRange(smep.getValue());
        }
    }

    private void computeFinalMessageRanges() {
        this.finalMessagesRanges = new HashMap<Message, Range>();
        Set<Message> messages = this.sequenceDiagram.getAllMessages();
        for (Message msg : messages) {
            if (this.messagesToShift.contains(msg)) {
                if (!this.isConnectedToAMovedExecutionByASingleEnd(msg) && !this.isContainedReflexiveMessage(msg)) {
                    this.finalMessagesRanges.put(msg, msg.getVerticalRange().shifted(this.expansionSize));
                    continue;
                }
                this.finalMessagesRanges.put(msg, msg.getVerticalRange().shifted(this.move));
                continue;
            }
            if (this.messagesToResize.contains(msg)) {
                Range rangeBefore = msg.getVerticalRange();
                this.finalMessagesRanges.put(msg, new Range(rangeBefore.getLowerBound(), rangeBefore.getUpperBound() + this.expansionSize));
                continue;
            }
            this.finalMessagesRanges.put(msg, msg.getVerticalRange());
        }
    }

    private boolean isConnectedToAMovedExecutionByASingleEnd(Message msg) {
        boolean onlyTargetIsInMovedExecutions;
        boolean onlySourceIsInMovedExecutions = this.eventsToIgnore.contains(msg.getSourceElement()) && !this.eventsToIgnore.contains(msg.getTargetElement());
        boolean bl = onlyTargetIsInMovedExecutions = !this.eventsToIgnore.contains(msg.getSourceElement()) && this.eventsToIgnore.contains(msg.getTargetElement());
        return onlySourceIsInMovedExecutions || onlyTargetIsInMovedExecutions;
    }

    private void expandLifelines() {
        List<Lifeline> lifelines = this.sequenceDiagram.getAllLifelines();
        lifelines.removeAll(this.eventsToIgnore);
        for (Lifeline lifeline : lifelines) {
            Option<Message> cm = lifeline.getCreationMessage();
            if (cm.some() && this.isStrictlyBelowInsertionPoint((ISequenceEvent)cm.get())) {
                InstanceRole irep = lifeline.getInstanceRole();
                Node node = (Node)irep.getNotationView();
                LayoutConstraint layoutConstraint = node.getLayoutConstraint();
                if (!(layoutConstraint instanceof Location)) continue;
                Location location = (Location)layoutConstraint;
                location.setY(location.getY() + this.expansionSize);
                continue;
            }
            Option<Message> dm = lifeline.getDestructionMessage();
            if (dm.some() && !this.isStrictlyBelowInsertionPoint((ISequenceEvent)dm.get())) continue;
            this.expandDown(lifeline, this.expansionSize);
        }
    }

    private Set<ISequenceNode> findAllSequenceNodesToConsider() {
        LinkedHashSet<ISequenceNode> sequenceNodes = new LinkedHashSet<ISequenceNode>();
        sequenceNodes.addAll(this.sequenceDiagram.getAllAbstractNodeEvents());
        sequenceNodes.addAll(this.sequenceDiagram.getAllInteractionUses());
        sequenceNodes.addAll(this.sequenceDiagram.getAllCombinedFragments());
        sequenceNodes.addAll(this.sequenceDiagram.getAllOperands());
        sequenceNodes.removeAll(this.eventsToIgnore);
        return sequenceNodes;
    }

    private Set<Message> findAllMessagesToConsider() {
        HashSet<Message> messages = new HashSet<Message>();
        for (Message msg : this.sequenceDiagram.getAllMessages()) {
            if (this.isBetweenTwoMovedEvents(msg) && !this.isContainedReflexiveMessage(msg)) continue;
            messages.add(msg);
        }
        return messages;
    }

    private boolean isBetweenTwoMovedEvents(Message msg) {
        return this.eventsToIgnore.contains(msg.getSourceElement()) && this.eventsToIgnore.contains(msg.getTargetElement());
    }

    private boolean isContainedReflexiveMessage(Message msg) {
        return this.eventsToIgnore.contains(msg.getSourceElement()) && this.eventsToIgnore.contains(msg.getTargetElement()) && msg.isReflective();
    }

    private void categorizeMessages(Set<Message> messages) {
        this.messagesToResize = new HashSet<Message>();
        this.messagesToShift = new HashSet<Message>();
        for (Message ise : Iterables.filter(messages, (Predicate)Predicates.not((Predicate)Predicates.in(this.eventsToIgnore)))) {
            if (this.containsInsertionPoint(ise)) {
                this.messagesToResize.add(ise);
                continue;
            }
            if (!this.isStrictlyBelowInsertionPoint(ise) && !this.isConnectedToAMovedExecutionByASingleEnd(ise)) continue;
            this.messagesToShift.add(ise);
        }
    }

    private void categorizeSequenceNodes(Set<? extends ISequenceNode> sequenceNodes) {
        this.eventsToResize = new HashSet<ISequenceNode>();
        this.eventsToShift = new HashSet<ISequenceNode>();
        for (ISequenceNode iSequenceNode : sequenceNodes) {
            if (!(iSequenceNode instanceof ISequenceEvent)) continue;
            ISequenceEvent ise = (ISequenceEvent)((Object)iSequenceNode);
            if (this.containsInsertionPoint(ise)) {
                this.eventsToResize.add(iSequenceNode);
                continue;
            }
            if (!this.isStrictlyBelowInsertionPoint(ise) || iSequenceNode instanceof Operand && this.eventsToShift.contains(((Operand)iSequenceNode).getCombinedFragment())) continue;
            this.eventsToShift.add(iSequenceNode);
        }
    }

    private void shiftSequenceNodes() {
        for (ISequenceNode nodes : Iterables.filter(this.eventsToShift, (Predicate)Predicates.not((Predicate)Predicates.instanceOf(AbstractNodeEvent.class)))) {
            this.shift(nodes, this.expansionSize);
        }
        for (AbstractNodeEvent execution : Iterables.filter(this.eventsToShift, AbstractNodeEvent.class)) {
            Lifeline lep = (Lifeline)execution.getLifeline().get();
            Option<Message> cm = lep.getCreationMessage();
            if (cm.some() && this.isStrictlyBelowInsertionPoint((ISequenceEvent)cm.get()) || this.containsAncestors(this.eventsToShift, execution)) continue;
            this.shift(execution, this.expansionSize);
        }
        for (AbstractNodeEvent execution : Iterables.filter(this.eventsToIgnore, AbstractNodeEvent.class)) {
            if (!this.eventsToShift.contains(execution.getHierarchicalParentEvent())) continue;
            this.shift(execution, -this.expansionSize);
        }
    }

    private void resizeSequenceNodes() {
        for (ISequenceNode ise : this.eventsToResize) {
            this.expandDown(ise, this.expansionSize);
        }
    }

    private boolean containsAncestors(Set<ISequenceNode> events, AbstractNodeEvent ise) {
        ISequenceEvent parent = ise.getHierarchicalParentEvent();
        if (parent == null || !(parent instanceof AbstractNodeEvent)) {
            return false;
        }
        return Iterables.contains(events, (Object)parent) || this.containsAncestors(events, (AbstractNodeEvent)parent);
    }

    private boolean containsInsertionPoint(ISequenceEvent event) {
        return event != null && event.getVerticalRange().includes(this.insertionPoint, true, false);
    }

    private boolean isStrictlyBelowInsertionPoint(ISequenceEvent event) {
        return event != null && event.getVerticalRange().getLowerBound() >= this.insertionPoint;
    }

    private void expandDown(Lifeline lifeline, int height) {
        Range range = lifeline.getVerticalRange();
        lifeline.setVerticalRange(new Range(range.getLowerBound(), range.getUpperBound() + height));
    }

    private void expandDown(ISequenceNode isn, int height) {
        Node node = isn.getNotationNode();
        LayoutConstraint layoutConstraint = node.getLayoutConstraint();
        if (layoutConstraint instanceof Size) {
            Size s = (Size)layoutConstraint;
            s.setHeight(s.getHeight() + height);
        }
    }

    private void shift(ISequenceNode isn, int height) {
        Node node = (Node)isn.getNotationView();
        LayoutConstraint layoutConstraint = node.getLayoutConstraint();
        if (layoutConstraint instanceof Location && height != 0) {
            Location location = (Location)layoutConstraint;
            location.setY(location.getY() + height);
        }
    }
}

