/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.elk;

import com.google.inject.Injector;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.elk.core.service.LayoutConnectorsService;
import org.eclipse.elk.core.service.LayoutMapping;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.elk.DiagramElkPlugin;
import org.eclipse.sirius.diagram.elk.ELKLayoutExtensionCommand;
import org.eclipse.sirius.diagram.elk.ElkDiagramLayoutConnector;
import org.eclipse.sirius.diagram.elk.GmfLayoutCommand;
import org.eclipse.sirius.diagram.elk.IELKLayoutExtension;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.DefaultLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.util.EditPartQuery;

public class ELKLayoutNodeProvider
extends DefaultLayoutProvider {
    public Command layoutEditParts(List selectedObjects, IAdaptable layoutHint) {
        return this.layoutEditParts(selectedObjects, layoutHint, false);
    }

    public Command layoutEditParts(List selectedObjects, IAdaptable layoutHint, boolean isArrangeAll) {
        List<IELKLayoutExtension> elkLayoutExtensions = IELKLayoutExtension.getLayoutExtensions();
        DiagramEditPart diagramEditPart = (DiagramEditPart)layoutHint.getAdapter(DiagramEditPart.class);
        boolean layoutOnDiagram = true;
        if (diagramEditPart == null) {
            layoutOnDiagram = false;
            IGraphicalEditPart editPart = (IGraphicalEditPart)layoutHint.getAdapter(IGraphicalEditPart.class);
            diagramEditPart = (DiagramEditPart)Optional.ofNullable(editPart).map(graphicalEditPart -> (DDiagramEditPart)new EditPartQuery(graphicalEditPart).getFirstAncestorOfType(DDiagramEditPart.class)).get();
        }
        if (diagramEditPart == null) {
            return UnexecutableCommand.INSTANCE;
        }
        Injector injector = LayoutConnectorsService.getInstance().getInjector(null, (Object)selectedObjects);
        ElkDiagramLayoutConnector connector = (ElkDiagramLayoutConnector)injector.getInstance(ElkDiagramLayoutConnector.class);
        connector.setLayoutConfiguration(this.layoutConfiguration);
        boolean isArrangeAtOpening = "OPENING".equals(layoutHint.getAdapter(String.class));
        LayoutMapping layoutMapping = connector.buildLayoutGraph(diagramEditPart, selectedObjects, isArrangeAll, isArrangeAtOpening);
        DiagramElkPlugin.getPlugin().traceForDebug(layoutMapping.getLayoutGraph(), "1_initialState");
        elkLayoutExtensions.forEach(e -> e.beforeELKLayout(layoutMapping));
        DiagramElkPlugin.getPlugin().traceForDebug(layoutMapping.getLayoutGraph(), "2_beforeELKLayout");
        connector.layout(layoutMapping);
        DiagramElkPlugin.getPlugin().traceForDebug(layoutMapping.getLayoutGraph(), "3_afterELKLayout");
        elkLayoutExtensions.forEach(e -> e.afterELKLayout(layoutMapping));
        DiagramElkPlugin.getPlugin().traceForDebug(layoutMapping.getLayoutGraph(), "4_afterExtensionUpdate");
        connector.transferLayout(layoutMapping, isArrangeAll || layoutOnDiagram && isArrangeAtOpening);
        Command gmfLayoutCommand = connector.getApplyCommand(layoutMapping);
        Optional<GmfLayoutCommand> concreteGmfLayoutCommand = this.getConcreteGMFLayoutCommand(gmfLayoutCommand);
        if (concreteGmfLayoutCommand.isPresent()) {
            return gmfLayoutCommand.chain((Command)new ICommandProxy((ICommand)new ELKLayoutExtensionCommand(concreteGmfLayoutCommand.get(), elkLayoutExtensions, layoutMapping)));
        }
        return gmfLayoutCommand;
    }

    private Optional<GmfLayoutCommand> getConcreteGMFLayoutCommand(Command gmfLayoutCommand) {
        return Optional.ofNullable(gmfLayoutCommand).filter(ICommandProxy.class::isInstance).map(c -> ((ICommandProxy)c).getICommand()).filter(GmfLayoutCommand.class::isInstance).map(GmfLayoutCommand.class::cast);
    }
}

