/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.templates.ScriptTemplateContextType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.templates.PHPTemplateContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;

public class PHPTemplateStore
extends ContributionTemplateStore {
    public PHPTemplateStore(ContextTypeRegistry registry, IPreferenceStore store, String key) {
        super(registry, store, key);
    }

    public void add(TemplatePersistenceData data) {
        Template template = data.getTemplate();
        if (template.getName().equals("")) {
            String title = PHPUIMessages.PHPTemplateStore_error_title;
            String message = PHPUIMessages.PHPTemplateStore_error_message_nameEmpty;
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
            return;
        }
        super.add(data);
    }

    public static CompiledTemplate compileTemplate(ContextTypeRegistry contextTypeRegistry, Template template, String containerName, String fileName) {
        return PHPTemplateStore.compileTemplate(contextTypeRegistry, template, containerName, fileName, null);
    }

    public static CompiledTemplate compileTemplate(ContextTypeRegistry contextTypeRegistry, Template template, String containerName, String fileName, String lineDelimiter) {
        String string = null;
        int offset = 0;
        if (template != null) {
            Document document = new Document();
            DocumentTemplateContext context = PHPTemplateStore.getContext(contextTypeRegistry, template, containerName, fileName, (IDocument)document);
            if (context instanceof PHPTemplateContext) {
                PHPTemplateContext phpTemplateContext = (PHPTemplateContext)context;
                phpTemplateContext.setLineDelimiter(lineDelimiter);
            }
            TemplateBuffer buffer = null;
            try {
                buffer = context.evaluate(template);
            }
            catch (BadLocationException e) {
                PHPUiPlugin.log(e);
            }
            catch (TemplateException e) {
                PHPUiPlugin.log(e);
            }
            if (buffer != null) {
                string = buffer.getString();
                TemplateVariable[] variables = buffer.getVariables();
                int i = 0;
                while (i != variables.length) {
                    TemplateVariable variable = variables[i];
                    if ("cursor".equals(variable.getName())) {
                        offset = variable.getOffsets()[0];
                    }
                    ++i;
                }
            }
        }
        return new CompiledTemplate(string, offset);
    }

    public static CompiledTemplate compileTemplate(ContextTypeRegistry contextTypeRegistry, Template template) {
        return PHPTemplateStore.compileTemplate(contextTypeRegistry, template, null, null);
    }

    public static CompiledTemplate compileTemplate(ContextTypeRegistry contextTypeRegistry, Template template, String lineDelimiter) {
        return PHPTemplateStore.compileTemplate(contextTypeRegistry, template, null, null, lineDelimiter);
    }

    private static DocumentTemplateContext getContext(ContextTypeRegistry contextTypeRegistry, Template template, String containerName, String fileName, IDocument document) {
        if (fileName == null) {
            return new DocumentTemplateContext(contextTypeRegistry.getContextType(template.getContextTypeId()), document, 0, 0);
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(containerName + "/" + fileName));
        ISourceModule sourceModule = DLTKCore.createSourceModuleFrom((IFile)file);
        TemplateContextType type = contextTypeRegistry.getContextType(template.getContextTypeId());
        return ((ScriptTemplateContextType)type).createContext(document, 0, 0, sourceModule);
    }

    public static class CompiledTemplate {
        public final String string;
        public final int offset;

        public CompiledTemplate(String string, int offset) {
            this.string = string;
            this.offset = offset;
        }
    }
}

