/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.projectconverter;

import org.eclipse.cdt.managedbuilder.core.IBuildObjectProperties;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class UpdateManagedProject31 {
    private static final String INEXISTEND_PROP_ID = "";

    static void doProjectUpdate(IProgressMonitor monitor, IProject project) throws CoreException {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        ((ManagedBuildInfo)info).setVersion(ManagedBuildManager.getBuildInfoVersion().toString());
        info.setValid(true);
        UpdateManagedProject31.adjustProperties(info);
    }

    private static void adjustProperties(IManagedBuildInfo info) {
        IManagedProject mProj = info.getManagedProject();
        IConfiguration[] cfgs = mProj.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            UpdateManagedProject31.adjustProperties(cfgs[i]);
            ++i;
        }
    }

    private static void adjustProperties(IConfiguration cfg) {
        IBuildObjectProperties props = cfg.getBuildProperties();
        if (props == null) {
            return;
        }
        boolean artefactTypeSupported = props.supportsType("org.eclipse.cdt.build.core.buildArtefactType");
        boolean buildTypeSupported = props.supportsType("org.eclipse.cdt.build.core.buildType");
        if (!artefactTypeSupported && !buildTypeSupported) {
            return;
        }
        String artefactType = artefactTypeSupported ? null : INEXISTEND_PROP_ID;
        String buildType = buildTypeSupported ? null : INEXISTEND_PROP_ID;
        String artExt = ((Configuration)cfg).getArtifactExtensionAttribute(false);
        String id = cfg.getId();
        if (artefactType == null) {
            artefactType = UpdateManagedProject31.getBuildArtefactTypeFromId(id);
        }
        if (buildType == null) {
            buildType = UpdateManagedProject31.getBuildTypeFromId(id);
        }
        if (artefactType == null || buildType == null) {
            IToolChain tc = cfg.getToolChain();
            while (tc != null && (artefactType == null || buildType == null)) {
                id = tc.getId();
                if (artefactType == null) {
                    artefactType = UpdateManagedProject31.getBuildArtefactTypeFromId(id);
                }
                if (buildType == null) {
                    buildType = UpdateManagedProject31.getBuildTypeFromId(id);
                }
                tc = tc.getSuperClass();
            }
        }
        if (artefactType != null && artefactType != INEXISTEND_PROP_ID) {
            try {
                props.setProperty("org.eclipse.cdt.build.core.buildArtefactType", artefactType);
            }
            catch (CoreException e) {
                ManagedBuilderCorePlugin.log(e);
            }
        }
        if (buildType != null && buildType != INEXISTEND_PROP_ID) {
            try {
                props.setProperty("org.eclipse.cdt.build.core.buildType", buildType);
            }
            catch (CoreException e) {
                ManagedBuilderCorePlugin.log(e);
            }
        }
        if (artExt != null) {
            cfg.setArtifactExtension(artExt);
        }
    }

    private static String getBuildArtefactTypeFromId(String id) {
        if (id.indexOf(".exe") != -1) {
            return "org.eclipse.cdt.build.core.buildArtefactType.exe";
        }
        if (id.indexOf(".so") != -1) {
            return "org.eclipse.cdt.build.core.buildArtefactType.sharedLib";
        }
        if (id.indexOf(".lib") != -1) {
            return "org.eclipse.cdt.build.core.buildArtefactType.staticLib";
        }
        return null;
    }

    private static String getBuildTypeFromId(String id) {
        if (id.indexOf(".debug") != -1) {
            return "org.eclipse.cdt.build.core.buildType.debug";
        }
        if (id.indexOf(".release") != -1) {
            return "org.eclipse.cdt.build.core.buildType.release";
        }
        return null;
    }
}

