/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.stream.Collectors;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

@ConfinedToDsfExecutor(value="DsfSession.getSession(sessionId).getExecutor()")
public class DsfServicesTracker {
    private final String fSessionId;
    private volatile boolean fDisposed;
    private final BundleContext fBundleContext;
    private final Map<ServiceKey, ServiceReference<?>> fServiceReferences;
    private final Map<ServiceReference<?>, Object> fServices;
    private final String fServiceFilter;
    private final ServiceListener fListener;

    private static String getServiceFilter(String sessionId) {
        return ("(org.eclipse.cdt.dsf.service.IService.session_id=" + sessionId + ")").intern();
    }

    private void handleUnregisterEvent(ServiceEvent event) {
        Iterator<Map.Entry<ServiceKey, ServiceReference<?>>> itr = this.fServiceReferences.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<ServiceKey, ServiceReference<?>> entry = itr.next();
            if (!entry.getValue().equals((Object)event.getServiceReference())) continue;
            itr.remove();
        }
        if (this.fServices.remove(event.getServiceReference()) != null) {
            this.fBundleContext.ungetService(event.getServiceReference());
        }
    }

    @ThreadSafe
    public DsfServicesTracker(BundleContext bundleContext, String sessionId) {
        block2: {
            this.fDisposed = false;
            this.fServiceReferences = new HashMap();
            this.fServices = new HashMap();
            this.fListener = new ServiceListener(){

                public void serviceChanged(final ServiceEvent event) {
                    if (event.getType() != 4) {
                        return;
                    }
                    DsfSession session = DsfSession.getSession(DsfServicesTracker.this.fSessionId);
                    if (session == null) {
                        return;
                    }
                    if (session.getExecutor().isInExecutorThread()) {
                        DsfServicesTracker.this.handleUnregisterEvent(event);
                    } else {
                        try {
                            session.getExecutor().execute(new DsfRunnable(){

                                @Override
                                public void run() {
                                    DsfServicesTracker.this.handleUnregisterEvent(event);
                                }
                            });
                        }
                        catch (RejectedExecutionException rejectedExecutionException) {
                            // empty catch block
                        }
                    }
                }
            };
            this.fSessionId = sessionId;
            this.fBundleContext = bundleContext;
            this.fServiceFilter = DsfServicesTracker.getServiceFilter(sessionId);
            try {
                this.fBundleContext.addServiceListener(this.fListener, this.fServiceFilter);
            }
            catch (InvalidSyntaxException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"Invalid session ID syntax");
            }
        }
    }

    public <V> ServiceReference<V> getServiceReference(Class<V> serviceClass, String filter) {
        Collection references;
        ServiceKey key;
        block10: {
            if (this.fDisposed) {
                return null;
            }
            DsfSession session = DsfSession.getSession(this.fSessionId);
            if (session == null) {
                return null;
            }
            assert (session.getExecutor().isInExecutorThread());
            key = new ServiceKey(serviceClass, filter != null ? filter : this.fServiceFilter);
            if (this.fServiceReferences.containsKey(key)) {
                ServiceReference<?> ref = this.fServiceReferences.get(key);
                return ref;
            }
            references = this.fBundleContext.getServiceReferences(serviceClass, key.fFilter);
            assert (references == null || references.size() <= 1);
            if (references != null && !references.isEmpty()) break block10;
            return null;
        }
        try {
            ServiceReference ref = (ServiceReference)references.iterator().next();
            this.fServiceReferences.put(key, ref);
            return ref;
        }
        catch (InvalidSyntaxException e) {
            assert (false) : "Invalid session ID syntax";
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    public <V> Collection<ServiceReference<V>> getServiceReferences(Class<V> serviceClass, String filter) {
        if (this.fDisposed) {
            return Collections.emptyList();
        }
        DsfSession session = DsfSession.getSession(this.fSessionId);
        if (session == null) {
            return Collections.emptyList();
        }
        assert (session.getExecutor().isInExecutorThread());
        try {
            return this.fBundleContext.getServiceReferences(serviceClass, filter != null ? filter : this.fServiceFilter);
        }
        catch (InvalidSyntaxException e) {
            assert (false) : "Invalid session ID syntax";
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    public <V> V getService(Class<V> serviceClass) {
        return this.getService(serviceClass, null);
    }

    public <V> Collection<V> getServices(Class<V> serviceClass) {
        return this.getServices(serviceClass, null);
    }

    public <V> V getService(Class<V> serviceClass, String filter) {
        ServiceReference<V> serviceRef = this.getServiceReference(serviceClass, filter);
        if (serviceRef == null) {
            return null;
        }
        V service = this.getServiceHelper(serviceRef);
        return service;
    }

    public <V> Collection<V> getServices(Class<V> serviceClass, String filter) {
        return this.getServiceReferences(serviceClass, filter).stream().map(this::getServiceHelper).collect(Collectors.toList());
    }

    private <V> V getServiceHelper(ServiceReference<V> serviceRef) {
        Object service = this.fServices.get(serviceRef);
        if (service == null && !this.fServices.containsKey(serviceRef)) {
            service = this.fBundleContext.getService(serviceRef);
            this.fServices.put(serviceRef, service);
        }
        return (V)service;
    }

    @ThreadSafe
    public void dispose() {
        assert (!this.fDisposed);
        this.fDisposed = true;
        DsfSession session = DsfSession.getSession(this.fSessionId);
        if (session != null) {
            try {
                if (!session.getExecutor().isInExecutorThread()) {
                    session.getExecutor().execute(this::doDispose);
                    return;
                }
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        this.doDispose();
    }

    private void doDispose() {
        try {
            this.fBundleContext.removeServiceListener(this.fListener);
            for (ServiceReference<?> serviceRef : this.fServices.keySet()) {
                this.fBundleContext.ungetService(serviceRef);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.fServices.clear();
        this.fServiceReferences.clear();
    }

    protected void finalize() throws Throwable {
        assert (this.fDisposed);
        super.finalize();
    }

    private static final class ServiceKey {
        private final String fClassName;
        private final String fFilter;
        private final int fHashCode;
        private final String fHashString;

        public ServiceKey(Class<?> clazz, String filter) {
            this.fClassName = clazz != null ? clazz.getName() : null;
            this.fFilter = filter;
            this.fHashString = "C" + (this.fClassName == null ? "" : this.fClassName) + "F" + (this.fFilter == null ? "" : this.fFilter);
            this.fHashCode = this.fHashString.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof ServiceKey && ((ServiceKey)other).fHashCode == this.fHashCode && ((ServiceKey)other).fHashString.equals(this.fHashString);
        }

        public int hashCode() {
            return this.fHashCode;
        }
    }
}

