/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.parser.ParserMessages;

public class ASTProblem
extends ASTNode
implements IASTProblem {
    protected static final Map<Integer, String> errorMessages = new HashMap<Integer, String>();
    private final int id;
    private final char[] arg;
    private boolean isError;
    private IASTProblem originalProblem = null;

    static {
        errorMessages.put(0x2000001, ParserMessages.getString("ScannerProblemFactory.error.preproc.error"));
        errorMessages.put(0x200000E, ParserMessages.getString("ScannerProblemFactory.error.preproc.warning"));
        errorMessages.put(0x2000002, ParserMessages.getString("ScannerProblemFactory.error.preproc.inclusionNotFound"));
        errorMessages.put(0x2000003, ParserMessages.getString("ScannerProblemFactory.error.preproc.definitionNotFound"));
        errorMessages.put(0x2000005, ParserMessages.getString("ScannerProblemFactory.error.preproc.invalidMacroDefn"));
        errorMessages.put(0x2000007, ParserMessages.getString("ScannerProblemFactory.error.preproc.invalidMacroRedefn"));
        errorMessages.put(0x2000004, ParserMessages.getString("ScannerProblemFactory.error.preproc.unbalancedConditional"));
        errorMessages.put(0x2000008, ParserMessages.getString("ScannerProblemFactory.error.preproc.conditionalEval"));
        errorMessages.put(0x2000009, ParserMessages.getString("ScannerProblemFactory.error.preproc.macroUsage"));
        errorMessages.put(0x200000B, ParserMessages.getString("ScannerProblemFactory.error.preproc.circularInclusion"));
        errorMessages.put(0x2000006, ParserMessages.getString("ScannerProblemFactory.error.preproc.invalidDirective"));
        errorMessages.put(0x200000A, ParserMessages.getString("ScannerProblemFactory.error.preproc.macroPasting"));
        errorMessages.put(0x200000C, ParserMessages.getString("ScannerProblemFactory.error.preproc.missingRParen"));
        errorMessages.put(0x200000D, ParserMessages.getString("ScannerProblemFactory.error.preproc.invalidVaArgs"));
        errorMessages.put(0x1000003, ParserMessages.getString("ScannerProblemFactory.error.scanner.invalidEscapeChar"));
        errorMessages.put(0x1000002, ParserMessages.getString("ScannerProblemFactory.error.scanner.unboundedString"));
        errorMessages.put(0x1000004, ParserMessages.getString("ScannerProblemFactory.error.scanner.badFloatingPoint"));
        errorMessages.put(0x100000F, ParserMessages.getString("ScannerProblemFactory.error.scanner.badBinaryFormat"));
        errorMessages.put(0x1000005, ParserMessages.getString("ScannerProblemFactory.error.scanner.badHexFormat"));
        errorMessages.put(0x1000007, ParserMessages.getString("ScannerProblemFactory.error.scanner.badOctalFormat"));
        errorMessages.put(0x1000008, ParserMessages.getString("ScannerProblemFactory.error.scanner.badDecimalFormat"));
        errorMessages.put(0x1000009, ParserMessages.getString("ScannerProblemFactory.error.scanner.assignmentNotAllowed"));
        errorMessages.put(0x100000A, ParserMessages.getString("ScannerProblemFactory.error.scanner.divideByZero"));
        errorMessages.put(0x100000B, ParserMessages.getString("ScannerProblemFactory.error.scanner.missingRParen"));
        errorMessages.put(0x100000C, ParserMessages.getString("ScannerProblemFactory.error.scanner.expressionSyntaxError"));
        errorMessages.put(0x100000D, ParserMessages.getString("ScannerProblemFactory.error.scanner.illegalIdentifier"));
        errorMessages.put(0x100000E, ParserMessages.getString("ScannerProblemFactory.error.scanner.badConditionalExpression"));
        errorMessages.put(0x1000006, ParserMessages.getString("ScannerProblemFactory.error.scanner.unexpectedEOF"));
        errorMessages.put(0x1000001, ParserMessages.getString("ScannerProblemFactory.error.scanner.badCharacter"));
        errorMessages.put(0x1000010, ParserMessages.getString("ScannerProblemFactory.error.scanner.constantWithBadSuffix"));
        errorMessages.put(0x1000011, ParserMessages.getString("ScannerProblemFactory.error.scanner.floatWithBadPrefix"));
        errorMessages.put(0x2000010, ParserMessages.getString("ScannerProblemFactory.error.preproc.multipleUserDefinedLiteralSuffixesOnStringLiteral"));
        errorMessages.put(0x2000011, ParserMessages.getString("ScannerProblemFactory.error.preproc.invalidUsageOutsidePreprocDirective"));
        errorMessages.put(0x4000001, ParserMessages.getString("ParserProblemFactory.error.syntax.syntaxError"));
        errorMessages.put(0x4000002, ParserMessages.getString("ParserProblemFactory.error.syntax.missingSemicolon"));
        errorMessages.put(0x10000001, ParserMessages.getString("ParserProblemFactory.error.syntax.templateArgumentNestingDepthLimitExceeded"));
    }

    public ASTProblem(IASTNode parent, ASTNodeProperty property, int id, char[] arg, boolean isError, int startNumber, int endNumber) {
        this.setParent(parent);
        this.setPropertyInParent(property);
        this.setOffset(startNumber);
        this.setLength(endNumber - startNumber);
        this.id = id;
        this.arg = arg;
        this.isError = isError;
    }

    public ASTProblem(int id, char[] arg, boolean isError) {
        this.id = id;
        this.arg = arg;
        this.isError = isError;
    }

    @Override
    public ASTProblem copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public ASTProblem copy(IASTNode.CopyStyle style) {
        ASTProblem copy = new ASTProblem(this.id, this.arg == null ? null : (char[])this.arg.clone(), this.isError);
        return this.copy(copy, style);
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public boolean isError() {
        return this.isError;
    }

    @Override
    public boolean isWarning() {
        return !this.isError;
    }

    @Override
    public String getMessageWithLocation() {
        String msg = this.getMessage();
        char[] file = this.getOriginatingFileName();
        int line = this.getSourceLineNumber();
        Object[] args = new Object[]{msg, new String(file), line};
        return ParserMessages.getFormattedString("BaseProblemFactory.problemPattern", args);
    }

    private static String getMessage(int id, String arg, IASTProblem originalProblem) {
        String msg = errorMessages.get(id);
        if (msg == null) {
            msg = "";
        }
        if (arg != null) {
            msg = MessageFormat.format(msg, arg);
        }
        if (originalProblem != null) {
            msg = MessageFormat.format("{0}: {1}", msg, originalProblem.getMessage());
        }
        return msg;
    }

    public static String getMessage(int id, String arg) {
        return ASTProblem.getMessage(id, arg, null);
    }

    @Override
    public String getMessage() {
        return ASTProblem.getMessage(this.id, this.arg == null ? null : new String(this.arg), this.originalProblem);
    }

    @Override
    public boolean checkCategory(int bitmask) {
        return (this.id & bitmask) != 0;
    }

    @Override
    public String[] getArguments() {
        String[] stringArray;
        if (this.arg == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = new String(this.arg);
        }
        return stringArray;
    }

    public char[] getArgument() {
        return this.arg;
    }

    @Override
    public char[] getOriginatingFileName() {
        return this.getContainingFilename().toCharArray();
    }

    @Override
    public int getSourceEnd() {
        IASTFileLocation location = this.getFileLocation();
        if (location != null) {
            return location.getNodeOffset() + location.getNodeLength() - 1;
        }
        return -1;
    }

    @Override
    public int getSourceLineNumber() {
        IASTFileLocation location = this.getFileLocation();
        if (location != null) {
            return location.getStartingLineNumber();
        }
        return -1;
    }

    @Override
    public int getSourceStart() {
        IASTFileLocation location = this.getFileLocation();
        if (location != null) {
            return location.getNodeOffset();
        }
        return -1;
    }

    @Override
    public IASTProblem getOriginalProblem() {
        return this.originalProblem;
    }

    @Override
    public void setOriginalProblem(IASTProblem original) {
        this.originalProblem = original;
    }
}

