/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.memory.search;

import java.util.Properties;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.memory.search.FindReplaceDialog;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class FindAction
implements IViewActionDelegate {
    private static String FIND_NEXT_ID = "org.eclipse.cdt.debug.ui.memory.search.FindNextAction";
    private IMemoryRenderingSite fView;
    private static Properties fSearchDialogProperties = new Properties();
    private static IAction fAction = null;

    public static Properties getProperties() {
        return fSearchDialogProperties;
    }

    public void init(IViewPart view) {
        if (view instanceof IMemoryRenderingSite) {
            this.fView = (IMemoryRenderingSite)view;
        }
    }

    public void run(IAction action) {
        ISelection selection = this.fView.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection strucSel = (IStructuredSelection)selection;
            if (strucSel.isEmpty()) {
                return;
            }
            Object obj = strucSel.getFirstElement();
            if (obj == null) {
                return;
            }
            IMemoryBlock memBlock = null;
            if (obj instanceof IMemoryRendering) {
                memBlock = ((IMemoryRendering)obj).getMemoryBlock();
            } else if (obj instanceof IMemoryBlock) {
                memBlock = (IMemoryBlock)obj;
            }
            Shell shell = CDebugUIPlugin.getActiveWorkbenchShell();
            FindReplaceDialog dialog = new FindReplaceDialog(shell, (IMemoryBlockExtension)memBlock, this.fView, fSearchDialogProperties, fAction);
            if (action.getId().equals(FIND_NEXT_ID)) {
                if (Boolean.valueOf(fSearchDialogProperties.getProperty("SEARCH_ENABLE_FIND_NEXT", Boolean.FALSE.toString())).booleanValue()) {
                    dialog.performFindNext();
                }
                return;
            }
            dialog.open();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (action.getId().equals(FIND_NEXT_ID)) {
            fAction = action;
            action.setEnabled(Boolean.valueOf(fSearchDialogProperties.getProperty("SEARCH_ENABLE_FIND_NEXT", Boolean.FALSE.toString())).booleanValue());
        }
    }
}

