/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.wizards;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.profile.ui.PHPProfileUIMessages;
import org.eclipse.php.profile.ui.ProfilerUiPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ImportSessionWizardFirstPage
extends WizardPage {
    private Listener fieldModifyListener = new Listener(){

        public void handleEvent(Event e) {
            boolean valid = ImportSessionWizardFirstPage.this.validatePage();
            ImportSessionWizardFirstPage.this.setPageComplete(valid);
        }
    };
    private Text fSourceField;
    private Button fSourceBtn;
    private String fSourceFile;
    private int fSourceType;

    public ImportSessionWizardFirstPage() {
        super(PHPProfileUIMessages.getString("ImportSessionWizardPage1.0"));
        this.setTitle(PHPProfileUIMessages.getString("ImportSessionWizardPage1.1"));
        this.setDescription(PHPProfileUIMessages.getString("ImportSessionWizardPage1.7"));
        this.setPageComplete(false);
    }

    public String getSourceFile() {
        return this.fSourceFile;
    }

    public int getSourceType() {
        return this.fSourceType;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        try {
            this.fSourceType = ProfilerUiPlugin.getDefault().getDialogSettings().getInt("importType");
        }
        catch (NumberFormatException numberFormatException) {
            this.fSourceType = 0;
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 0);
        label.setText(PHPProfileUIMessages.getString("ImportSessionWizardPage1.8"));
        ComboViewer typeCombo = new ComboViewer(composite, 8);
        typeCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        typeCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Integer) {
                    switch (Integer.valueOf((Integer)element)) {
                        case 0: {
                            return PHPProfileUIMessages.getString("ImportSessionWizardPage1.9");
                        }
                        case 1: {
                            return PHPProfileUIMessages.getString("ImportSessionWizardPage1.10");
                        }
                    }
                }
                return super.getText(element);
            }
        });
        typeCombo.setInput((Object)new Integer[]{0, 1});
        typeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getStructuredSelection() != null && event.getStructuredSelection().getFirstElement() instanceof Integer) {
                    ImportSessionWizardFirstPage.this.fSourceType = (Integer)event.getStructuredSelection().getFirstElement();
                    ProfilerUiPlugin.getDefault().getDialogSettings().put("importType", ImportSessionWizardFirstPage.this.fSourceType);
                }
            }
        });
        typeCombo.setSelection((ISelection)new StructuredSelection((Object)this.fSourceType));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        typeCombo.getCombo().setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText(PHPProfileUIMessages.getString("ImportSessionWizardPage1.2"));
        this.fSourceField = new Text(composite, 2048);
        this.fSourceField.addListener(24, this.fieldModifyListener);
        this.fSourceField.setLayoutData((Object)new GridData(768));
        this.fSourceBtn = new Button(composite, 0);
        this.fSourceBtn.setText(PHPProfileUIMessages.getString("ImportSessionWizardPage1.3"));
        this.fSourceBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String file;
                FileDialog dialog = new FileDialog(ImportSessionWizardFirstPage.this.fSourceBtn.getShell(), 4096);
                if (ImportSessionWizardFirstPage.this.fSourceType == 0) {
                    dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
                }
                dialog.setText(PHPProfileUIMessages.getString("ImportSessionWizardPage1.4"));
                String dirName = new File(ImportSessionWizardFirstPage.this.fSourceField.getText().trim()).getParent();
                if (dirName != null && dirName.length() > 0 && new File(dirName).exists()) {
                    dialog.setFilterPath(new Path(dirName).toOSString());
                }
                if ((file = dialog.open()) != null) {
                    ImportSessionWizardFirstPage.this.fSourceField.setText(file);
                }
            }
        });
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.php.help.importing_profile_sessions");
    }

    protected boolean validatePage() {
        String sourceFile = this.fSourceField.getText().trim();
        if (sourceFile.length() == 0) {
            this.setMessage(null);
            this.setErrorMessage(PHPProfileUIMessages.getString("ImportSessionWizardPage1.5"));
            return false;
        }
        if (!new File(sourceFile).exists()) {
            this.setMessage(null);
            this.setErrorMessage(NLS.bind((String)PHPProfileUIMessages.getString("ImportSessionWizardPage1.6"), (Object)sourceFile));
            return false;
        }
        this.fSourceFile = sourceFile;
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }
}

