/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import java.util.List;
import org.eclipse.core.databinding.beans.IBeanListProperty;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.ListProperty;
import org.eclipse.core.internal.databinding.beans.BeanObservableListDecorator;

public class BeanListPropertyDecorator<S, E>
extends ListProperty<S, E>
implements IBeanListProperty<S, E> {
    private final IListProperty<S, E> delegate;
    private final PropertyDescriptor propertyDescriptor;

    public BeanListPropertyDecorator(IListProperty<S, E> delegate, PropertyDescriptor propertyDescriptor) {
        this.delegate = delegate;
        this.propertyDescriptor = propertyDescriptor;
    }

    public Object getElementType() {
        return this.delegate.getElementType();
    }

    protected List<E> doGetList(S source) {
        return this.delegate.getList(source);
    }

    protected void doSetList(S source, List<E> list) {
        this.delegate.setList(source, list);
    }

    protected void doUpdateList(S source, ListDiff<E> diff) {
        this.delegate.updateList(source, diff);
    }

    @Override
    public IBeanListProperty<S, Object> values(String propertyName) {
        return this.values(propertyName, null);
    }

    @Override
    public <E2> IBeanListProperty<S, E2> values(String propertyName, Class<E2> valueType) {
        Class beanClass = (Class)this.delegate.getElementType();
        return this.values(BeanProperties.value(beanClass, propertyName, valueType));
    }

    @Override
    public <E2> IBeanListProperty<S, E2> values(IBeanValueProperty<? super E, E2> property) {
        return new BeanListPropertyDecorator<S, E>(super.values(property), property.getPropertyDescriptor());
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public IObservableList<E> observe(S source) {
        return new BeanObservableListDecorator(this.delegate.observe(source), this.propertyDescriptor);
    }

    public IObservableList<E> observe(Realm realm, S source) {
        return new BeanObservableListDecorator(this.delegate.observe(realm, source), this.propertyDescriptor);
    }

    public <U extends S> IObservableList<E> observeDetail(IObservableValue<U> master) {
        return new BeanObservableListDecorator(this.delegate.observeDetail(master), this.propertyDescriptor);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

