/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.extension.ICProjectConverter;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.SettingsModelMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public class CProjectConverterDesciptor {
    static final String PROJECT_CONVERTER_EXTPOINT_ID = "org.eclipse.cdt.core.projectConverter";
    static final String CONVERTER = "converter";
    static final String CLASS = "class";
    static final String NATURES = "natures";
    static final String OWNERS = "owners";
    static final String DELIMITER = ";";
    private String fId;
    private ICProjectConverter fConverter;
    private IExtension fExtension;
    private IConfigurationElement fConverterElement;

    CProjectConverterDesciptor(IExtension extension) {
        this.fId = extension.getUniqueIdentifier();
        this.fExtension = extension;
    }

    public ICProjectConverter getConverter() throws CoreException {
        if (this.fConverter == null) {
            this.fConverter = this.createConverter();
        }
        return this.fConverter;
    }

    private static IConfigurationElement getConverterElement(IExtension ext) {
        IConfigurationElement[] elements = ext.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (CONVERTER.equals(element.getName())) {
                return element;
            }
            ++i;
        }
        return null;
    }

    private IConfigurationElement getConverterElement() {
        if (this.fConverterElement == null) {
            this.fConverterElement = CProjectConverterDesciptor.getConverterElement(this.fExtension);
        }
        return this.fConverterElement;
    }

    private ICProjectConverter createConverter() throws CoreException {
        IConfigurationElement element = this.getConverterElement();
        if (element != null) {
            Object obj = element.createExecutableExtension(CLASS);
            if (obj instanceof ICProjectConverter) {
                return (ICProjectConverter)obj;
            }
            throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectConverterDesciptor.0"));
        }
        throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectConverterDesciptor.1"));
    }

    public String getId() {
        return this.fId;
    }

    public boolean canConvertProject(IProject project, String oldOwnerId, ICProjectDescription des) {
        if (this.getConverterElement() == null) {
            return false;
        }
        String[] ids = this.getSupportedOwnerIds();
        if (ids != null && !this.idsContain(ids, oldOwnerId)) {
            return false;
        }
        try {
            String[] supportedIds = this.getSupportedNatureIds();
            if (supportedIds != null) {
                IProjectDescription eDes = project.getDescription();
                String[] natures = eDes.getNatureIds();
                HashSet<String> natureSet = new HashSet<String>(Arrays.asList(natures));
                natureSet.removeAll(Arrays.asList(supportedIds));
                if (natureSet.size() == natures.length) {
                    return false;
                }
            }
        }
        catch (CoreException e1) {
            CCorePlugin.log(e1);
        }
        try {
            ICProjectConverter converter = this.getConverter();
            return converter.canConvertProject(project, oldOwnerId, des);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public String[] getSupportedOwnerIds() {
        return this.getIds(OWNERS);
    }

    public String[] getSupportedNatureIds() {
        return this.getIds(NATURES);
    }

    private String[] getIds(String attribute) {
        IConfigurationElement element = this.getConverterElement();
        if (element == null) {
            return null;
        }
        String value = element.getAttribute(attribute);
        return CDataUtil.stringToArray(value, DELIMITER);
    }

    private boolean idsContain(String[] ids, String id) {
        if (ids == null || ids.length == 0) {
            return id == null;
        }
        int i = 0;
        while (i < ids.length) {
            if (ids[i].equals(id)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

