/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.IRealBuildObjectAssociation;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceInfo;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChainModificationHelper;
import org.eclipse.cdt.managedbuilder.internal.core.ToolListModificationInfo;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ConflictSet;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.DbgTcmUtil;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.Messages;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PerTypeMapStorage;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.PerTypeSetStorage;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.TcModificationUtil;
import org.eclipse.cdt.managedbuilder.internal.tcmodification.ToolChainModificationManager;
import org.eclipse.cdt.managedbuilder.tcmodification.CompatibilityStatus;
import org.eclipse.cdt.managedbuilder.tcmodification.IModificationOperation;
import org.eclipse.cdt.managedbuilder.tcmodification.IToolListModification;
import org.eclipse.cdt.managedbuilder.tcmodification.IToolModification;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class ToolListModification
implements IToolListModification {
    private HashSet<String> fInputExtsSet = new HashSet();
    private ResourceInfo fRcInfo;
    private LinkedHashMap<Tool, IToolModification> fProjCompInfoMap = new LinkedHashMap();
    private HashMap<Tool, IToolModification> fSysCompInfoMap = new HashMap();
    private Tool[] fAllSysTools;
    private HashSet<ITool> fFilteredOutSysTools;
    private PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> fCompleteObjectStorage;
    protected TreeMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> fCompletePathMapStorage;
    private HashSet<Tool> fAddCapableTools;
    private Map<Tool, Tool> fFilteredOutTools;
    private ToolListModificationInfo fModificationInfo;

    protected Set<String> getInputExtsSet() {
        return this.fInputExtsSet;
    }

    private Set<Tool> getAddCompatibleSysTools() {
        if (this.fAddCapableTools == null) {
            this.fAddCapableTools = new HashSet<Tool>(Arrays.asList(this.getAllSysTools()));
            PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> storage = this.getCompleteObjectStore();
            ToolChainModificationManager.ConflictMatchSet conflicts = ToolChainModificationManager.getInstance().getConflictInfo(2, storage);
            this.fAddCapableTools.removeAll(conflicts.fObjToConflictListMap.keySet());
        }
        return this.fAddCapableTools;
    }

    public ToolListModification(ResourceInfo rcInfo, ITool[] tools) {
        this.fRcInfo = rcInfo;
        this.clearToolInfo(tools);
    }

    public ToolListModification(ResourceInfo rcInfo, ToolListModification base) {
        this.fRcInfo = rcInfo;
        ITool[] itools = rcInfo.getTools();
        IRealBuildObjectAssociation[] initialTools = (Tool[])Arrays.copyOf(itools, itools.length, Tool[].class);
        Map<? extends IRealBuildObjectAssociation, ? extends IRealBuildObjectAssociation> initRealToToolMap = TcModificationUtil.getRealToObjectsMap(initialTools, null);
        IRealBuildObjectAssociation[] updatedTools = base.getTools(true, false);
        Map<? extends IRealBuildObjectAssociation, ? extends IRealBuildObjectAssociation> updatedRealToToolMap = TcModificationUtil.getRealToObjectsMap(updatedTools, null);
        Set<Map.Entry<? extends IRealBuildObjectAssociation, ? extends IRealBuildObjectAssociation>> entrySet = updatedRealToToolMap.entrySet();
        for (Map.Entry<? extends IRealBuildObjectAssociation, ? extends IRealBuildObjectAssociation> entry : entrySet) {
            Tool real = (Tool)entry.getKey();
            Tool initial = (Tool)initRealToToolMap.get(real);
            if (initial != null) {
                entry.setValue(initial);
                continue;
            }
            Tool updated = (Tool)entry.getValue();
            if (updated.isExtensionBuildObject()) continue;
            updated = (Tool)updated.getExtensionObject();
            entry.setValue(updated);
        }
        updatedRealToToolMap.values().toArray(updatedTools);
        this.clearToolInfo((ITool[])updatedTools);
        if (base.fAllSysTools != null) {
            this.fAllSysTools = (Tool[])base.fAllSysTools.clone();
        }
        if (base.fFilteredOutSysTools != null) {
            HashSet clone;
            this.fFilteredOutSysTools = clone = (HashSet)base.fFilteredOutSysTools.clone();
        }
        if (base.fCompleteObjectStorage != null) {
            this.fCompleteObjectStorage = TcModificationUtil.cloneRealToolToPathSet(base.fCompleteObjectStorage);
        }
        if (base.fCompletePathMapStorage != null) {
            this.fCompletePathMapStorage = base.fCompletePathMapStorage;
        }
    }

    @Override
    public IResourceInfo getResourceInfo() {
        return this.fRcInfo;
    }

    protected abstract boolean canRemove(ITool var1);

    protected abstract boolean canReplace(Tool var1, Tool var2);

    protected abstract boolean canAdd(Tool var1);

    protected abstract Set<IPath> getToolApplicabilityPathSet(Tool var1, boolean var2);

    protected abstract Set<Tool> getExtensionConflictToolSet(Tool var1, Tool[] var2);

    protected abstract Tool[] filterTools(Tool[] var1);

    private Tool[] getAllSysTools() {
        if (this.fAllSysTools == null) {
            ITool[] allSys = ManagedBuildManager.getRealTools();
            this.fAllSysTools = this.filterTools((Tool[])allSys);
            HashSet<ITool> set = new HashSet<ITool>(Arrays.asList(allSys));
            set.removeAll(Arrays.asList(this.fAllSysTools));
            this.fFilteredOutSysTools = set;
        }
        return this.fAllSysTools;
    }

    @Override
    public final void apply() throws CoreException {
        TreeMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> initialMap = TcModificationUtil.createPathMap(this.fRcInfo.getParent());
        TreeMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> cur = this.getCompletePathMapStorage();
        TreeMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> result = TcModificationUtil.createResultingChangesMap(cur, initialMap);
        this.apply(result);
    }

    private void apply(TreeMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> resultingChangeMap) throws CoreException {
        int[] types = new int[]{1, 4, 2};
        IConfiguration cfg = this.fRcInfo.getParent();
        Set<Map.Entry<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>>> entrySet = resultingChangeMap.entrySet();
        for (Map.Entry<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> entry : entrySet) {
            IPath path = entry.getKey();
            ResourceInfo rcInfo = (ResourceInfo)cfg.getResourceInfo(path, true);
            if (rcInfo == null) {
                rcInfo = (FolderInfo)cfg.createFolderInfo(path);
            }
            PerTypeSetStorage<IRealBuildObjectAssociation> storage = entry.getValue();
            int i = 0;
            while (i < types.length) {
                int type = types[i];
                Set<IRealBuildObjectAssociation> set = storage.getSet(type, false);
                if (set != null) {
                    this.apply(rcInfo, type, set);
                }
                ++i;
            }
        }
    }

    private void apply(ResourceInfo rcInfo, int type, Set<? extends IRealBuildObjectAssociation> set) throws CoreException {
        switch (type) {
            case 2: {
                ToolListModificationInfo info = rcInfo == this.fRcInfo ? this.getModificationInfo() : ToolChainModificationHelper.getModificationInfo(rcInfo, rcInfo.getTools(), set.toArray(new Tool[set.size()]));
                info.apply();
                break;
            }
            case 1: {
                if (!rcInfo.isFolderInfo() || set.size() == 0) break;
                ToolChain tc = (ToolChain)set.iterator().next();
                try {
                    ((FolderInfo)rcInfo).changeToolChain(tc, CDataUtil.genId((String)tc.getId()), null);
                    break;
                }
                catch (BuildException e) {
                    throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e));
                }
            }
            case 4: {
                if (!rcInfo.isRoot() || set.size() == 0) break;
                Builder b = (Builder)set.iterator().next();
                rcInfo.getParent().changeBuilder(b, CDataUtil.genId((String)b.getId()), null);
            }
        }
    }

    private ToolListModificationInfo getModificationInfo() {
        if (this.fModificationInfo == null) {
            this.fModificationInfo = ToolChainModificationHelper.getModificationInfo(this.fRcInfo, this.fRcInfo.getTools(), this.getTools(true, false));
        }
        return this.fModificationInfo;
    }

    @Override
    public IToolModification[] getProjectToolModifications() {
        Map<Tool, IToolModification> map = this.getMap(true);
        return map.values().toArray(new ProjToolCompatibilityStatusInfo[map.size()]);
    }

    @Override
    public ITool[] getProjectTools() {
        return this.getTools(true, false);
    }

    @Override
    public IToolModification[] getSystemToolModifications() {
        Map<Tool, IToolModification> map = this.getMap(false);
        return map.values().toArray(new SysToolCompatibilityStatusInfo[map.size()]);
    }

    @Override
    public IToolModification getToolModification(ITool tool) {
        Tool rt = (Tool)ManagedBuildManager.getRealTool(tool);
        boolean isProj = this.isProjectTool(rt);
        Map<Tool, IToolModification> map = this.getMap(isProj);
        IToolModification m = map.get(rt);
        if (m == null) {
            ITool realTool = ManagedBuildManager.getRealTool(tool);
            boolean projFiltered = this.fFilteredOutTools.keySet().contains(realTool);
            m = new FilteredTool(tool, projFiltered);
        }
        return m;
    }

    private Map<Tool, IToolModification> getMap(boolean proj) {
        return proj ? this.fProjCompInfoMap : this.fSysCompInfoMap;
    }

    private Tool[] getTools(boolean proj, boolean real) {
        if (proj) {
            if (real) {
                return this.fProjCompInfoMap.keySet().toArray(new Tool[this.fProjCompInfoMap.size()]);
            }
            Tool[] tools = new Tool[this.fProjCompInfoMap.size()];
            int i = 0;
            Collection<IToolModification> infos = this.fProjCompInfoMap.values();
            for (IToolModification info : infos) {
                tools[i++] = ((ProjToolCompatibilityStatusInfo)info).fSelectedTool;
            }
            return tools;
        }
        return this.fSysCompInfoMap.keySet().toArray(new Tool[this.fSysCompInfoMap.size()]);
    }

    private boolean isProjectTool(Tool tool) {
        return this.fProjCompInfoMap.containsKey(tool.getRealBuildObject());
    }

    @Override
    public void changeProjectTools(ITool removeTool, ITool addTool) {
        boolean added;
        boolean removed;
        HashMap<ITool, ITool> map = this.createRealToToolMap();
        Tool realAdded = (Tool)ManagedBuildManager.getRealTool(addTool);
        Tool realRemoved = (Tool)ManagedBuildManager.getRealTool(removeTool);
        boolean bl = realRemoved != null ? map.remove(realRemoved) != null : (removed = false);
        boolean bl2 = realAdded != null ? map.put(realAdded, addTool) == null : (added = false);
        if (!added && !removed) {
            return;
        }
        Set<IPath> rmSet = null;
        Set<IPath> addSet = null;
        if (removed) {
            rmSet = this.getToolApplicabilityPathSet(realRemoved, true);
        }
        if (added) {
            addSet = rmSet == null ? this.getToolApplicabilityPathSet(realAdded, false) : rmSet;
        }
        ArrayList list = new ArrayList();
        list.addAll(map.values());
        this.clearToolInfo(map.values().toArray(new Tool[map.size()]));
        PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> storage = this.getCompleteObjectStore();
        Map<IRealBuildObjectAssociation, Set<IPath>> toolMap = storage.getMap(2, true);
        if (rmSet != null) {
            TcModificationUtil.removePaths(toolMap, realRemoved, rmSet);
        }
        if (addSet != null) {
            TcModificationUtil.addPaths(toolMap, realAdded, addSet);
        }
    }

    private HashMap<ITool, ITool> createRealToToolMap() {
        HashMap<ITool, ITool> map = new HashMap<ITool, ITool>();
        Set<Map.Entry<Tool, IToolModification>> entries = this.fProjCompInfoMap.entrySet();
        for (Map.Entry<Tool, IToolModification> entry : entries) {
            map.put(entry.getKey(), entry.getValue().getTool());
        }
        return map;
    }

    protected void clearToolCompatibilityInfo() {
        for (IToolModification info : this.fProjCompInfoMap.values()) {
            ((ProjToolCompatibilityStatusInfo)info).clearCompatibilityInfo();
        }
        for (IToolModification info : this.fSysCompInfoMap.values()) {
            ((SysToolCompatibilityStatusInfo)info).clearCompatibilityInfo();
        }
    }

    protected void clearToolInfo(ITool[] tools) {
        IRealBuildObjectAssociation[] allTools;
        if (tools instanceof Tool[]) {
            allTools = (Tool[])tools;
        } else {
            allTools = new Tool[tools.length];
            System.arraycopy(tools, 0, allTools, 0, tools.length);
        }
        IRealBuildObjectAssociation[] filteredTools = this.filterTools((Tool[])allTools);
        Map<? extends IRealBuildObjectAssociation, ? extends IRealBuildObjectAssociation> filteredMap = TcModificationUtil.getRealToObjectsMap(filteredTools, null);
        Map<? extends IRealBuildObjectAssociation, ? extends IRealBuildObjectAssociation> allMap = TcModificationUtil.getRealToObjectsMap(allTools, null);
        allMap.keySet().removeAll(filteredMap.keySet());
        this.fFilteredOutTools = allMap;
        this.fModificationInfo = null;
        this.fInputExtsSet.clear();
        this.fProjCompInfoMap.clear();
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            Tool realTool = (Tool)ManagedBuildManager.getRealTool(tool);
            this.fProjCompInfoMap.put(realTool, new ProjToolCompatibilityStatusInfo((Tool)tool));
            if (!this.fFilteredOutTools.containsKey(realTool)) {
                this.fInputExtsSet.addAll(Arrays.asList(tool.getPrimaryInputExtensions()));
            }
            ++i;
        }
        this.fSysCompInfoMap.clear();
        Tool[] sysTools = this.getAllSysTools();
        int i2 = 0;
        while (i2 < sysTools.length) {
            Tool sysTool = sysTools[i2];
            if (!this.fProjCompInfoMap.containsKey(sysTool)) {
                this.fSysCompInfoMap.put(sysTool, new SysToolCompatibilityStatusInfo(sysTool));
            }
            ++i2;
        }
        this.fAddCapableTools = null;
        this.fCompletePathMapStorage = null;
    }

    protected PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> getCompleteObjectStore() {
        if (this.fCompleteObjectStorage == null) {
            this.fCompleteObjectStorage = TcModificationUtil.createRealToolToPathSet(this.fRcInfo.getParent(), null, false);
            if (DbgTcmUtil.DEBUG) {
                DbgTcmUtil.println("dumping complete storage");
                DbgTcmUtil.dumpStorage(this.fCompleteObjectStorage);
            }
        }
        return this.fCompleteObjectStorage;
    }

    protected TreeMap<IPath, PerTypeSetStorage<IRealBuildObjectAssociation>> getCompletePathMapStorage() {
        if (this.fCompletePathMapStorage == null) {
            this.fCompletePathMapStorage = TcModificationUtil.createPathMap(this.getCompleteObjectStore());
        }
        return this.fCompletePathMapStorage;
    }

    private class FilteredTool
    implements IToolModification {
        private ITool fTool;
        private boolean fIsProject;

        public FilteredTool(ITool tool, boolean isProject) {
            this.fTool = tool;
            this.fIsProject = isProject;
        }

        @Override
        public CompatibilityStatus getCompatibilityStatus() {
            return this.fIsProject ? CompatibilityStatus.OK_COMPATIBILITY_STATUS : new CompatibilityStatus(4, Messages.getString("ToolListModification.ToolIsIncompatible"), null);
        }

        @Override
        public IModificationOperation[] getSupportedOperations() {
            return new IModificationOperation[0];
        }

        @Override
        public ITool getTool() {
            return this.fTool;
        }

        @Override
        public boolean isCompatible() {
            return this.fIsProject;
        }

        @Override
        public boolean isProjectTool() {
            return this.fIsProject;
        }

        @Override
        public IResourceInfo getResourceInfo() {
            return ToolListModification.this.getResourceInfo();
        }
    }

    private class ModificationOperation
    implements IModificationOperation {
        private ITool fReplacement;
        private IToolModification fModification;

        ModificationOperation(IToolModification modification, ITool tool) {
            this.fModification = modification;
            this.fReplacement = tool;
        }

        @Override
        public ITool getReplacementTool() {
            return this.fReplacement;
        }

        @Override
        public IToolModification getToolModification() {
            return this.fModification;
        }
    }

    public class ProjToolCompatibilityStatusInfo
    implements IToolModification {
        private ToolCompatibilityInfoElement fCurrentElement;
        private Map<Tool, ToolCompatibilityInfoElement> fCompatibleTools;
        private Map<Tool, ToolCompatibilityInfoElement> fInCompatibleTools;
        private IModificationOperation[] fOperations;
        private Tool fSelectedTool;
        private Tool fRealTool;
        private boolean fInited;
        private Set<Tool> fExtConflictTools;

        ProjToolCompatibilityStatusInfo(Tool tool) {
            this.fSelectedTool = tool;
            this.fRealTool = (Tool)ManagedBuildManager.getRealTool(tool);
        }

        private ToolCompatibilityInfoElement getCurrentElement() {
            this.checkInitCompatibleTools();
            return this.fCurrentElement;
        }

        @Override
        public CompatibilityStatus getCompatibilityStatus() {
            return this.getCurrentElement().getCompatibilityStatus();
        }

        @Override
        public boolean isCompatible() {
            return this.getCurrentElement().isCompatible();
        }

        @Override
        public boolean isProjectTool() {
            return true;
        }

        public Map<Tool, ToolCompatibilityInfoElement> getCompatibleTools() {
            this.checkInitCompatibleTools();
            return this.fCompatibleTools;
        }

        private void checkInitCompatibleTools() {
            if (this.fInited) {
                return;
            }
            if (DbgTcmUtil.DEBUG) {
                DbgTcmUtil.println("calculating compatibility for tool " + this.fRealTool.getUniqueRealName());
            }
            PerTypeMapStorage<IRealBuildObjectAssociation, Set<IPath>> storage = ToolListModification.this.getCompleteObjectStore();
            Tool tool = this.fRealTool;
            Set<IPath> rmSet = ToolListModification.this.getToolApplicabilityPathSet(tool, true);
            Map<IRealBuildObjectAssociation, Set<IPath>> toolMap = storage.getMap(2, false);
            try {
                if (rmSet != null && rmSet.size() != 0) {
                    TcModificationUtil.removePaths(toolMap, tool, rmSet);
                }
                if (DbgTcmUtil.DEBUG) {
                    DbgTcmUtil.dumpStorage(storage);
                }
                ToolChainModificationManager.ConflictMatchSet conflicts = ToolChainModificationManager.getInstance().getConflictInfo(2, storage);
                this.fCompatibleTools = new HashMap<Tool, ToolCompatibilityInfoElement>();
                this.fInCompatibleTools = new HashMap<Tool, ToolCompatibilityInfoElement>();
                Tool[] sysTools = ToolListModification.this.getTools(false, true);
                Map<? extends IRealBuildObjectAssociation, List<ToolChainModificationManager.ConflictMatch>> conflictMap = conflicts.fObjToConflictListMap;
                int i = 0;
                while (i < sysTools.length) {
                    Tool t = sysTools[i];
                    List<ToolChainModificationManager.ConflictMatch> l = conflictMap.get(t);
                    ToolCompatibilityInfoElement el = new ToolCompatibilityInfoElement(this, t, l);
                    if (el.isCompatible()) {
                        this.fCompatibleTools.put(t, el);
                    } else {
                        this.fInCompatibleTools.put(t, el);
                    }
                    ++i;
                }
                Tool t = this.fRealTool;
                List<ToolChainModificationManager.ConflictMatch> l = conflictMap.get(t);
                this.fCurrentElement = new ToolCompatibilityInfoElement(this, t, l);
            }
            finally {
                if (rmSet != null && rmSet.size() != 0) {
                    TcModificationUtil.addPaths(toolMap, tool, rmSet);
                }
            }
            this.fInited = true;
        }

        private Set<Tool> getConflictingTools() {
            if (this.fExtConflictTools == null) {
                Tool[] tmp = new Tool[]{this.fSelectedTool};
                this.fExtConflictTools = (tmp = ToolListModification.this.filterTools(tmp)).length == 0 ? Collections.emptySet() : ToolListModification.this.getExtensionConflictToolSet(this.fSelectedTool, ToolListModification.this.filterTools(ToolListModification.this.getTools(true, false)));
            }
            return this.fExtConflictTools;
        }

        @Override
        public IModificationOperation[] getSupportedOperations() {
            if (this.fOperations == null) {
                this.checkInitCompatibleTools();
                if (ToolListModification.this.fFilteredOutTools.containsKey(this.fRealTool)) {
                    this.fOperations = ToolListModification.this.canRemove(this.fRealTool) ? new ModificationOperation[]{new ModificationOperation(this, null)} : new ModificationOperation[0];
                } else {
                    ArrayList<ModificationOperation> opList = new ArrayList<ModificationOperation>(this.fCompatibleTools.size() + 1);
                    Set<Tool> keySet = this.fCompatibleTools.keySet();
                    for (Tool tool : keySet) {
                        if (tool == this.fRealTool || !ToolListModification.this.canReplace(this.fRealTool, tool)) continue;
                        opList.add(new ModificationOperation(this, tool));
                    }
                    if (this.fCompatibleTools.size() == 0 || ToolListModification.this.canRemove(this.fRealTool)) {
                        opList.add(new ModificationOperation(this, null));
                    }
                    this.fOperations = opList.toArray(new ModificationOperation[opList.size()]);
                }
            }
            return (IModificationOperation[])this.fOperations.clone();
        }

        @Override
        public ITool getTool() {
            return this.fSelectedTool;
        }

        public ITool getRealTool() {
            return this.fRealTool;
        }

        @Override
        public IResourceInfo getResourceInfo() {
            return ToolListModification.this.fRcInfo;
        }

        public void clearCompatibilityInfo() {
            this.fInited = false;
            this.fCompatibleTools = null;
            this.fInCompatibleTools = null;
            this.fOperations = null;
            this.fCurrentElement = null;
            this.fExtConflictTools = null;
        }
    }

    public class SysToolCompatibilityStatusInfo
    implements IToolModification {
        private IModificationOperation[] fOperations;
        private Tool fSelectedTool;
        private Tool fRealTool;
        private CompatibilityStatus fStatus;

        SysToolCompatibilityStatusInfo(Tool tool) {
            this.fSelectedTool = tool;
            this.fRealTool = (Tool)ManagedBuildManager.getRealTool(tool);
        }

        @Override
        public CompatibilityStatus getCompatibilityStatus() {
            if (this.fStatus == null) {
                String message;
                int severity;
                if (!this.isCompatible()) {
                    severity = 4;
                    message = Messages.getString("ToolListModification.ToolIsIncompatible");
                } else {
                    severity = 0;
                    message = "";
                }
                this.fStatus = new CompatibilityStatus(severity, message, null);
            }
            return this.fStatus;
        }

        @Override
        public boolean isCompatible() {
            return this.getSupportedOperationsArray().length > 0;
        }

        @Override
        public boolean isProjectTool() {
            return false;
        }

        public IModificationOperation[] getSupportedOperationsArray() {
            if (this.fOperations == null) {
                Set<Tool> addCompatibleSysToolsSet = ToolListModification.this.getAddCompatibleSysTools();
                if (addCompatibleSysToolsSet.contains(this.fRealTool) && ToolListModification.this.canAdd(this.fRealTool)) {
                    this.fOperations = new ModificationOperation[]{new ModificationOperation(this, null)};
                } else {
                    Map<Tool, IToolModification> projMap = ToolListModification.this.getMap(true);
                    ArrayList<ModificationOperation> opList = new ArrayList<ModificationOperation>(projMap.size());
                    for (IToolModification tm : projMap.values()) {
                        ProjToolCompatibilityStatusInfo info = (ProjToolCompatibilityStatusInfo)tm;
                        if (!info.getCompatibleTools().containsKey(this.fRealTool) || ToolListModification.this.fFilteredOutTools.containsKey(info.fRealTool) || !ToolListModification.this.canReplace(info.fSelectedTool, this.fSelectedTool)) continue;
                        opList.add(new ModificationOperation(this, info.fSelectedTool));
                    }
                    this.fOperations = opList.toArray(new ModificationOperation[opList.size()]);
                }
            }
            return this.fOperations;
        }

        @Override
        public IModificationOperation[] getSupportedOperations() {
            return (IModificationOperation[])this.getSupportedOperationsArray().clone();
        }

        @Override
        public ITool getTool() {
            return this.fSelectedTool;
        }

        public ITool getRealTool() {
            return this.fRealTool;
        }

        @Override
        public IResourceInfo getResourceInfo() {
            return ToolListModification.this.fRcInfo;
        }

        public void clearCompatibilityInfo() {
            this.fOperations = null;
            this.fStatus = null;
        }
    }

    public class ToolCompatibilityInfoElement {
        private Tool fRealTool;
        private List<ToolChainModificationManager.ConflictMatch> fErrComflictMatchList;
        private CompatibilityStatus fStatus;
        private ProjToolCompatibilityStatusInfo fStatusInfo;

        ToolCompatibilityInfoElement(ProjToolCompatibilityStatusInfo statusInfo, Tool realTool, List<ToolChainModificationManager.ConflictMatch> errConflictList) {
            this.fStatusInfo = statusInfo;
            this.fRealTool = realTool;
            if (errConflictList != null && errConflictList.size() != 0) {
                this.fErrComflictMatchList = errConflictList;
            }
        }

        public CompatibilityStatus getCompatibilityStatus() {
            if (this.fStatus == null) {
                ConflictSet conflicts;
                String message;
                int severity;
                if (!this.isCompatible()) {
                    severity = 4;
                    message = Messages.getString("ToolListModification.ToolIsIncompatible");
                    conflicts = new ConflictSet(this.fRealTool, this.fErrComflictMatchList, this.fStatusInfo.getConflictingTools());
                } else {
                    severity = 0;
                    message = "";
                    conflicts = null;
                }
                this.fStatus = new CompatibilityStatus(severity, message, conflicts);
            }
            return this.fStatus;
        }

        public boolean isCompatible() {
            return this.noCompatibilityConflicts() && (this.fRealTool != this.fStatusInfo.getRealTool() || this.fStatusInfo.getConflictingTools().size() == 0);
        }

        public boolean noCompatibilityConflicts() {
            return this.fErrComflictMatchList == null;
        }
    }
}

