/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.full.KCallables;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.reflect.jvm.KTypesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlinx.coroutines.BuildersKt;
import org.jspecify.annotations.Nullable;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

class KotlinSuspendingFunctionUtils {
    static Class<?> getReturnType(Method method) {
        Class returnType = JvmClassMappingKt.getJavaClass((KClass)KTypesJvm.getJvmErasure((KType)KotlinSuspendingFunctionUtils.getKotlinFunction(method).getReturnType()));
        if (Unit.class.equals((Object)returnType)) {
            return Void.TYPE;
        }
        return returnType;
    }

    static Type getGenericReturnType(Method method) {
        return ReflectJvmMapping.getJavaType((KType)KotlinSuspendingFunctionUtils.getKotlinFunction(method).getReturnType());
    }

    static Parameter[] getParameters(Method method) {
        int parameterCount = method.getParameterCount();
        if (parameterCount == 1) {
            return new Parameter[0];
        }
        return Arrays.copyOf(method.getParameters(), parameterCount - 1);
    }

    static Class<?>[] getParameterTypes(Method method) {
        int parameterCount = method.getParameterCount();
        if (parameterCount == 1) {
            return ReflectionUtils.EMPTY_CLASS_ARRAY;
        }
        return (Class[])Arrays.stream(method.getParameterTypes()).limit(parameterCount - 1).toArray(Class[]::new);
    }

    static @Nullable Object invoke(Method method, @Nullable Object target, @Nullable Object[] args) {
        try {
            return KotlinSuspendingFunctionUtils.invoke(KotlinSuspendingFunctionUtils.getKotlinFunction(method), target, args);
        }
        catch (InterruptedException e) {
            throw ExceptionUtils.throwAsUncheckedException(e);
        }
    }

    private static <T> @Nullable T invoke(KFunction<T> function, @Nullable Object target, @Nullable Object[] args) throws InterruptedException {
        if (!KCallablesJvm.isAccessible(function)) {
            KCallablesJvm.setAccessible(function, (boolean)true);
        }
        return (T)BuildersKt.runBlocking((CoroutineContext)EmptyCoroutineContext.INSTANCE, (__, continuation) -> {
            try {
                return KCallables.callSuspendBy((KCallable)function, KotlinSuspendingFunctionUtils.toArgumentMap(target, args, function), (Continuation)continuation);
            }
            catch (Exception e) {
                throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(e));
            }
        });
    }

    private static Map<KParameter, @Nullable Object> toArgumentMap(@Nullable Object target, @Nullable Object[] args, KFunction<?> function) {
        HashMap<KParameter, @Nullable Object> arguments = new HashMap<KParameter, Object>(args.length + 1);
        int index = 0;
        block4: for (KParameter parameter : function.getParameters()) {
            switch (parameter.getKind()) {
                case INSTANCE: {
                    arguments.put(parameter, target);
                    continue block4;
                }
                case VALUE: 
                case EXTENSION_RECEIVER: {
                    arguments.put(parameter, args[index]);
                    ++index;
                    continue block4;
                }
            }
            throw new JUnitException("Unsupported parameter kind: " + String.valueOf(parameter.getKind()));
        }
        return arguments;
    }

    private static KFunction<?> getKotlinFunction(Method method) {
        return Preconditions.notNull(ReflectJvmMapping.getKotlinFunction((Method)method), () -> "Failed to get Kotlin function for method: " + String.valueOf(method));
    }

    private KotlinSuspendingFunctionUtils() {
    }
}

