/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.properties;

import java.util.ArrayList;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.properties.MessagePropertyDescriptor;
import org.eclipse.egit.ui.internal.properties.PersonIdentPropertySource;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class CommitPropertySource
implements IPropertySource {
    private static final String PROPERTY_COMMIT_MESSAGE = "commit_message";
    private static final String PROPERTY_COMMIT_ID = "commit_id";
    private static final String PROPERTY_COMMIT_AUTHOR = "commit_author";
    private static final String PROPERTY_COMMITTER = "committer";
    private RevCommit commit;
    private final IPropertyDescriptor[] descriptors;

    public CommitPropertySource(RevCommit commit, PropertySheetPage page) {
        this.commit = commit;
        ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>();
        result.add(new PropertyDescriptor((Object)PROPERTY_COMMIT_ID, UIText.CommitPropertySource_CommitId));
        result.add(new MessagePropertyDescriptor(PROPERTY_COMMIT_MESSAGE, UIText.CommitPropertySource_CommitMessage, commit.getFullMessage(), page));
        result.add(new PropertyDescriptor((Object)PROPERTY_COMMIT_AUTHOR, UIText.CommitPropertySource_CommitAuthor));
        result.add(new PropertyDescriptor((Object)PROPERTY_COMMITTER, UIText.CommitPropertySource_Committer));
        for (PropertyDescriptor p : result) {
            p.setCategory(UIText.CommitPropertySource_CommitCategory);
        }
        this.descriptors = result.toArray(new IPropertyDescriptor[0]);
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors;
    }

    public Object getPropertyValue(Object id) {
        switch (id.toString()) {
            case "commit_id": {
                return this.commit.getName();
            }
            case "commit_message": {
                return this.commit.getShortMessage();
            }
            case "commit_author": {
                return new PersonIdentPropertySource(this.commit.getAuthorIdent());
            }
            case "committer": {
                return new PersonIdentPropertySource(this.commit.getCommitterIdent());
            }
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public String toString() {
        return "commit " + this.commit.name();
    }
}

