/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import org.eclipse.core.resources.IMarker;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.BundleSymbolicNameHeader;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;

public class UpdateSingletonToSymbolicName
extends AbstractManifestMarkerResolution {
    private final boolean fisDirective;

    public UpdateSingletonToSymbolicName(int type, boolean directive, IMarker marker) {
        super(type, marker);
        this.fisDirective = directive;
    }

    public String getLabel() {
        String userDirective = this.marker.getAttribute("userDirective", null);
        return NLS.bind((String)PDEUIMessages.UpdateSingleton_dir_label, (Object)userDirective);
    }

    @Override
    protected void createChange(BundleModel model) {
        Bundle bun;
        IManifestHeader header;
        IBundle bundle = model.getBundle();
        if (bundle instanceof Bundle && (header = (bun = (Bundle)bundle).getManifestHeader("Bundle-SymbolicName")) instanceof BundleSymbolicNameHeader) {
            if (this.fisDirective && TargetPlatformHelper.getTargetVersion() >= 3.1) {
                bundle.setHeader("Bundle-ManifestVersion", "2");
            } else if (!this.fisDirective && TargetPlatformHelper.getTargetVersion() < 3.1) {
                bundle.setHeader("Bundle-ManifestVersion", null);
            }
            String entry = ((BundleSymbolicNameHeader)header).getValue();
            int ind1 = entry.indexOf(59);
            int ind2 = entry.indexOf(58);
            String invalidDir = entry.substring(ind1 + 1, ind2);
            ((BundleSymbolicNameHeader)header).setDirective(invalidDir, null);
            ((BundleSymbolicNameHeader)header).setDirective("singleton", String.valueOf(true));
        }
    }
}

