import { Logger, TemplateContext, TemplateLanguageService } from 'typescript-template-language-service-decorator';
import * as ts from 'typescript/lib/tsserverlibrary';
import { StyledPluginConfiguration } from './_configuration';
import { VirtualDocumentProvider } from './_virtual-document-provider';
export declare class StyledTemplateLanguageService implements TemplateLanguageService {
    private readonly typescript;
    private readonly configuration;
    private readonly virtualDocumentFactory;
    private readonly logger;
    private _cssLanguageService?;
    private _scssLanguageService?;
    private _completionsCache;
    constructor(typescript: typeof ts, configuration: StyledPluginConfiguration, virtualDocumentFactory: VirtualDocumentProvider, logger: Logger);
    private readonly cssLanguageService;
    private readonly scssLanguageService;
    getCompletionsAtPosition(context: TemplateContext, position: ts.LineAndCharacter): ts.CompletionInfo;
    getCompletionEntryDetails?(context: TemplateContext, position: ts.LineAndCharacter, name: string): ts.CompletionEntryDetails;
    getQuickInfoAtPosition(context: TemplateContext, position: ts.LineAndCharacter): ts.QuickInfo | undefined;
    getSemanticDiagnostics(context: TemplateContext): ts.Diagnostic[];
    getSupportedCodeFixes(): number[];
    getCodeFixesAtPosition(context: TemplateContext, start: number, end: number, _errorCodes: number[], _format: ts.FormatCodeSettings): ts.CodeAction[];
    getOutliningSpans(context: TemplateContext): ts.OutliningSpan[];
    private toVsRange;
    private getCompletionItems;
    private translateDiagnostics;
    private translateDiagnostic;
    private translateHover;
    private translateCodeActions;
    private translateTextEditToFileTextChange;
    private translateOutliningSpan;
}
