/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.providers;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.mylyn.commons.core.DateUtil;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.CommonImageManger;
import org.eclipse.mylyn.internal.reviews.ui.Messages;
import org.eclipse.mylyn.internal.reviews.ui.ReviewsImages;
import org.eclipse.mylyn.internal.reviews.ui.providers.GlobalCommentsNode;
import org.eclipse.mylyn.internal.reviews.ui.providers.RetrievingContentsNode;
import org.eclipse.mylyn.internal.reviews.ui.providers.TableStyledLabelProvider;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.ICommentContainer;
import org.eclipse.mylyn.reviews.core.model.IDated;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IFileVersion;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.ILocation;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.core.model.IUser;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public abstract class ReviewsLabelProvider
extends TableStyledLabelProvider {
    private static final int TOOLTIP_CHAR_WIDTH = 100;
    static final int LINE_NUMBER_WIDTH = 4;
    static final int MAXIMUM_COMMENT_LENGTH = 300;
    static final SimpleDateFormat COMMENT_DATE_FORMAT = new SimpleDateFormat("yyyy.MM.dd HH:mm a");
    static final SimpleDateFormat EXTENDED_DATE_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
    public static final StyledString.Styler AUTHOR_STYLE = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.font = JFaceResources.getTextFont();
            textStyle.foreground = Display.getCurrent().getSystemColor(2);
        }
    };
    public static final StyledString.Styler COMMENT_STYLE = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.font = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
        }
    };
    public static final StyledString.Styler COMMENT_DATE_STYLE = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.font = JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont");
            ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
            textStyle.foreground = colorRegistry.get("DECORATIONS_COLOR");
        }
    };
    public static final StyledString.Styler LINE_NUMBER_STYLE = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
            textStyle.foreground = colorRegistry.get("COUNTER_COLOR");
            textStyle.font = JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont");
        }
    };
    public static final TableStyledLabelProvider.TableColumnProvider ITEMS_COLUMN = new TableStyledLabelProvider.TableColumnProvider(Messages.ReviewsLabelProvider_Item, 80, 800, true){
        CommonImageManger imageManager = new CommonImageManger();

        public Image getImage(Object element) {
            if (element instanceof IReview) {
                return this.imageManager.getFileImage("review");
            }
            if (element instanceof IReviewItemSet) {
                return CommonImages.getImage((ImageDescriptor)ReviewsImages.CHANGE_LOG);
            }
            if (element instanceof IReviewItem) {
                IReviewItem item = (IReviewItem)element;
                Image image = this.imageManager.getFileImage(item.getName());
                if (element instanceof IFileItem) {
                    IFileItem fileItem = (IFileItem)element;
                    ImageDescriptor baseImage = ImageDescriptor.createFromImage((Image)image);
                    IFileVersion base = fileItem.getBase();
                    IFileVersion target = fileItem.getTarget();
                    if (base != null && target != null) {
                        if (base.getPath() == null && target.getPath() != null) {
                            ImageDescriptor overlay = ReviewsImages.OVERLAY_ADDED;
                            image = CommonImages.getImageWithOverlay((ImageDescriptor)baseImage, (ImageDescriptor)overlay, (boolean)false, (boolean)false);
                        } else if (base.getPath() != null && target.getPath() == null) {
                            ImageDescriptor overlay = ReviewsImages.OVERLAY_REMOVED;
                            image = CommonImages.getImageWithOverlay((ImageDescriptor)baseImage, (ImageDescriptor)overlay, (boolean)false, (boolean)false);
                        } else if (base.getPath() != null && target.getPath() != null && !base.getPath().equals(target.getPath())) {
                            ImageDescriptor overlay = ReviewsImages.OVERLAY_RENAMED;
                            image = CommonImages.getImageWithOverlay((ImageDescriptor)baseImage, (ImageDescriptor)overlay, (boolean)false, (boolean)false);
                        }
                    }
                }
                return image;
            }
            if (element instanceof IComment) {
                IComment comment = (IComment)element;
                if (comment.isMine()) {
                    return CommonImages.getImage((ImageDescriptor)CommonImages.PERSON_ME);
                }
                return CommonImages.getImage((ImageDescriptor)CommonImages.PERSON);
            }
            if (element instanceof GlobalCommentsNode) {
                return CommonImages.getImage((ImageDescriptor)TasksUiImages.TASK);
            }
            if (element instanceof ILocation) {
                return CommonImages.getImage((ImageDescriptor)ReviewsImages.REVIEW_QUOTE);
            }
            return null;
        }

        public String getText(Object element) {
            Collection collection;
            if (element instanceof GlobalCommentsNode) {
                return Messages.Reviews_GeneralCommentsText;
            }
            if (element instanceof RetrievingContentsNode) {
                return org.eclipse.mylyn.reviews.ui.spi.editor.Messages.Reviews_RetrievingContents;
            }
            if (element instanceof Collection && (collection = (Collection)element).size() == 1) {
                return this.getText(collection.iterator().next());
            }
            if (element instanceof IReview) {
                IReview review = (IReview)element;
                return NLS.bind((String)Messages.ReviewsLabelProvider_Change_X, (Object)review.getId());
            }
            if (element instanceof IFileVersion) {
                IFileVersion version = (IFileVersion)element;
                Object text = this.getText(version.getFile());
                text = (String)text + version.getName();
                return text;
            }
            if (element instanceof IFileItem) {
                return StringUtils.substringAfterLast((String)((IFileItem)element).getName(), (String)"/");
            }
            if (element instanceof IReviewItem) {
                return ((IReviewItem)element).getName();
            }
            if (element instanceof IComment) {
                IComment comment = (IComment)element;
                String desc = comment.getDescription();
                return desc;
            }
            if (element instanceof IUser) {
                String displayName = ((IUser)element).getDisplayName();
                if (!StringUtils.isEmpty((CharSequence)displayName)) {
                    return displayName;
                }
                return Messages.ReviewsLabelProvider_Unknown;
            }
            if (element instanceof Date) {
                return NLS.bind((String)Messages.ReviewsLabelProvider_X_ago, (Object)DateUtil.getRelativeDuration((long)(System.currentTimeMillis() - ((Date)element).getTime())));
            }
            if (element instanceof ILineLocation) {
                int min = ((ILineLocation)element).getRangeMin();
                int max = ((ILineLocation)element).getRangeMax();
                Object text = Integer.toString(min);
                if (min != max) {
                    text = (String)text + "-" + max;
                }
                return text;
            }
            return super.getText(element);
        }

        @Override
        public StyledString getStyledText(Object element) {
            StyledString.Styler styler = null;
            if (element instanceof IComment || element instanceof RetrievingContentsNode) {
                styler = COMMENT_STYLE;
            }
            StyledString styledString = new StyledString(this.getText(element), styler);
            if (element instanceof GlobalCommentsNode) {
                element = ((GlobalCommentsNode)element).getReview();
            }
            ReviewsLabelProvider.addCommentContainerStatsStyle(element, styledString);
            ReviewsLabelProvider.addCommentLineNumberStyle(element, styledString);
            ReviewsLabelProvider.addFilePathStyle(element, styledString);
            return styledString;
        }

        @Override
        public String getToolTipText(Object element) {
            if (element instanceof IComment) {
                IComment comment = (IComment)element;
                String desc = comment.getDescription();
                desc = StringUtils.replace((String)desc, (String)"\r\n", (String)"\n");
                String[] lines = desc.split("\n");
                ArrayList<String> seperated = new ArrayList<String>();
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    Object newLine = "";
                    String[] splitByWholeSeparator = StringUtils.splitByWholeSeparator((String)line, (String)" ");
                    int count = 0;
                    String[] stringArray2 = splitByWholeSeparator;
                    int n3 = splitByWholeSeparator.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String word = stringArray2[n4];
                        if ((count += word.length()) > 100) {
                            seperated.add((String)newLine);
                            newLine = word;
                            count = word.length();
                        } else {
                            if (count > word.length()) {
                                newLine = (String)newLine + " ";
                            }
                            newLine = (String)newLine + word;
                        }
                        ++n4;
                    }
                    seperated.add((String)newLine);
                    ++n2;
                }
                return StringUtils.join(seperated, (String)"\n");
            }
            if (element instanceof IFileItem) {
                IFileItem fileItem = (IFileItem)element;
                IFileVersion base = fileItem.getBase();
                IFileVersion target = fileItem.getTarget();
                if (target != null) {
                    if (target.getPath() != null && base.getPath() == null) {
                        return NLS.bind((String)Messages.ReviewsLabelProvider_X_Revision_Y, (Object)target.getPath(), (Object)target.getDescription());
                    }
                    if (target.getPath() == null && base.getPath() != null) {
                        return NLS.bind((String)Messages.ReviewsLabelProvider_X_Revision_Y, (Object)base.getPath(), (Object)target.getDescription());
                    }
                    if (target.getPath() != null && !target.getPath().equals(base.getPath())) {
                        return NLS.bind((String)Messages.ReviewsLabelProvider_X_renamed_from_Y_Z, (Object[])new String[]{target.getPath(), base.getPath(), target.getDescription()});
                    }
                    return NLS.bind((String)Messages.ReviewsLabelProvider_X_Revision_Y, (Object)(target.getPath() == null ? target.getName() : target.getPath()), (Object)target.getDescription());
                }
            }
            if (element instanceof IUser) {
                IUser user = (IUser)element;
                Object text = user.getDisplayName();
                if (!StringUtils.isEmpty((CharSequence)user.getEmail())) {
                    text = (String)text + NLS.bind((String)Messages.ReviewsLabelProvider_Bracket_X_bracket, (Object)user.getEmail());
                }
                return text;
            }
            if (element instanceof Date) {
                return EXTENDED_DATE_FORMAT.format((Date)element);
            }
            return null;
        }

        @Override
        public boolean isStyled() {
            return true;
        }
    };
    public static final TableStyledLabelProvider.TableColumnProvider ARTIFACT_COLUMN = new TableStyledLabelProvider.AdaptingTableColumnProvider(ITEMS_COLUMN, Messages.ReviewsLabelProvider_Artifact, 50, 400, false){

        @Override
        public Object adapt(Object element) {
            if (element instanceof IFileItem) {
                return element;
            }
            if (element instanceof IFileVersion) {
                return ((IFileVersion)element).getFile();
            }
            if (element instanceof IComment) {
                IComment comment = (IComment)element;
                return this.adapt(comment.getItem());
            }
            if (element instanceof IReview) {
                return new GlobalCommentsNode((IReview)element);
            }
            return null;
        }

        @Override
        public StyledString getStyledText(Object element) {
            StyledString styledString = new StyledString(this.getText(element));
            ReviewsLabelProvider.addCommentLineNumberStyle(element, styledString);
            ReviewsLabelProvider.addFilePathStyle(this.adapt(element), styledString);
            return styledString;
        }

        @Override
        public boolean isStyled() {
            return true;
        }
    };
    public static final TableStyledLabelProvider.TableColumnProvider COMMENTS_COLUMN = new TableStyledLabelProvider.AdaptingTableColumnProvider(ITEMS_COLUMN, Messages.ReviewsLabelProvider_Comment, 50, 400, true){

        @Override
        public Object adapt(Object element) {
            if (element instanceof IComment) {
                return element;
            }
            return null;
        }

        @Override
        public StyledString getStyledText(Object element) {
            return new StyledString(this.getText(element), COMMENT_STYLE);
        }

        @Override
        public boolean isStyled() {
            return true;
        }
    };
    public static final TableStyledLabelProvider.TableColumnProvider AUTHORS_COLUMN = new TableStyledLabelProvider.AdaptingTableColumnProvider(ITEMS_COLUMN, Messages.ReviewsLabelProvider_Author, 10, 120, false){

        @Override
        public Object adapt(Object element) {
            if (element instanceof IComment) {
                IComment comment = (IComment)element;
                return comment.getAuthor();
            }
            if (element instanceof IReviewItem) {
                IReviewItem item = (IReviewItem)element;
                return item.getAddedBy();
            }
            if (element instanceof IReview) {
                IReview item = (IReview)element;
                return item.getOwner();
            }
            return null;
        }
    };
    public static final TableStyledLabelProvider.TableColumnProvider DATE_COLUMN = new TableStyledLabelProvider.AdaptingTableColumnProvider(ITEMS_COLUMN, Messages.ReviewsLabelProvider_Last_Change, 10, 120, false){

        @Override
        public Object adapt(Object element) {
            if (element instanceof IDated) {
                IDated item = (IDated)element;
                if (item.getModificationDate() != null) {
                    return item.getModificationDate();
                }
                if (item.getCreationDate() != null) {
                    return item.getCreationDate();
                }
            }
            if (element instanceof IFileVersion) {
                IFileVersion item = (IFileVersion)element;
                return item.getDescription();
            }
            return null;
        }
    };
    public static final TableStyledLabelProvider.TableColumnProvider SINGLE_COLUMN = new TableStyledLabelProvider.TableColumnProvider(Messages.ReviewsLabelProvider_Items, 10, 120, false){

        public Image getImage(Object element) {
            return ITEMS_COLUMN.getImage(element);
        }

        public String getText(Object element) {
            Collection collection;
            if (element instanceof GlobalCommentsNode) {
                return Messages.Reviews_GeneralCommentsText;
            }
            if (element instanceof Collection && (collection = (Collection)element).size() == 1) {
                return this.getText(collection.iterator().next());
            }
            if (element instanceof IReview) {
                IReview review = (IReview)element;
                return NLS.bind((String)Messages.ReviewsLabelProvider_Change_X, (Object)review.getId());
            }
            if (element instanceof IFileItem) {
                IFileItem file = (IFileItem)element;
                String fileName = StringUtils.substringAfterLast((String)file.getName(), (String)File.separator);
                return fileName;
            }
            if (element instanceof IReviewItem) {
                return ((IReviewItem)element).getName();
            }
            if (element instanceof IComment) {
                IComment comment = (IComment)element;
                String desc = comment.getDescription();
                return desc;
            }
            if (element instanceof IUser) {
                IUser user = (IUser)element;
                return user.getDisplayName();
            }
            if (element instanceof Date) {
                return COMMENT_DATE_FORMAT.format(element);
            }
            if (element instanceof ILineLocation) {
                int min = ((ILineLocation)element).getRangeMin();
                int max = ((ILineLocation)element).getRangeMax();
                String text = "" + min;
                if (min != max) {
                    text = text + "-" + max;
                }
                return text;
            }
            return super.getText(element);
        }

        @Override
        public StyledString getStyledText(Object element) {
            String text = this.getText(element);
            StyledString styledString = new StyledString();
            if (text != null) {
                if (element instanceof IComment) {
                    IComment comment = (IComment)element;
                    String commentText = text;
                    int textLength = 0;
                    String authorText = "";
                    if (comment.getAuthor() != null) {
                        authorText = this.getText(comment.getAuthor());
                        textLength += authorText.length();
                    }
                    int descSpaceRemaining = 300 - textLength;
                    if (commentText.length() > descSpaceRemaining + 3) {
                        commentText = NLS.bind((String)Messages.ReviewsLabelProvider_X_dot_dot_dot, (Object)commentText.substring(0, descSpaceRemaining - 3));
                    }
                    commentText = StringUtils.rightPad((String)commentText, (int)(300 - textLength));
                    styledString.append(authorText + " ", AUTHOR_STYLE);
                    styledString.append(commentText + " ", COMMENT_STYLE);
                    styledString.append(this.getText(comment.getCreationDate()) + " ", COMMENT_DATE_STYLE);
                } else {
                    styledString.append(text);
                }
                if (element instanceof GlobalCommentsNode) {
                    element = ((GlobalCommentsNode)element).getReview();
                }
                ReviewsLabelProvider.addCommentContainerStatsStyle(element, styledString);
                if (element instanceof IFileItem) {
                    IReviewItem item = (IReviewItem)element;
                    styledString.append("  " + item.getName(), StyledString.QUALIFIER_STYLER);
                }
            } else {
                styledString.append(element.toString());
            }
            return styledString;
        }
    };
    private final boolean includeAuthors;

    public ReviewsLabelProvider() {
        this(false);
    }

    public ReviewsLabelProvider(boolean includeAuthors) {
        this.includeAuthors = includeAuthors;
    }

    public String getText(Object element) {
        return ITEMS_COLUMN.getText(element);
    }

    public StyledString getStyledText(Object element) {
        return this.getStyledText(element, true);
    }

    public StyledString getStyledText(Object element, boolean includeCommentStats) {
        StyledString.Styler styler = null;
        if (element instanceof IComment) {
            styler = COMMENT_STYLE;
        }
        StyledString styledString = new StyledString();
        if (this.includeAuthors) {
            ReviewsLabelProvider.addAuthorStyle(element, styledString);
        }
        styledString.append(this.getText(element), styler);
        if (element instanceof GlobalCommentsNode) {
            element = ((GlobalCommentsNode)element).getReview();
        }
        if (includeCommentStats) {
            ReviewsLabelProvider.addCommentContainerStatsStyle(element, styledString);
        }
        ReviewsLabelProvider.addCommentLineNumberStyle(element, styledString);
        ReviewsLabelProvider.addFilePathStyle(element, styledString);
        return styledString;
    }

    public Image getImage(Object element) {
        return ITEMS_COLUMN.getImage(element);
    }

    public static void addAuthorStyle(Object element, StyledString styledString) {
        if (element instanceof IComment) {
            IComment comment = (IComment)element;
            String name = comment.getAuthor().getDisplayName();
            String firstName = StringUtils.substringBefore((String)name, (String)" ");
            styledString.append(firstName + ": ", AUTHOR_STYLE);
        }
    }

    public static void addCommentLineNumberStyle(Object element, StyledString styledString) {
        if (element instanceof IComment) {
            IComment comment = (IComment)element;
            Object[] locationStrings = new String[comment.getLocations().size()];
            int index = 0;
            for (ILocation location : comment.getLocations()) {
                locationStrings[index++] = ITEMS_COLUMN.getText(location);
            }
            String locationString = StringUtils.join((Object[])locationStrings, (String)", ");
            styledString.append(" " + locationString, LINE_NUMBER_STYLE);
        }
    }

    public static void addFilePathStyle(Object element, StyledString styledString) {
        if (element instanceof IFileItem) {
            IReviewItem item = (IReviewItem)element;
            styledString.append("  " + item.getName(), StyledString.QUALIFIER_STYLER);
        }
    }

    public static void addCommentContainerStatsStyle(Object element, StyledString styledString) {
        if (element instanceof ICommentContainer) {
            ICommentContainer container = (ICommentContainer)element;
            String statsText = ReviewsLabelProvider.getStatsText(container);
            styledString.append(statsText, StyledString.DECORATIONS_STYLER);
        }
    }

    public static String getIndexText(IComment comment) {
        long index = comment.getIndex();
        return index < Long.MAX_VALUE ? Long.toString(index) : "";
    }

    public static String getStatsText(ICommentContainer container) {
        if (container instanceof IReviewItemSet && ((IReviewItemSet)container).getItems().size() == 0) {
            return Messages.ReviewsLabelProvider_Question_mark;
        }
        List comments = container instanceof IReview ? container.getComments() : container.getAllComments();
        int commentCount = comments.size();
        int draftCount = 0;
        for (IComment comment : comments) {
            if (!comment.isDraft()) continue;
            ++draftCount;
        }
        String statsText = "";
        if ((commentCount -= draftCount) > 0 && draftCount > 0) {
            statsText = NLS.bind((String)Messages.ReviewsLabelProvider_X_comments_Y_drafts, (Object)commentCount, (Object)draftCount);
        } else if (commentCount > 0) {
            statsText = NLS.bind((String)Messages.ReviewsLabelProvider_X_comments, (Object)commentCount);
        } else if (draftCount > 0) {
            statsText = NLS.bind((String)Messages.ReviewsLabelProvider_X_drafts, (Object)draftCount);
        }
        return statsText;
    }

    @Override
    public abstract TableStyledLabelProvider.TableColumnProvider[] getColumnProviders();

    public static class Flat
    extends ReviewsLabelProvider {
        TableStyledLabelProvider.TableColumnProvider[] columns = new TableStyledLabelProvider.TableColumnProvider[]{ARTIFACT_COLUMN, COMMENTS_COLUMN, AUTHORS_COLUMN, DATE_COLUMN};

        @Override
        public TableStyledLabelProvider.TableColumnProvider[] getColumnProviders() {
            return this.columns;
        }
    }

    public static class Simple
    extends ReviewsLabelProvider {
        TableStyledLabelProvider.TableColumnProvider[] columns = new TableStyledLabelProvider.TableColumnProvider[]{SINGLE_COLUMN};

        @Override
        public Image getImage(Object element) {
            if (element instanceof IReviewItem) {
                return super.getImage(element);
            }
            return null;
        }

        @Override
        public String getText(Object element) {
            if (element instanceof IReviewItem) {
                return ((IReviewItem)element).getName();
            }
            return super.getText(element);
        }

        @Override
        public StyledString getStyledText(Object element) {
            StyledString styledString = new StyledString(this.getText(element));
            Simple.addCommentContainerStatsStyle(element, styledString);
            return styledString;
        }

        @Override
        public TableStyledLabelProvider.TableColumnProvider[] getColumnProviders() {
            return this.columns;
        }
    }

    public static class Single
    extends ReviewsLabelProvider {
        TableStyledLabelProvider.TableColumnProvider[] columns = new TableStyledLabelProvider.TableColumnProvider[]{SINGLE_COLUMN};

        @Override
        public Image getImage(Object element) {
            return ITEMS_COLUMN.getImage(element);
        }

        @Override
        public TableStyledLabelProvider.TableColumnProvider[] getColumnProviders() {
            return this.columns;
        }
    }

    public static class Tree
    extends ReviewsLabelProvider {
        TableStyledLabelProvider.TableColumnProvider[] columns = new TableStyledLabelProvider.TableColumnProvider[]{ITEMS_COLUMN, AUTHORS_COLUMN, DATE_COLUMN};

        public Tree() {
            this(false);
        }

        public Tree(boolean includeAuthors) {
            super(includeAuthors);
        }

        @Override
        public TableStyledLabelProvider.TableColumnProvider[] getColumnProviders() {
            return this.columns;
        }
    }
}

