/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.validation;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.AbstractNLModel;
import org.eclipse.pde.internal.core.NLResourceHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.natures.PluginProject;
import org.eclipse.pde.internal.core.util.PDEJavaHelper;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.validation.AbstractControlValidator;
import org.eclipse.pde.internal.ui.editor.validation.IValidatorMessageHandler;
import org.osgi.framework.InvalidSyntaxException;

public class ControlValidationUtility {
    public static boolean validateRequiredField(String value, IValidatorMessageHandler validator, int messageType) {
        if (value.length() == 0) {
            validator.addMessage(PDEUIMessages.ControlValidationUtility_errorMsgValueMustBeSpecified, messageType);
            return false;
        }
        return true;
    }

    public static boolean validateTranslatableField(String value, IValidatorMessageHandler validator, IPluginModelBase model, IProject project) {
        NLResourceHelper helper;
        int messageType = AbstractControlValidator.getMessageType(project, "compilers.p.not-externalized-att");
        if (messageType == 0) {
            return true;
        }
        if (!value.startsWith("%")) {
            validator.addMessage(PDEUIMessages.ControlValidationUtility_errorMsgValueNotExternalized, messageType);
            return false;
        }
        if (model instanceof AbstractNLModel && ((helper = ((AbstractNLModel)model).getNLResourceHelper()) == null || !helper.resourceExists(value))) {
            validator.addMessage(PDEUIMessages.ControlValidationUtility_errorMsgKeyNotFound, messageType);
            return false;
        }
        return true;
    }

    public static boolean validateVersionField(String value, IValidatorMessageHandler validator) {
        IStatus status = VersionUtil.validateVersion((String)value);
        if (!status.isOK()) {
            validator.addMessage(status.getMessage(), AbstractControlValidator.getMessageType(status));
            return false;
        }
        return true;
    }

    public static boolean validatePlatformFilterField(String value, IValidatorMessageHandler validator) {
        try {
            PDECore.getDefault().getBundleContext().createFilter(value);
        }
        catch (InvalidSyntaxException ise) {
            validator.addMessage(PDEUIMessages.ControlValidationUtility_errorMsgFilterInvalidSyntax, 3);
            return false;
        }
        return true;
    }

    public static boolean validateActivatorField(String value, IValidatorMessageHandler validator, IProject project) {
        IJavaProject javaProject;
        int messageType = AbstractControlValidator.getMessageType(project, "compilers.p.unknown-class");
        if (messageType == 0) {
            return true;
        }
        if (PluginProject.isJavaProject((IProject)project) && !PDEJavaHelper.isOnClasspath((String)value, (IJavaProject)(javaProject = JavaCore.create((IProject)project)))) {
            validator.addMessage(PDEUIMessages.ControlValidationUtility_errorMsgNotOnClasspath, messageType);
            return false;
        }
        return true;
    }

    public static boolean validateFragmentHostPluginField(String value, IValidatorMessageHandler validator, IProject project) {
        int reqAttMessageType = AbstractControlValidator.getMessageType(project, "compilers.p.no-required-att");
        if (reqAttMessageType != 0 && !ControlValidationUtility.validateRequiredField(value, validator, reqAttMessageType)) {
            return false;
        }
        int unresImpMessageType = AbstractControlValidator.getMessageType(project, "compilers.p.unresolved-import");
        if (unresImpMessageType == 0) {
            return true;
        }
        IPluginModelBase hostModel = PluginRegistry.findModel((String)value);
        if (hostModel == null || hostModel instanceof IFragmentModel || !hostModel.isEnabled()) {
            validator.addMessage(PDEUIMessages.ControlValidationUtility_errorMsgPluginUnresolved, unresImpMessageType);
            return false;
        }
        return true;
    }
}

