/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.io.File;
import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIMethod;
import org.eclipse.swt.tools.internal.JNIParameter;
import org.eclipse.swt.tools.internal.JNIType;
import org.eclipse.swt.tools.internal.MetaData;
import org.eclipse.swt.tools.internal.ReflectClass;
import org.eclipse.swt.tools.internal.ReflectItem;
import org.eclipse.swt.tools.internal.ReflectMethod;
import org.eclipse.swt.tools.internal.ReflectType;

public class ReflectParameter
extends ReflectItem
implements JNIParameter {
    ReflectMethod method;
    int parameter;

    public ReflectParameter(ReflectMethod method, int parameter) {
        this.method = method;
        this.parameter = parameter;
    }

    @Override
    public String getCast() {
        Object cast = ((String)this.getParam("cast")).trim();
        if (((String)cast).length() > 0) {
            if (!((String)cast).startsWith("(")) {
                cast = "(" + (String)cast;
            }
            if (!((String)cast).endsWith(")")) {
                cast = (String)cast + ")";
            }
        }
        return cast;
    }

    @Override
    public String getMetaData() {
        MetaData metaData = this.method.declaringClass.metaData;
        String className = this.method.getDeclaringClass().getSimpleName();
        String key = className + "_" + JNIGenerator.getFunctionName(this.method) + "_" + this.parameter;
        String value = metaData.getMetaData(key, null);
        if (value == null) {
            key = className + "_" + this.method.getName() + "_" + this.parameter;
            value = metaData.getMetaData(key, null);
        }
        if (value == null) {
            JNIType[] paramTypes = this.method.getParameterTypes();
            if (ReflectItem.convertTo32Bit(paramTypes, true)) {
                key = className + "_" + JNIGenerator.getFunctionName(this.method, paramTypes) + "_" + this.parameter;
                value = metaData.getMetaData(key, null);
            }
            if (value == null && ReflectItem.convertTo32Bit(paramTypes = this.method.getParameterTypes(), false)) {
                key = className + "_" + JNIGenerator.getFunctionName(this.method, paramTypes) + "_" + this.parameter;
                value = metaData.getMetaData(key, null);
            }
        }
        if (value == null && this.method.getName().startsWith("_") && (value = metaData.getMetaData(key = className + "_" + JNIGenerator.getFunctionName(this.method).substring(2) + "_" + this.parameter, null)) == null) {
            key = className + "_" + this.method.getName().substring(1) + "_" + this.parameter;
            value = metaData.getMetaData(key, null);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Override
    public JNIMethod getMethod() {
        return this.method;
    }

    @Override
    public JNIClass getTypeClass() {
        ReflectType type = (ReflectType)this.getType();
        ReflectClass declaringClass = this.method.declaringClass;
        Object sourcePath = declaringClass.sourcePath;
        sourcePath = new File((String)sourcePath).getParent() + "/" + type.getSimpleName() + ".java";
        return new ReflectClass(type.clazz, declaringClass.metaData, (String)sourcePath);
    }

    @Override
    public JNIType getType() {
        return this.method.getParameterTypes()[this.parameter];
    }

    @Override
    public int getParameter() {
        return this.parameter;
    }

    @Override
    public void setCast(String str) {
        this.setParam("cast", str);
    }

    @Override
    public void setMetaData(String value) {
        String className = this.method.getDeclaringClass().getSimpleName();
        String key = this.method.isNativeUnique() ? className + "_" + this.method.getName() + "_" + this.parameter : className + "_" + JNIGenerator.getFunctionName(this.method) + "_" + this.parameter;
        this.method.declaringClass.metaData.setMetaData(key, value);
    }
}

