/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTMatcher;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Pattern;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypePattern;

public class PatternInstanceofExpression
extends Expression {
    public static final ChildPropertyDescriptor LEFT_OPERAND_PROPERTY = new ChildPropertyDescriptor(PatternInstanceofExpression.class, "leftOperand", Expression.class, true, true);
    public static final ChildPropertyDescriptor RIGHT_OPERAND_PROPERTY = new ChildPropertyDescriptor(PatternInstanceofExpression.class, "rightOperand", SingleVariableDeclaration.class, true, true);
    public static final ChildPropertyDescriptor PATTERN_PROPERTY = new ChildPropertyDescriptor(PatternInstanceofExpression.class, "pattern", Pattern.class, true, true);
    private static final List PROPERTY_DESCRIPTORS_16;
    private static final List PROPERTY_DESCRIPTORS_20;
    private volatile Expression leftOperand;
    private volatile SingleVariableDeclaration rightOperand;
    private volatile Pattern pattern;

    static {
        ArrayList properyList = new ArrayList(3);
        PatternInstanceofExpression.createPropertyList(PatternInstanceofExpression.class, properyList);
        PatternInstanceofExpression.addProperty(LEFT_OPERAND_PROPERTY, properyList);
        PatternInstanceofExpression.addProperty(RIGHT_OPERAND_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS_16 = PatternInstanceofExpression.reapPropertyList(properyList);
        properyList = new ArrayList(3);
        PatternInstanceofExpression.createPropertyList(PatternInstanceofExpression.class, properyList);
        PatternInstanceofExpression.addProperty(LEFT_OPERAND_PROPERTY, properyList);
        PatternInstanceofExpression.addProperty(PATTERN_PROPERTY, properyList);
        PROPERTY_DESCRIPTORS_20 = PatternInstanceofExpression.reapPropertyList(properyList);
    }

    public static List propertyDescriptors(int apiLevel) {
        return PROPERTY_DESCRIPTORS_16;
    }

    public static List propertyDescriptors(int apiLevel, boolean isPreview) {
        if (apiLevel >= 21) {
            return PROPERTY_DESCRIPTORS_20;
        }
        return PROPERTY_DESCRIPTORS_16;
    }

    PatternInstanceofExpression(AST ast) {
        super(ast);
        this.unsupportedBelow16();
    }

    @Override
    final List internalStructuralPropertiesForType(int apiLevel, boolean isPreview) {
        return PatternInstanceofExpression.propertyDescriptors(apiLevel, isPreview);
    }

    @Override
    List internalStructuralPropertiesForType(int apiLevel) {
        return PatternInstanceofExpression.propertyDescriptors(apiLevel);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == LEFT_OPERAND_PROPERTY) {
            if (get) {
                return this.getLeftOperand();
            }
            this.setLeftOperand((Expression)child);
            return null;
        }
        if (property == RIGHT_OPERAND_PROPERTY) {
            if (get) {
                return this.getRightOperand();
            }
            this.setRightOperand((SingleVariableDeclaration)child);
            return null;
        }
        if (property == PATTERN_PROPERTY) {
            if (get) {
                return this.getPattern();
            }
            this.setPattern((Pattern)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    final int getNodeType0() {
        return 104;
    }

    @Override
    ASTNode clone0(AST target) {
        PatternInstanceofExpression result = new PatternInstanceofExpression(target);
        result.setSourceRange(this.getStartPosition(), this.getLength());
        result.setLeftOperand((Expression)this.getLeftOperand().clone(target));
        if (this.ast.apiLevel < 20) {
            result.setRightOperand((SingleVariableDeclaration)this.getRightOperand().clone(target));
        } else {
            result.setPattern((Pattern)this.getPattern().clone(target));
        }
        return result;
    }

    @Override
    final boolean subtreeMatch0(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    void accept0(ASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChild(visitor, this.getLeftOperand());
            if (this.ast.apiLevel >= 21) {
                this.acceptChild(visitor, this.getPattern());
            } else {
                this.acceptChild(visitor, this.getRightOperand());
            }
        }
        visitor.endVisit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression getLeftOperand() {
        if (this.leftOperand == null) {
            PatternInstanceofExpression patternInstanceofExpression = this;
            synchronized (patternInstanceofExpression) {
                if (this.leftOperand == null) {
                    this.preLazyInit();
                    this.leftOperand = this.postLazyInit(new SimpleName(this.ast), LEFT_OPERAND_PROPERTY);
                }
            }
        }
        return this.leftOperand;
    }

    public void setLeftOperand(Expression expression) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        Expression oldChild = this.leftOperand;
        this.preReplaceChild(oldChild, expression, LEFT_OPERAND_PROPERTY);
        this.leftOperand = expression;
        this.postReplaceChild(oldChild, expression, LEFT_OPERAND_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleVariableDeclaration getRightOperand() {
        if (this.rightOperand == null) {
            PatternInstanceofExpression patternInstanceofExpression = this;
            synchronized (patternInstanceofExpression) {
                if (this.rightOperand == null) {
                    this.preLazyInit();
                    this.rightOperand = this.postLazyInit(new SingleVariableDeclaration(this.ast), RIGHT_OPERAND_PROPERTY);
                }
            }
        }
        return this.rightOperand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pattern getPattern() {
        this.supportedOnlyIn21();
        if (this.pattern == null) {
            PatternInstanceofExpression patternInstanceofExpression = this;
            synchronized (patternInstanceofExpression) {
                if (this.pattern == null) {
                    this.preLazyInit();
                    this.pattern = this.postLazyInit(new TypePattern(this.ast), PATTERN_PROPERTY);
                }
            }
        }
        return this.pattern;
    }

    public void setRightOperand(SingleVariableDeclaration referenceDeclaration) {
        if (referenceDeclaration == null) {
            throw new IllegalArgumentException();
        }
        SingleVariableDeclaration oldChild = this.rightOperand;
        this.preReplaceChild(oldChild, referenceDeclaration, RIGHT_OPERAND_PROPERTY);
        this.rightOperand = referenceDeclaration;
        this.postReplaceChild(oldChild, referenceDeclaration, RIGHT_OPERAND_PROPERTY);
    }

    public void setPattern(Pattern pattern) {
        this.supportedOnlyIn20();
        if (pattern == null) {
            throw new IllegalArgumentException();
        }
        Pattern oldChild = this.pattern;
        this.preReplaceChild(oldChild, pattern, PATTERN_PROPERTY);
        this.pattern = pattern;
        this.postReplaceChild(oldChild, pattern, PATTERN_PROPERTY);
    }

    @Override
    int memSize() {
        return 48;
    }

    @Override
    int treeSize() {
        return this.memSize() + (this.leftOperand == null ? 0 : this.getLeftOperand().treeSize()) + (this.ast.apiLevel < 20 ? (this.rightOperand == null ? 0 : this.getRightOperand().treeSize()) : (this.pattern == null ? 0 : this.getPattern().treeSize()));
    }
}

