/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;

public class MethodContext {
    private ContextType type = ContextType.NONE;
    private IASTName declarationName;
    private ICPPASTQualifiedName qname;

    public ContextType getType() {
        return this.type;
    }

    public void setType(ContextType type) {
        this.type = type;
    }

    public void setMethodDeclarationName(IASTName name) {
        this.declarationName = name;
    }

    public IASTName getMethodDeclarationName() {
        return this.declarationName;
    }

    public IASTDeclaration getMethodDeclaration() {
        IASTNode parent;
        if (this.declarationName != null && (parent = this.declarationName.getParent().getParent()) instanceof IASTDeclaration) {
            return (IASTDeclaration)parent;
        }
        return null;
    }

    public void setMethodQName(ICPPASTQualifiedName qname) {
        this.qname = qname;
    }

    public ICPPASTQualifiedName getMethodQName() {
        return this.qname;
    }

    public static boolean isSameClass(ICPPASTQualifiedName qname1, ICPPASTQualifiedName qname2) {
        ICPPClassType bind1 = MethodContext.getClassBinding(qname1);
        ICPPClassType bind2 = MethodContext.getClassBinding(qname2);
        return bind1.equals(bind2);
    }

    public static boolean isSameOrSubClass(MethodContext context1, MethodContext contextOfSameOrSubclass) {
        ICPPInternalBinding subclassBind;
        ICPPInternalBinding bind1 = MethodContext.getICPPInternalBinding(context1);
        if (MethodContext.isSameClass(bind1, subclassBind = MethodContext.getICPPInternalBinding(contextOfSameOrSubclass))) {
            return true;
        }
        return MethodContext.isSubclass(bind1, subclassBind);
    }

    private static boolean isSubclass(ICPPInternalBinding bind1, ICPPInternalBinding subclassBind) {
        if (subclassBind instanceof ICPPClassType) {
            ICPPBase[] bases;
            ICPPClassType classType = (ICPPClassType)subclassBind;
            ICPPBase[] iCPPBaseArray = bases = classType.getBases();
            int n = bases.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPBase base = iCPPBaseArray[n2];
                if (MethodContext.isSameClass(base, bind1)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isSameClass(MethodContext context1, MethodContext context2) {
        ICPPInternalBinding bind1 = MethodContext.getICPPInternalBinding(context1);
        ICPPInternalBinding bind2 = MethodContext.getICPPInternalBinding(context2);
        return MethodContext.isSameClass(bind1, bind2);
    }

    private static boolean isSameClass(ICPPBase base, ICPPInternalBinding bind2) {
        IScope scope2;
        IASTNode node1;
        IBinding bind1;
        block7: {
            IScope scope1;
            block6: {
                try {
                    bind1 = base.getBaseClass();
                    scope1 = bind1.getScope();
                    if (scope1 != null) break block6;
                    return false;
                }
                catch (DOMException e) {
                    return false;
                }
            }
            node1 = ASTInternal.getPhysicalNodeOfScope((IScope)scope1);
            scope2 = bind2.getScope();
            if (scope2 != null) break block7;
            return false;
        }
        IASTNode node2 = ASTInternal.getPhysicalNodeOfScope((IScope)scope2);
        if (node1.equals(node2)) {
            if (bind1 instanceof ICPPInternalBinding) {
                ICPPInternalBinding bind1int = (ICPPInternalBinding)bind1;
                return bind1int.getDefinition().equals(bind2.getDefinition());
            }
            return false;
        }
        return false;
    }

    private static boolean isSameClass(ICPPInternalBinding bind1, ICPPInternalBinding bind2) {
        IScope scope2;
        IASTNode node1;
        block6: {
            IScope scope1;
            block5: {
                try {
                    scope1 = bind1.getScope();
                    if (scope1 != null) break block5;
                    return false;
                }
                catch (DOMException e) {
                    return false;
                }
            }
            node1 = ASTInternal.getPhysicalNodeOfScope((IScope)scope1);
            scope2 = bind2.getScope();
            if (scope2 != null) break block6;
            return false;
        }
        IASTNode node2 = ASTInternal.getPhysicalNodeOfScope((IScope)scope2);
        if (node1.equals(node2)) {
            return bind1.getDefinition().equals(bind2.getDefinition());
        }
        return false;
    }

    public static ICPPInternalBinding getICPPInternalBinding(MethodContext context) {
        IASTName decl;
        IASTName node = decl = context.getMethodDeclarationName();
        while (node != null) {
            if (node instanceof ICPPASTCompositeTypeSpecifier) {
                ICPPASTCompositeTypeSpecifier type = (ICPPASTCompositeTypeSpecifier)node;
                IASTName classname = type.getName();
                return (ICPPInternalBinding)classname.resolveBinding();
            }
            node = node.getParent();
        }
        return null;
    }

    public boolean isInline() {
        return this.qname == null;
    }

    private static ICPPClassType getClassBinding(ICPPASTQualifiedName qname) {
        ICPPASTNameSpecifier classname = qname.getQualifier()[qname.getQualifier().length - 1];
        ICPPClassType bind = (ICPPClassType)classname.resolveBinding();
        return bind;
    }

    public static boolean isSameClass(IASTName declName1, IASTName declName2) {
        ICPPClassType bind1 = MethodContext.getClassBinding(declName1);
        ICPPClassType bind2 = MethodContext.getClassBinding(declName2);
        return bind1.equals(bind2);
    }

    public static boolean haveSameClass(MethodContext context1, MethodContext context2) {
        return MethodContext.isSameClass(context1.declarationName, context2.declarationName);
    }

    private static ICPPClassType getClassBinding(IASTName declName1) {
        if (declName1.getParent().getParent().getParent() instanceof ICPPASTCompositeTypeSpecifier) {
            ICPPASTCompositeTypeSpecifier compTypeSpec = (ICPPASTCompositeTypeSpecifier)declName1.getParent().getParent().getParent();
            return (ICPPClassType)compTypeSpec.getName().resolveBinding();
        }
        return null;
    }

    public static enum ContextType {
        NONE,
        FUNCTION,
        METHOD;

    }
}

