/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import org.sat4j.AbstractLauncher;
import org.sat4j.core.ASolverFactory;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ISolver;

public class BasicLauncher<T extends ISolver>
extends AbstractLauncher {
    private static final long serialVersionUID = 1L;
    private final ASolverFactory<T> factory;

    public BasicLauncher(ASolverFactory<T> factory) {
        this.factory = factory;
    }

    public static void main(String[] args) {
        BasicLauncher<ISolver> lanceur = new BasicLauncher<ISolver>(SolverFactory.instance());
        if (args.length == 0 || args.length > 3) {
            lanceur.usage();
            return;
        }
        lanceur.addHook();
        lanceur.run(args);
        System.exit(lanceur.getExitCode().value());
    }

    @Override
    protected ISolver configureSolver(String[] args) {
        T asolver = args.length >= 2 ? this.factory.createSolverByName(args[0]) : this.factory.defaultSolver();
        if (args.length == 3) {
            asolver.setTimeout(Integer.valueOf(args[1]));
        } else {
            asolver.setTimeout(Integer.MAX_VALUE);
        }
        if (!"BRESIL".equals(System.getProperty("prime")) && System.getProperty("all") == null) {
            asolver.setDBSimplificationAllowed(true);
        }
        this.getLogWriter().println(asolver.toString("c "));
        return asolver;
    }

    @Override
    protected Reader createReader(ISolver theSolver, String problemname) {
        return new InstanceReader(theSolver);
    }

    @Override
    public void usage() {
        this.log("java -jar org.sat4j.core.jar <cnffile>");
    }

    @Override
    protected String getInstanceName(String[] args) {
        if (args.length == 0) {
            return null;
        }
        return args[args.length - 1];
    }
}

