/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.plugin.PluginExtensionPointNode;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.actions.OpenSchemaAction;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.refactoring.PDERefactoringAction;
import org.eclipse.pde.internal.ui.refactoring.RefactoringActionFactory;
import org.eclipse.pde.internal.ui.search.PluginSearchActionGroup;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.extension.NewExtensionPointWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ExtensionPointsSection
extends TableSection {
    private TableViewer pointTable;

    public ExtensionPointsSection(PDEFormPage page, Composite parent) {
        super(page, parent, 384, new String[]{PDEUIMessages.ManifestEditor_DetailExtensionPointSection_new, PDEUIMessages.Actions_delete_label});
        this.getSection().setText(PDEUIMessages.ManifestEditor_DetailExtensionPointSection_title);
        this.getSection().setDescription(PDEUIMessages.ExtensionPointsSection_sectionDescAllExtensionPoints);
        this.fHandleDefaultButton = false;
        this.getTablePart().setEditable(false);
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.createViewerPartControl(container, 2, 2, toolkit);
        this.pointTable = tablePart.getTableViewer();
        this.pointTable.setContentProvider((IContentProvider)new TableContentProvider());
        this.pointTable.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.pointTable.setInput((Object)this.getPage());
        this.selectFirstExtensionPoint();
        IBaseModel model = this.getPage().getModel();
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).addModelChangedListener((IModelChangedListener)this);
        }
        tablePart.setButtonEnabled(0, model.isEditable());
    }

    private void selectFirstExtensionPoint() {
        Table table = this.pointTable.getTable();
        TableItem[] items = table.getItems();
        if (items.length == 0) {
            return;
        }
        TableItem firstItem = items[0];
        Object obj = firstItem.getData();
        this.pointTable.setSelection((ISelection)new StructuredSelection(obj));
    }

    void fireSelection() {
        this.pointTable.setSelection((ISelection)this.pointTable.getStructuredSelection());
    }

    public void dispose() {
        IBaseModel model = this.getPage().getModel();
        if (model instanceof IModelChangeProvider) {
            ((IModelChangeProvider)model).removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (!this.isEditable()) {
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return super.doGlobalAction(actionId);
    }

    public void refresh() {
        this.pointTable.refresh();
        this.getManagedForm().fireSelectionChanged((IFormPart)this, (ISelection)this.pointTable.getStructuredSelection());
        super.refresh();
    }

    public boolean setFormInput(Object object) {
        if (object instanceof IPluginExtensionPoint) {
            this.pointTable.setSelection((ISelection)new StructuredSelection(object), true);
            return true;
        }
        return false;
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        super.selectionChanged(selection);
    }

    @Override
    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.markStale();
            return;
        }
        Object changeObject = event.getChangedObjects()[0];
        if (changeObject instanceof IPluginExtensionPoint) {
            if (event.getChangeType() == 1) {
                this.pointTable.add(changeObject);
                this.pointTable.setSelection((ISelection)new StructuredSelection(changeObject), true);
                this.pointTable.getTable().setFocus();
            } else if (event.getChangeType() == 2) {
                this.pointTable.remove(changeObject);
            } else {
                this.pointTable.update(changeObject, null);
            }
        }
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = this.pointTable.getStructuredSelection();
        Action newAction = new Action(PDEUIMessages.ManifestEditor_DetailExtensionPointSection_newExtensionPoint){

            public void run() {
                ExtensionPointsSection.this.handleNew();
            }
        };
        newAction.setEnabled(this.isEditable());
        manager.add((IAction)newAction);
        if (selection.isEmpty()) {
            this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
            return;
        }
        manager.add((IContributionItem)new Separator());
        IBaseModel model = this.getPage().getPDEEditor().getAggregateModel();
        PluginSearchActionGroup actionGroup = new PluginSearchActionGroup();
        actionGroup.setBaseModel(model);
        actionGroup.setContext(new ActionContext((ISelection)selection));
        actionGroup.fillContextMenu(manager);
        manager.add((IContributionItem)new Separator());
        if (this.isEditable() && selection.size() == 1) {
            PDERefactoringAction action = RefactoringActionFactory.createRefactorExtPointAction(PDEUIMessages.ExtensionPointsSection_rename_label);
            action.setSelection(selection.getFirstElement());
            manager.add((IAction)action);
            manager.add((IContributionItem)new Separator());
        }
        Action deleteAction = new Action(PDEUIMessages.Actions_delete_label){

            public void run() {
                ExtensionPointsSection.this.handleDelete();
            }
        };
        deleteAction.setEnabled(this.isEditable());
        manager.add((IAction)deleteAction);
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    @Override
    protected void buttonSelected(int index) {
        if (index == 0) {
            this.handleNew();
        } else if (index == 1) {
            this.handleDelete();
        }
    }

    @Override
    protected void handleDoubleClick(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            PluginExtensionPointNode extensionPoint = (PluginExtensionPointNode)selection.getFirstElement();
            Object pointID = extensionPoint.getId();
            IBaseModel model = this.getPage().getPDEEditor().getAggregateModel();
            String basePointID = ((IPluginModelBase)model).getPluginBase().getId();
            pointID = basePointID + "." + (String)pointID;
            OpenSchemaAction action = new OpenSchemaAction();
            action.setInput((String)pointID);
            action.run();
        }
    }

    private void handleDelete() {
        Object[] selection;
        Object[] objectArray = selection = this.pointTable.getStructuredSelection().toArray();
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedObject = objectArray[n2];
            if (selectedObject != null && selectedObject instanceof IPluginExtensionPoint) {
                IPluginExtensionPoint ep = (IPluginExtensionPoint)selectedObject;
                StructuredSelection newSelection = null;
                IPluginBase plugin = ep.getPluginBase();
                Object[] points = plugin.getExtensionPoints();
                int index = this.getNewSelectionIndex(this.getArrayIndex(points, ep), points.length);
                if (index != -1) {
                    newSelection = new StructuredSelection(points[index]);
                }
                try {
                    IProject project;
                    IFile schemaFile;
                    String schema = ep.getSchema();
                    if (schema != null && schema.length() > 0 && (schemaFile = (project = ep.getModel().getUnderlyingResource().getProject()).getFile(schema)) != null && schemaFile.exists() && MessageDialog.openQuestion((Shell)this.getSection().getShell(), (String)PDEUIMessages.ExtensionPointsSection_title, (String)NLS.bind((String)PDEUIMessages.ExtensionPointsSection_message1, (Object)schemaFile.getProjectRelativePath().toString()))) {
                        schemaFile.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    plugin.remove(ep);
                    if (newSelection != null) {
                        this.pointTable.setSelection((ISelection)newSelection);
                    }
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
            ++n2;
        }
    }

    private void handleNew() {
        IFile file = ((IFileEditorInput)this.getPage().getPDEEditor().getEditorInput()).getFile();
        IProject project = file.getProject();
        BusyIndicator.showWhile((Display)this.pointTable.getTable().getDisplay(), () -> {
            NewExtensionPointWizard wizard = new NewExtensionPointWizard(project, (IPluginModelBase)this.getPage().getModel(), (ManifestEditor)this.getPage().getPDEEditor());
            WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
            dialog.create();
            SWTUtil.setDialogSize((Dialog)dialog, 400, 450);
            dialog.open();
        });
    }

    private IPluginModelBase getPluginModelBase() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        if (!(model instanceof IBundlePluginModelBase)) {
            return null;
        }
        ISharedExtensionsModel extensionModel = ((IBundlePluginModelBase)model).getExtensionsModel();
        if (extensionModel == null || !(extensionModel instanceof IPluginModelBase)) {
            return null;
        }
        return (IPluginModelBase)extensionModel;
    }

    @Override
    protected void doPaste(Object targetObject, Object[] sourceObjects) {
        ((ManifestEditor)this.getPage().getEditor()).ensurePluginContextPresence();
        IPluginModelBase model = this.getPluginModelBase();
        if (model == null) {
            return;
        }
        IPluginBase pluginBase = model.getPluginBase();
        try {
            Object[] objectArray = sourceObjects;
            int n = sourceObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object sourceObject = objectArray[n2];
                if (sourceObject instanceof IPluginExtensionPoint && pluginBase instanceof IDocumentElementNode) {
                    IDocumentElementNode extensionPoint = (IDocumentElementNode)sourceObject;
                    extensionPoint.reconnect((IDocumentElementNode)pluginBase, (IModel)model);
                    pluginBase.add((IPluginExtensionPoint)extensionPoint);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    @Override
    protected boolean canPaste(Object targetObject, Object[] sourceObjects) {
        Object[] objectArray = sourceObjects;
        int n = sourceObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object sourceObject = objectArray[n2];
            if (!(sourceObject instanceof IPluginExtensionPoint)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected void selectExtensionPoint(ISelection selection) {
        this.pointTable.setSelection(selection, true);
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object parent) {
            IPluginModelBase model = (IPluginModelBase)ExtensionPointsSection.this.getPage().getModel();
            IPluginBase pluginBase = model.getPluginBase();
            if (pluginBase != null) {
                return pluginBase.getExtensionPoints();
            }
            return new Object[0];
        }
    }
}

