/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.net;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.mylyn.internal.commons.net.CommonsNetPlugin;
import org.eclipse.mylyn.internal.commons.net.InfiniteSubProgressMonitor;

public class Policy {
    public static boolean DEBUG_STREAMS = false;

    static {
        if (CommonsNetPlugin.getDefault() != null && CommonsNetPlugin.getDefault().isDebugging()) {
            DEBUG_STREAMS = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.mylyn.commons.net/streams"));
        }
    }

    public static void advance(IProgressMonitor monitor, int worked) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        monitor.worked(worked);
    }

    public static void checkCanceled(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public static boolean isBackgroundMonitor(IProgressMonitor monitor) {
        return monitor instanceof BackgroundProgressMonitor;
    }

    public static IProgressMonitor backgroundMonitorFor(IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return new BackgroundProgressMonitor(monitor);
    }

    public static IProgressMonitor monitorFor(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }

    public static IProgressMonitor monitorFor(IProgressMonitor monitor, boolean backgroundOperation) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (backgroundOperation) {
            return Policy.backgroundMonitorFor(monitor);
        }
        return monitor;
    }

    public static IProgressMonitor subMonitorFor(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        if (monitor instanceof BackgroundProgressMonitor) {
            return new BackgroundProgressMonitor((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)ticks));
        }
        return SubMonitor.convert((IProgressMonitor)monitor, (int)ticks);
    }

    public static IProgressMonitor infiniteSubMonitorFor(IProgressMonitor monitor, int ticks) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        if (monitor instanceof NullProgressMonitor) {
            return monitor;
        }
        if (monitor instanceof BackgroundProgressMonitor) {
            return new BackgroundProgressMonitor((IProgressMonitor)new InfiniteSubProgressMonitor(monitor, ticks));
        }
        return new InfiniteSubProgressMonitor(monitor, ticks);
    }

    private static class BackgroundProgressMonitor
    extends ProgressMonitorWrapper {
        protected BackgroundProgressMonitor(IProgressMonitor monitor) {
            super(monitor);
        }
    }
}

