/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposalCore;

public class MakeLocalVariableNonNullProposalCore
extends ASTRewriteCorrectionProposalCore {
    private final IVariableBinding fBinding;
    private final CompilationUnit fAstRoot;
    private final String fNonNullAnnotationName;

    public MakeLocalVariableNonNullProposalCore(ICompilationUnit targetCU, IVariableBinding varBinding, CompilationUnit astRoot, int relevance, String nonNullAnnotationName) {
        super("", targetCU, (ASTRewrite)null, relevance);
        this.fNonNullAnnotationName = nonNullAnnotationName;
        this.fBinding = varBinding;
        this.fAstRoot = astRoot;
        String annotationNameLabel = this.fNonNullAnnotationName;
        int lastDot = this.fNonNullAnnotationName.lastIndexOf(46);
        if (lastDot != -1) {
            annotationNameLabel = this.fNonNullAnnotationName.substring(lastDot + 1);
        }
        annotationNameLabel = BasicElementLabels.getJavaElementName(annotationNameLabel);
        Object[] args = new String[]{BasicElementLabels.getJavaElementName(varBinding.getName()), annotationNameLabel};
        this.setDisplayName(Messages.format(CorrectionMessages.NullAnnotationsCorrectionProcessor_change_local_variable_to_nonNull, args));
    }

    @Override
    protected ASTRewrite getRewrite() throws CoreException {
        ASTNode declNode = this.fAstRoot.findDeclaringNode((IBinding)this.fBinding);
        if (declNode != null) {
            AST ast = declNode.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            ImportRewrite imports = this.createImportRewrite(this.fAstRoot);
            ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(this.fAstRoot, declNode.getStartPosition(), imports);
            String nonNullType = imports.addImport(this.fNonNullAnnotationName, (ImportRewrite.ImportRewriteContext)context);
            if (declNode instanceof VariableDeclarationFragment) {
                ASTNode parent = declNode.getParent();
                if (parent instanceof VariableDeclarationStatement) {
                    VariableDeclarationStatement varDecl = (VariableDeclarationStatement)parent;
                    if (varDecl.fragments().size() > 1 && varDecl.getParent() instanceof Block) {
                        VariableDeclarationFragment placeholder = (VariableDeclarationFragment)rewrite.createMoveTarget(declNode);
                        VariableDeclarationStatement newStat = ast.newVariableDeclarationStatement(placeholder);
                        newStat.setType((Type)rewrite.createCopyTarget((ASTNode)varDecl.getType()));
                        newStat.modifiers().addAll(ASTNodeFactory.newModifiers(ast, varDecl.getModifiers()));
                        this.addNullAnnotation((ASTNode)newStat, VariableDeclarationStatement.MODIFIERS2_PROPERTY, rewrite, nonNullType, ast);
                        ListRewrite listRewrite = rewrite.getListRewrite(varDecl.getParent(), Block.STATEMENTS_PROPERTY);
                        if (varDecl.fragments().indexOf(declNode) == 0) {
                            listRewrite.insertBefore((ASTNode)newStat, parent, null);
                        } else {
                            listRewrite.insertAfter((ASTNode)newStat, parent, null);
                        }
                    } else {
                        this.addNullAnnotation((ASTNode)varDecl, VariableDeclarationStatement.MODIFIERS2_PROPERTY, rewrite, nonNullType, ast);
                    }
                } else if (parent instanceof VariableDeclarationExpression) {
                    VariableDeclarationExpression varDecl = (VariableDeclarationExpression)parent;
                    this.addNullAnnotation((ASTNode)varDecl, VariableDeclarationExpression.MODIFIERS2_PROPERTY, rewrite, nonNullType, ast);
                }
            } else if (declNode instanceof SingleVariableDeclaration) {
                SingleVariableDeclaration varDecl = (SingleVariableDeclaration)declNode;
                this.addNullAnnotation((ASTNode)varDecl, SingleVariableDeclaration.MODIFIERS2_PROPERTY, rewrite, nonNullType, ast);
            }
            return rewrite;
        }
        return null;
    }

    private void addNullAnnotation(ASTNode varDecl, ChildListPropertyDescriptor modifiers2Property, ASTRewrite rewrite, String nonNullType, AST ast) {
        ListRewrite listRewrite = rewrite.getListRewrite(varDecl, modifiers2Property);
        MarkerAnnotation newAnnotation = ast.newMarkerAnnotation();
        newAnnotation.setTypeName(ast.newName(nonNullType));
        listRewrite.insertLast((ASTNode)newAnnotation, null);
    }
}

