/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFieldReference;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.SemanticQueries;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVariableReadWriteFlags;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.resources.IResource;

public class ClassMembersInitializationChecker
extends AbstractIndexAstChecker {
    public static final String ER_ID = "org.eclipse.cdt.codan.internal.checkers.ClassMembersInitialization";
    public static final String PARAM_SKIP = "skip";

    public void processAst(IASTTranslationUnit ast) {
        ast.accept((ASTVisitor)new OnEachClass());
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, PARAM_SKIP, CheckersMessages.ClassMembersInitializationChecker_SkipConstructorsWithFCalls, Boolean.TRUE);
    }

    public boolean skipConstructorsWithFCalls() {
        return (Boolean)this.getPreference(this.getProblemById(ER_ID, (IResource)this.getFile()), PARAM_SKIP);
    }

    class OnEachClass
    extends ASTVisitor {
        private final Stack<Set<IField>> constructorsStack = new Stack();
        private boolean skipConstructorsWithFCalls;

        OnEachClass() {
            this.skipConstructorsWithFCalls = ClassMembersInitializationChecker.this.skipConstructorsWithFCalls();
            this.shouldVisitDeclarations = true;
            this.shouldVisitNames = true;
            this.shouldVisitExpressions = true;
        }

        public int visit(IASTDeclaration declaration) {
            ICPPConstructor constructor = this.getConstructor(declaration);
            if (constructor != null) {
                Set fieldsInConstructor = this.constructorsStack.push(new HashSet());
                try {
                    CPPSemantics.pushLookupPoint((IASTNode)declaration);
                    ICPPField[] iCPPFieldArray = constructor.getClassOwner().getDeclaredFields();
                    int n = iCPPFieldArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICPPField field = iCPPFieldArray[n2];
                        if (this.isSimpleType(field.getType()) && !field.isStatic() && field.getInitialValue() == null) {
                            fieldsInConstructor.add(field);
                        }
                        ++n2;
                    }
                }
                finally {
                    CPPSemantics.popLookupPoint();
                }
            }
            return 3;
        }

        public int leave(IASTDeclaration declaration) {
            if (this.getConstructor(declaration) != null) {
                for (IField field : this.constructorsStack.pop()) {
                    ClassMembersInitializationChecker.this.reportProblem(ClassMembersInitializationChecker.ER_ID, (IASTNode)declaration, new Object[]{field.getName()});
                }
            }
            return 3;
        }

        public int visit(IASTExpression expression) {
            IASTBinaryExpression binaryExpression;
            Set<IField> actualConstructorFields;
            boolean skipCurrentConstructor = false;
            if (this.skipConstructorsWithFCalls && !this.constructorsStack.empty() && expression instanceof IASTFunctionCallExpression && !(actualConstructorFields = this.constructorsStack.peek()).isEmpty()) {
                IASTFunctionCallExpression fCall = (IASTFunctionCallExpression)expression;
                IASTExpression fNameExp = fCall.getFunctionNameExpression();
                IBinding fBinding = null;
                if (fNameExp instanceof IASTIdExpression) {
                    fName = (IASTIdExpression)fNameExp;
                    fBinding = fName.getName().resolveBinding();
                } else if (fNameExp instanceof ICPPASTFieldReference) {
                    fName = (ICPPASTFieldReference)fNameExp;
                    fBinding = fName.getFieldName().resolveBinding();
                }
                if (fBinding != null) {
                    if (fBinding instanceof ICPPMethod) {
                        ICPPMethod method = (ICPPMethod)fBinding;
                        ICompositeType constructorOwner = actualConstructorFields.iterator().next().getCompositeTypeOwner();
                        if (constructorOwner.equals(method.getClassOwner()) && !method.getType().isConst()) {
                            skipCurrentConstructor = true;
                        }
                    } else if (fBinding instanceof ICPPFunction) {
                        IASTInitializerClause[] iASTInitializerClauseArray = fCall.getArguments();
                        int n = iASTInitializerClauseArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IASTInitializerClause argument = iASTInitializerClauseArray[n2];
                            if (this.referencesThis((IASTNode)argument)) {
                                skipCurrentConstructor = true;
                                break;
                            }
                            ++n2;
                        }
                    }
                }
            }
            if (expression instanceof IASTBinaryExpression && this.referencesThis((IASTNode)(binaryExpression = (IASTBinaryExpression)expression).getOperand1()) && binaryExpression.getOperand1().isLValue()) {
                skipCurrentConstructor = true;
            }
            if (skipCurrentConstructor && !this.constructorsStack.empty()) {
                this.constructorsStack.peek().clear();
            }
            return 3;
        }

        public boolean referencesThis(IASTNode expr) {
            if (expr instanceof IASTLiteralExpression) {
                IASTLiteralExpression litArg = (IASTLiteralExpression)expr;
                if (litArg.getKind() == 4) {
                    return true;
                }
            } else if (expr instanceof ICPPASTUnaryExpression) {
                ICPPASTUnaryExpression unExpr = (ICPPASTUnaryExpression)expr;
                switch (unExpr.getOperator()) {
                    case 4: 
                    case 5: 
                    case 11: {
                        return this.referencesThis((IASTNode)unExpr.getOperand());
                    }
                }
            }
            return false;
        }

        public int visit(IASTName name) {
            if (!this.constructorsStack.empty()) {
                Optional res;
                IField equivalentFieldBinding;
                IBinding binding;
                IASTFieldReference ref;
                if (name.getParent() instanceof IASTFieldReference && !this.referencesThis((IASTNode)(ref = (IASTFieldReference)name.getParent()).getFieldOwner())) {
                    return 3;
                }
                Set<IField> actualConstructorFields = this.constructorsStack.peek();
                if (!actualConstructorFields.isEmpty() && (binding = name.resolveBinding()) != null && !(binding instanceof IProblemBinding) && (equivalentFieldBinding = this.getContainedEquivalentBinding(actualConstructorFields, binding, name.getTranslationUnit().getIndex())) != null && CPPVariableReadWriteFlags.mayBeWriteAccess((Optional)(res = CPPVariableReadWriteFlags.getReadWriteFlags((IASTName)name)))) {
                    actualConstructorFields.remove(equivalentFieldBinding);
                }
            }
            return 3;
        }

        private IField getContainedEquivalentBinding(Iterable<IField> fields, IBinding binding, IIndex index) {
            for (IField field : fields) {
                if (!CPPVisitor.areEquivalentBindings((IBinding)binding, (IBinding)field, (IIndex)index)) continue;
                return field;
            }
            return null;
        }

        private boolean isSimpleType(IType type) {
            return type instanceof IBasicType || type instanceof IPointerType || type instanceof IEnumeration || type instanceof ICPPReferenceType || type instanceof ITypedef && this.isSimpleType(((ITypedef)type).getType());
        }

        private ICPPConstructor getConstructor(IASTDeclaration decl) {
            if (decl instanceof ICPPASTFunctionDefinition) {
                ICPPASTFunctionDefinition functionDefinition = (ICPPASTFunctionDefinition)decl;
                if (functionDefinition.isDeleted()) {
                    return null;
                }
                IBinding binding = functionDefinition.getDeclarator().getName().resolveBinding();
                if (binding instanceof ICPPConstructor) {
                    ICPPConstructor constructor = (ICPPConstructor)binding;
                    if (functionDefinition.isDefaulted() && SemanticQueries.isCopyOrMoveConstructor((ICPPConstructor)constructor)) {
                        return null;
                    }
                    if (constructor.getClassOwner().getKey() == 2) {
                        return null;
                    }
                    ICPPASTConstructorChainInitializer[] iCPPASTConstructorChainInitializerArray = functionDefinition.getMemberInitializers();
                    int n = iCPPASTConstructorChainInitializerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICPPASTConstructorChainInitializer memberInitializer = iCPPASTConstructorChainInitializerArray[n2];
                        IASTName memberName = memberInitializer.getMemberInitializerId();
                        if (memberName != null) {
                            IBinding memberBinding = memberName.resolveBinding();
                            ICPPClassType classType = null;
                            if (memberBinding instanceof ICPPClassType) {
                                classType = (ICPPClassType)memberBinding;
                            } else if (memberBinding instanceof ICPPConstructor) {
                                classType = ((ICPPConstructor)memberBinding).getClassOwner();
                            }
                            if (classType instanceof ICPPDeferredClassInstance) {
                                classType = ((ICPPDeferredClassInstance)classType).getClassTemplate();
                            }
                            if (classType != null && classType.isSameType((IType)constructor.getClassOwner())) {
                                return null;
                            }
                        }
                        ++n2;
                    }
                    return constructor;
                }
            }
            return null;
        }
    }
}

