/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.dialogs;

import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.core.param.IProblemPreference;
import org.eclipse.cdt.codan.core.param.RootProblemPreference;
import org.eclipse.cdt.codan.internal.core.model.CodanProblem;
import org.eclipse.cdt.codan.internal.ui.CodanUIMessages;
import org.eclipse.cdt.codan.internal.ui.widgets.CustomizeProblemComposite;
import org.eclipse.cdt.codan.internal.ui.widgets.ParametersComposite;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class CustomizeProblemDialog
extends TitleAreaDialog {
    private CustomizeProblemComposite comp;
    private IProblem problem;
    private IProblem[] problems;
    private IResource resource;
    private boolean combined = false;

    public CustomizeProblemDialog(Shell parentShell, IProblem[] selectedProblems, IResource resource) {
        super(parentShell);
        this.problems = selectedProblems;
        this.problem = this.buildCombined(selectedProblems);
        this.resource = resource;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    private IProblem buildCombined(IProblem[] selectedProblems) {
        if (selectedProblems.length == 0) {
            return null;
        }
        IProblem one = selectedProblems[0];
        if (selectedProblems.length == 1) {
            return one;
        }
        this.combined = true;
        CodanProblem problem = new CodanProblem("multi", this.getTitle());
        problem.setMessagePattern(ParametersComposite.NO_CHANGE);
        problem.setPreference((IProblemPreference)new RootProblemPreference());
        problem.setSeverity(one.getSeverity());
        problem.setEnabled(one.isEnabled());
        if (one.getPreference() instanceof RootProblemPreference) {
            RootProblemPreference onepref = (RootProblemPreference)one.getPreference();
            RootProblemPreference pref = (RootProblemPreference)problem.getPreference();
            pref.addChildDescriptor((IProblemPreference)onepref.getLaunchModePreference());
            pref.addChildDescriptor((IProblemPreference)onepref.getScopePreference());
        }
        return problem;
    }

    public void save(IProblemWorkingCopy problem) {
        this.comp.save(problem);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(CodanUIMessages.CustomizeProblemDialog_Title);
        this.setTitle(this.getTitle());
        this.setMessage(CodanUIMessages.CustomizeProblemDialog_Message);
        Composite area = (Composite)super.createDialogArea(parent);
        this.comp = new CustomizeProblemComposite(area, this.problem, this.resource, this.combined);
        GridData ld = new GridData(1808);
        ld.minimumHeight = 300;
        this.comp.setLayoutData(ld);
        return area;
    }

    public String getTitle() {
        if (this.problems.length == 1) {
            return this.problem.getName();
        }
        Object b = "";
        int i = 0;
        while (i < this.problems.length) {
            IProblem p = this.problems[i];
            if (i != 0) {
                b = (String)b + ", ";
            }
            b = (String)b + p.getName();
            ++i;
        }
        return b;
    }

    protected void okPressed() {
        int i = 0;
        while (i < this.problems.length) {
            IProblemWorkingCopy wc = (IProblemWorkingCopy)this.problems[i];
            this.save(wc);
            ++i;
        }
        super.okPressed();
    }
}

