/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.apache.lucene.search.AbstractDocIdSetIterator;
import org.apache.lucene.search.DisiPriorityQueue;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.FixedBitSet;

public final class DisjunctionDISIApproximation
extends AbstractDocIdSetIterator {
    private final DisiPriorityQueue leadIterators;
    private final DisiWrapper[] otherIterators;
    private final long cost;
    private DisiWrapper leadTop;
    private int minOtherDoc;

    public static DisjunctionDISIApproximation of(Collection<? extends DisiWrapper> subIterators, long leadCost) {
        return new DisjunctionDISIApproximation(subIterators, leadCost);
    }

    public DisjunctionDISIApproximation(Collection<? extends DisiWrapper> subIterators, long leadCost) {
        long lastCost;
        long inc;
        int lastIdx;
        DisiWrapper[] wrappers = (DisiWrapper[])subIterators.toArray(DisiWrapper[]::new);
        Arrays.sort(wrappers, Comparator.comparingLong(w -> w.cost).reversed());
        long reorderThreshold = leadCost + (leadCost >> 1);
        if (reorderThreshold < 0L) {
            reorderThreshold = Long.MAX_VALUE;
        }
        long cost = 0L;
        long reorderCost = 0L;
        for (lastIdx = wrappers.length - 1; lastIdx >= 0 && reorderCost + (inc = Math.min(lastCost = wrappers[lastIdx].cost, leadCost)) >= 0L && reorderCost + inc <= reorderThreshold; --lastIdx) {
            reorderCost += inc;
            cost += lastCost;
        }
        if (lastIdx == wrappers.length - 1) {
            cost += wrappers[lastIdx].cost;
            --lastIdx;
        }
        assert (lastIdx >= -1 && lastIdx < wrappers.length - 1);
        int pqLen = wrappers.length - lastIdx - 1;
        this.leadIterators = DisiPriorityQueue.ofMaxSize(pqLen);
        this.leadIterators.addAll(wrappers, lastIdx + 1, pqLen);
        this.otherIterators = ArrayUtil.copyOfSubArray(wrappers, 0, lastIdx + 1);
        this.minOtherDoc = Integer.MAX_VALUE;
        for (DisiWrapper w2 : this.otherIterators) {
            cost += w2.cost;
            this.minOtherDoc = Math.min(this.minOtherDoc, w2.doc);
        }
        this.cost = cost;
        this.leadTop = this.leadIterators.top();
    }

    @Override
    public long cost() {
        return this.cost;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.leadTop.doc < this.minOtherDoc) {
            int curDoc = this.leadTop.doc;
            do {
                this.leadTop.doc = this.leadTop.approximation.nextDoc();
                this.leadTop = this.leadIterators.updateTop();
            } while (this.leadTop.doc == curDoc);
            this.doc = Math.min(this.leadTop.doc, this.minOtherDoc);
            return this.doc;
        }
        return this.advance(this.minOtherDoc + 1);
    }

    @Override
    public int advance(int target) throws IOException {
        while (this.leadTop.doc < target) {
            this.leadTop.doc = this.leadTop.approximation.advance(target);
            this.leadTop = this.leadIterators.updateTop();
        }
        this.minOtherDoc = Integer.MAX_VALUE;
        for (DisiWrapper w : this.otherIterators) {
            if (w.doc < target) {
                w.doc = w.approximation.advance(target);
            }
            this.minOtherDoc = Math.min(this.minOtherDoc, w.doc);
        }
        this.doc = Math.min(this.leadTop.doc, this.minOtherDoc);
        return this.doc;
    }

    @Override
    public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) throws IOException {
        while (this.leadTop.doc < upTo) {
            this.leadTop.approximation.intoBitSet(upTo, bitSet, offset);
            this.leadTop.doc = this.leadTop.approximation.docID();
            this.leadTop = this.leadIterators.updateTop();
        }
        this.minOtherDoc = Integer.MAX_VALUE;
        for (DisiWrapper w : this.otherIterators) {
            w.approximation.intoBitSet(upTo, bitSet, offset);
            w.doc = w.approximation.docID();
            this.minOtherDoc = Math.min(this.minOtherDoc, w.doc);
        }
        this.doc = Math.min(this.leadTop.doc, this.minOtherDoc);
    }

    public DisiWrapper topList() {
        if (this.leadTop.doc < this.minOtherDoc) {
            return this.leadIterators.topList();
        }
        return this.computeTopList();
    }

    private DisiWrapper computeTopList() {
        assert (this.leadTop.doc >= this.minOtherDoc);
        DisiWrapper topList = null;
        if (this.leadTop.doc == this.minOtherDoc) {
            topList = this.leadIterators.topList();
        }
        for (DisiWrapper w : this.otherIterators) {
            if (w.doc != this.minOtherDoc) continue;
            w.next = topList;
            topList = w;
        }
        return topList;
    }

    @Override
    public int docIDRunEnd() throws IOException {
        int maxDocIDRunEnd = super.docIDRunEnd();
        DisiWrapper w = this.topList();
        while (w != null) {
            maxDocIDRunEnd = Math.max(maxDocIDRunEnd, w.approximation.docIDRunEnd());
            w = w.next;
        }
        return maxDocIDRunEnd;
    }
}

