/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import java.util.ArrayList;
import org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

final class KotlinDefaultArgumentsFilter
implements IFilter {
    KotlinDefaultArgumentsFilter() {
    }

    private static boolean isDefaultArgumentsMethod(MethodNode methodNode) {
        return methodNode.name.endsWith("$default");
    }

    private static boolean isDefaultArgumentsConstructor(MethodNode methodNode) {
        if (!"<init>".equals(methodNode.name)) {
            return false;
        }
        Type[] argumentTypes = Type.getMethodType((String)methodNode.desc).getArgumentTypes();
        if (argumentTypes.length < 2) {
            return false;
        }
        return "kotlin.jvm.internal.DefaultConstructorMarker".equals(argumentTypes[argumentTypes.length - 1].getClassName());
    }

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        if ((methodNode.access & 0x1000) == 0) {
            return;
        }
        if (KotlinDefaultArgumentsFilter.isDefaultArgumentsMethod(methodNode)) {
            new Matcher().match(methodNode, output, false);
        } else if (KotlinDefaultArgumentsFilter.isDefaultArgumentsConstructor(methodNode)) {
            new Matcher().match(methodNode, output, true);
        }
    }

    static int computeNumberOfMaskArguments(int arguments) {
        return (arguments - 2) / 33 + 1;
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        public void match(MethodNode methodNode, IFilterOutput output, boolean constructor) {
            this.cursor = Matcher.skipNonOpcodes(methodNode.instructions.getFirst());
            this.nextIs(198);
            this.nextIsType(187, "java/lang/UnsupportedOperationException");
            this.nextIs(89);
            this.nextIs(18);
            if (this.cursor == null || !(((LdcInsnNode)this.cursor).cst instanceof String) || !((String)((LdcInsnNode)this.cursor).cst).startsWith("Super calls with default arguments not supported in this target")) {
                this.cursor = null;
            }
            this.nextIsInvoke(183, "java/lang/UnsupportedOperationException", "<init>", "(Ljava/lang/String;)V");
            this.nextIs(191);
            if (this.cursor != null) {
                output.ignore(methodNode.instructions.getFirst(), this.cursor);
                this.next();
            } else {
                this.cursor = Matcher.skipNonOpcodes(methodNode.instructions.getFirst());
            }
            ArrayList<AbstractInsnNode> ignore = new ArrayList<AbstractInsnNode>();
            int maskVar = Matcher.maskVar(methodNode.desc, constructor);
            while (this.cursor.getOpcode() == 21 && ((VarInsnNode)this.cursor).var >= maskVar) {
                this.next();
                this.nextIs(126);
                this.nextIs(153);
                if (this.cursor == null) {
                    return;
                }
                ignore.add(this.cursor);
                this.cursor = ((JumpInsnNode)this.cursor).label;
                this.skipNonOpcodes();
            }
            for (AbstractInsnNode i : ignore) {
                output.ignore(i, i);
            }
        }

        private static int maskVar(String desc, boolean constructor) {
            Type[] argumentTypes = Type.getMethodType((String)desc).getArgumentTypes();
            int slot = 0;
            if (constructor) {
                ++slot;
            }
            int firstMaskArgument = argumentTypes.length - 1 - KotlinDefaultArgumentsFilter.computeNumberOfMaskArguments(argumentTypes.length);
            for (int i = 0; i < firstMaskArgument; ++i) {
                slot += argumentTypes[i].getSize();
            }
            return slot;
        }
    }
}

