/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.nio.file.Path;
import java.util.function.Predicate;

class ClasspathFilters {
    static final String CLASS_FILE_SUFFIX = ".class";
    private static final String PACKAGE_INFO_FILE_NAME = "package-info.class";
    private static final String MODULE_INFO_FILE_NAME = "module-info.class";

    ClasspathFilters() {
    }

    static Predicate<Path> classFiles() {
        return file -> ClasspathFilters.isNotPackageInfo(file) && ClasspathFilters.isNotModuleInfo(file) && ClasspathFilters.isClassFile(file);
    }

    static Predicate<Path> resourceFiles() {
        return file -> !ClasspathFilters.isClassFile(file);
    }

    private static boolean isNotPackageInfo(Path path) {
        return !path.endsWith(PACKAGE_INFO_FILE_NAME);
    }

    private static boolean isNotModuleInfo(Path path) {
        return !path.endsWith(MODULE_INFO_FILE_NAME);
    }

    private static boolean isClassFile(Path file) {
        return file.getFileName().toString().endsWith(CLASS_FILE_SUFFIX);
    }
}

