/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.bcoview.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.bcoview.BytecodeOutlinePlugin;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;

class BCOViewSelectionProvider
implements IPostSelectionProvider {
    private IPostSelectionProvider realProvider;
    private final List<IPostSelectionProvider> selProviders = new ArrayList<IPostSelectionProvider>();
    private ISelection selection;

    public void setCurrentSelectionProvider(IPostSelectionProvider provider) {
        if (!this.selProviders.contains(provider)) {
            BytecodeOutlinePlugin.log(new Exception("Current selection provider is not registered yet"), 2);
            return;
        }
        this.realProvider = provider;
        if (this.selection != null) {
            this.realProvider.setSelection(this.selection);
        }
    }

    public void registerSelectionProvider(IPostSelectionProvider provider) {
        if (!this.selProviders.contains(provider)) {
            this.selProviders.add(provider);
        }
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        for (IPostSelectionProvider provider : this.selProviders) {
            provider.addPostSelectionChangedListener(listener);
        }
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        for (IPostSelectionProvider provider : this.selProviders) {
            provider.removePostSelectionChangedListener(listener);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        for (IPostSelectionProvider provider : this.selProviders) {
            provider.addSelectionChangedListener(listener);
        }
    }

    public ISelection getSelection() {
        return this.realProvider != null ? this.realProvider.getSelection() : null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        for (IPostSelectionProvider provider : this.selProviders) {
            provider.removeSelectionChangedListener(listener);
        }
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        if (this.realProvider != null) {
            this.realProvider.setSelection(selection);
        }
    }
}

